{*************************************************************************
 ***                     CLIPBOARD                                     ***
 *************************************************************************}
{Although the Editor.pas clipboard is ok for editor views, it's not much
use as a general purpose one.  This one should be expandable for any
purpose...}
unit ClipBrd;

interface

uses objects, lstrings;

type
	PBuffer = ^TBuffer;
	TBuffer = array[0..65500] of Char;

	PClipBoard = ^TClipBoard;
	TClipBoard = object(TObject)
		Data : TLongString;
		constructor Init;
		destructor Done; virtual;

		procedure Clear;
		function HasContent : boolean;

		function PutBlock(const B : PBuffer; const Length : word) : boolean; {true if successful}
		procedure GetAsBlock(var B : Pbuffer; var Length : word); {do NOT dispose of!}

		function PutString(const S : string) : boolean;
		function GetAsString : string;
	end;

var
	ClipBoard : PClipBoard;

implementation

uses
	global,
	Minilib;

constructor	TClipBoard.Init;
begin
	inherited Init;
	LSNew(Data);
end;


destructor TClipBoard.Done;
begin
	inherited Done;
	LSDispose(Data);
end;

{might be useful as a low-memory task}
procedure TClipBoard.Clear;
begin
	LSDispose(Data);
	LSNew(Data);
end;

function TClipBoard.HasContent;
begin
	HasContent := Data.Length>0;
end;


{=========== BLOCK ===============}
function TClipBoard.PutBlock;
begin
	LSClear(Data);
	LSAppendBlock(Data, B^, 0, Length);
	PutBlock := True;
end;

procedure TClipBoard.GetAsBlock;
begin
	B := PBuffer(Data.Data);
	Length := Data.Length;
end;


{======== STRINGS =================}
function TClipBoard.PutString;
begin
	LSClear(Data);
	LSAppendStr(Data,S);
	PutString := True; {should really check and see if append worked}
end;

function TClipBoard.GetAsString;
begin
	GetAsString := LS2String(Data);
end;


begin
	New(ClipBoard, init);
end.
