{**************************************
 ***   COUNTRY SCODES               ***
 **************************************}
{Separated from address so that units don't
keep pulling in kdirctry, etc from that unit}
unit Country;

interface

uses scodes, files, tuiedit;

type
	PCountrySCode = ^TCountrySCode;
	TCountryScode = object(TScodeItem)
		TelCode : string[4]; {code for dialling in}
		IntLine : string[4]; {code for dialling out}

		constructor Init(const NCode, NDesc, NTelCode, NIntLine : string);
		constructor Load(var S : TDataStream);
		procedure Store(var S : TDataStream);
		procedure AddEditFields(P : PObjectEditBox);           virtual;
	end;

implementation

uses objects, tasks, global;

constructor TCountrySCode.Init;
begin
	inherited Init(NCode, NDesc);
	TelCode := NTelCode;
	IntLine := NIntLine;
end;

constructor TCountrySCode.Load;
begin
	inherited Load(S);
	S.Read(TelCode, 5);
	S.Read(IntLine, 5);
end;

procedure TCountrySCode.Store;
begin
	inherited Store(S);
	S.Write(TelCode, 5);
	S.Write(IntLine, 5);
end;

procedure TCountrySCode.AddEditFields(P : PObjectEditBox);
var R : TRect;
begin
	inherited AddEditFields(P);
	P^.GrowTo(P^.Size.X, P^.Size.Y+2); {make room for below}
	P^.InsTitledField(9,4, 4, 1, 'Tel +', New(PInputELine, init(R,4)));
	P^.InsTitledField(9,5, 4, 1, 'Int Line', New(PInputELine, init(R,4)));
end;


const
 RCountrySCode : TStreamRec = (
	 ObjType : srCountrySCodeItem;
	 VmtLink : Ofs(TypeOf(TCountrySCode)^);
	 Load : @TCountrySCode.Load;
	 Store : @TCountrySCode.Store
 );

function CreateCountrySCodeItem(const NCode, NDesc : string) : PSCodeItem; far;
begin
	CreateCountrySCodeItem := New(PCountrySCode, init(NCode, NDesc, '',''));
end;

{For some reason this unit's init gets called before scodes, so the
registerscode gets lost when scode initialises them all..., this is a way
of avoiding that - using the startup tasks}
procedure RegSCode; far;
begin
	RegisterSCodeType(scCountries, 'COUNTRY.SC', 'Countries', CreateCountryScodeItem);
end;


begin
	RegisterType(RCountrySCode); {Register for streams}
	RegisterTask(StartupTasks, 5, @RegSCode);
end.

