{*************************************
 ***       DEBUG OBJECT            ***
 *************************************}
{$O+}
unit Dbg;

interface

uses objects;

type
	TDebug = object(TObject)

		Enabled : boolean;

		F : text;
		FName : FNameStr;

		constructor Init(NFName : FNameStr);

		procedure Enable;
		procedure Disable;

		procedure Write(const S : string);
		procedure Writeln(const S : string);

		procedure Open; virtual;
		procedure Close;

		procedure Clear;
	end;

	{always overwrites last message}
{	use clear
{	TNotelet = object(TDebug)
		procedure Open; virtual;
	end;{}


var Debug, DebugNote : TDebug;

implementation


constructor TDebug.Init;
begin
	inherited Init;
	FName := NFName;
end;

procedure TDebug.Enable;
begin
	Enabled := True;
end;

procedure TDebug.Disable;
begin
	Enabled := False;
end;

procedure TDebug.Open;
begin
{$I-}
	assign(F, FName);       {Set name}
	append(F);                {Open with append}
{$I+}
	if IOResult=2 then rewrite(F);
end;

procedure TDebug.Close;
begin
	System.Close(F);
end;

procedure TDebug.Clear;
begin
	assign(F, FName);
	rewrite(F);
	Close;
end;

procedure TDebug.Write;
begin
	if Enabled then begin
		Open;
		system.write(F, S);
		Close;
	end;
end;

procedure TDebug.Writeln;
begin
	Write(S+#13#10);
end;


{procedure TNotelet.Open;
begin
	assign(F, 'DEBUGNTE');
	rewrite(F);
end;{}



begin
	Debug.Init('DEBUG');
	Debug.Enable;

	DebugNote.Init('DEBUGNTE');
	DebugNote.Enable;
end.
