{*************************************************************************
 **                        SMALL UNIT FOR HANDLING HINTS RESOURCE FILE  **
 *************************************************************************}
{Hints resource file is made by running new TVHC (now called MAKEHELP) which
creates hints from the help.txt file (see comments within program).  This
unit provides safe access to that resource file - called HINTS.RES - returning
nothing if no file}

unit DoHints;

interface

function GetHint(const hcContext : word) : string;

implementation

uses
			tasks,
			minilib,
			dosutils,
			tuimsgs,
			help,
			objects;

var
	HintsFile : PBufStream;
	Hints : PStringList;
	HintsFileName : String;

function GetHint;
var H : string;
begin
	if hcContext = hcNoContext then
		GetHint := 'Press [F1] for Help'
	else begin
		if Hints<>nil then begin
			H := Hints^.Get(hcContext);
			if H='' then GetHint := 'Press [F1] for Help, [Shft][F1] for index' else GetHint := H;
		end else
			GetHint := 'No Hints available';

	end;
end;


procedure ShutDownHints; far;
begin
	if Hints<>nil then dispose(Hints, done);
	if HintsFile<>nil then dispose(HintsFile, done);
end;

var
	I : integer;

begin
	RegisterType(RStringList); {note, cannot register this in same program as any strmakelist}

	HintsFileName := 'HINTS.RES';
	if not FileExists(HintsFileName) then HintsFileName := GetPath(ParamStr(0))+HintsFileName;
	for I := 1 to ParamCount do
		if ucase(Copy(ParamStr(I),1,7))='/HINTS=' then HintsFileName := Copy(ParamStr(I),8,99);

	if not FileExists(HintsFileName) then begin
		ProgramWarning('No hints file '+HintsFileName+#13#10'Hints will not be available',hcNoContext);
		HintsFile := nil;
		Hints := nil;
	end else begin
		New(HintsFile, init(HintsFileName, stShareReadOnly, 1024));
		Hints := PStringList(HintsFile^.Get);
		if Hints=nil then
			ProgramWarning('Could not load hints from '+HintsFileName+#13#10
											+N2Str(HintsFile^.Status)+'/'+N2Str(HintsFile^.ErrorInfo)
											+#13#10'Hints will not be available',hcNoContext);
	end;

	RegisterTask(ShutDownTasks, 10, @ShutDownHints);
end.
