{******************************************************************
 ***                 EDIT AN ASCII FILE                         ***
 ******************************************************************}
{The routine supplied by Turbo Vision requires far too much memory
etc - this one will edit a file up to 10,000 characters.... Pass a file
name and a width which is wordwrapping width}
{$I compflgs}

unit EditFile;

INTERFACE

uses objects;

function EditTextFile(var FullFileName : FNameStr; const Ext : string) : word; {Standard access point to:}

{width specifies word-wrap width (0 for off), Go for initial search string to place
cursor before editing, Ext specifies allowed extensions when saving}
{returns whether OK or cancel pressed}
function FileEditor(var FullFileName : FNameStr; const Width : integer;
										const Go, Ext : string; BufferSize : word;
										const hcType : word) : word;

const
	StdBufferSize = 10000;

{asks for what name to give a new file - useful in many other places...
should really go in edit I suppose, or make some kind of stddlg thingy?}


IMPLEMENTATION

uses
{$IFDEF WINDOWS}
	wui,	{windows}
{$ELSE}
	drivers, tui,views,dialogs, tuimsgs, tuiedit,	{text}
	memory,
{$ENDIF}
			editor, {indicator}
			dosutils, {for splitting path/name}
			app,
			help,
			tuiboxes,
			messtext,
			inpfname, {for entering save filename}
			lstrings, notes;



{*************************************************
 ***            FILE EDITOR BOX                ***
 *************************************************}

type
	PFileEditBox = ^TFileEditBox;
	TFileEditBox = object(TEditBox)
		TextView : PInputFreeText;
		constructor Init(Bounds : TRect; NTitle : string; WrapWidth : integer; BufferSize : word);
	end;


constructor TFileEditBox.Init;
var R : TRect;
		Indicator : PIndicator;
begin
	inherited Init(Bounds, NTitle, nil);

	HelpCtx := hcForms;

	Options := Options or ofCenterX or ofCenterY;

	R.Assign(1,Size.Y-1,13,Size.Y); {Row, Col, modified indicator}
	New(Indicator, init(R));
	Insert(Indicator);

	R.Assign(1,1,Size.X-1,Size.Y-1);
	New(TextView, Init(R, BufferSize, WrapWidth, Indicator));
	Insert(TExtView);

	Insert(TextView^.VSCrollBar);
end;


{======== FILE EDITOR INTERFACE FUNCTION ==================}
{For use with inpfname, a standard function provides interface to
different editors}
function EditTextFile;
begin
	EditTextFile := FileEditor(FullFileName, 0, '',Ext, StdBufferSize, hcEditFile);
end;


{******************************************************
 ***            EDIT FILE                           ***
 ******************************************************}
function FileEditor;
		{view}
var R : TRect;
		Title : string;
		EditBox : PFileEditBox;
		Data : PLetterData;

		{file}
		FileToEdit : file;
		SizeOfFile : longint;
		LastIOResult : word;
		Control : word;

begin
	New(Data, init); {heap data object}

	{--- Load data from file ----}
	if GetFileName(FullFileName)<>'' then begin
		THinkingOn('Reading file');
		assign(FileToEdit, FullFileName);
{$I-}
		reset(FileToEdit,1);
		LastIOResult := IOResult;
{$I+}
		if LastIOResult = 0 then begin
			{Opened OK}
			SizeOfFile := FileSize(FileToEdit);
			{--- Transfer data from disk ---}
			if SizeOfFile>(MemAvail - LowMemSize*16) then begin
				ProgramWarning('Memory Low'#13'Cannot load complete file',hcMemoryLowMsg);
				LSSetLen(Data^.Text, MemAvail div 2);
			end else
				LSSetLen(Data^.Text, SizeOfFile);
			BlockRead(FileToEdit, Data^.Text.Data^, Data^.Text.Length{, ReadCount{});
			Close(FileToEdit);
		end else begin
			{Some problem with opening file}
			if LastIOResult<>2 then begin  {file not found is OK}
				MessageBox(	'FILE EDITOR',
										'Could not open '+FullFileName+#13#10+IOError(LastIOResult),
										mfContinueButton+mfWarning+mfWarningBleep,
										hcIOErrorMsg);
				ThinkingOff;
				dispose(Data, done);
				exit;
			end;
		end;
		ThinkingOff;
	end; {filename<>''}

	{-- Make File editor box ----}
	R.Assign(0,0, 77, 20);
	Title := GetFileName(FullFileName);
	if (Title = '') or (Title[1]='.') then Title := 'New File '+Title;
	New(EditBox, Init(R, Title,Width,BufferSize));
	EditBox^.TextView^.GoString := Go; {<BEGIN> marker}
	EditBox^.TextView^.SetData(Data);
	EditBox^.HelpCtx := hcType;

	repeat
		Control := Desktop^.ExecView(EditBox);

		if Control <> cmCancel then begin
			{--- Store away ------}
			EditBox^.TextView^.GetData(Data);

			if (GetFileName(FullFileName)='') or (Copy(GetFileName(FullFileName),1,1)='.') then
				Control := SaveAsBox(FullFileName,Ext); {get a file name}

			if Control <>cmCancel then begin {don't do if above cancelled}
				{-- Transfer text to disk ----}
				Assign(FileToEdit, FullFileName);
				rewrite(FileToEdit,1);
				BlockWrite(FileToEdit, Data^.Text.Data^, Data^.Text.Length);
				close(FileToEdit);
			end else
				Control := cmRetry; {so you go back to editbox}
		end;
	until (Control=cmCancel) or (Control=cmOK);

	Dispose(EditBox, done);

	dispose(Data, done);

	FileEditor := Control;
end;




end.
