{*********************************************************************8
 ***                 GLOBAL DEFINITIONS                             ***
 **********************************************************************}
{{$I compflgs no point in doing this}
{Very useful in a unit because then other units can use 'em...}
unit Global;

INTERFACE

uses
{$IFDEF Windows} windrvrs; {$ELSE}	drivers; {$ENDIF}		 {for kb defs}

type
	{---- types ------}
	PFile = ^File;
	PLongInt = ^Longint;
	TBytes = array[0..255] of byte; {used for debug mostly}
	PBytes = ^TBytes;
	TBlock = array[0..65500] of byte;
	PBlock = ^TBlock;
	TLongWord = record Lo,Hi : word; end;

	{comment this out sometime and replace with use of hi() and lo()}
{	TDoubleByte = record Lo,Hi : byte; end;{}

	TVer = record
		Main, Sub : byte;
		Release : char;
	end;

var
	IdleOff : boolean;

	{direct var access to some setup parameters}
	DataPath : string;
	FormsPath : string;
	PrintersPath : string;
	WorkPath : string;

	UserCoyID : longint;
	TerminalNo  : byte;    {Which terminal this is on a network}

	DeadDataMode : boolean; {mark "DEAD DATA" in configuration when about to
								enter lots of past data, for automatic links to be treated
								a little differently.  See Livestock unit}
{	TekkyMode : boolean;   Now replaced with compiler flag $DEFINE fixit
													for use in separate program Fixit}

var
	DataVer : TVer;

const
	ProgVer : TVer = (Main : 4; Sub : 3; Release : 'g');
	{v4.2, on return to Kenya....}

	{v4.3 - corrected history note & address sizes, added ptr2outtray to invoice}
	{increased delivery order size for Rongai, as one record seemed to overflow}
	{release b after cocking up and deleteing all files, 29/4, so maybe some out-of-date source...}
	{c after changing dial-up stuff, 30/4}
	{d added site to jobid, fixes for NSS, 3/5}
	{e installed at SBS UK (& some pre-ver at NSS?, Katy of Options?)}


	SortKeyStart = -$0FFFFFF; {used for history, etc, to set sortkey so item
															appears at start}

	MaxLockTerminals = 15; {locking is done with one nybble for terminal, one for count}
	{any terminals above this number will not lock}
	MaxTerminal 			= 99;

	{--- common hook types ---}
	hkMore = 1;
	hkHistory = 2;

{$IFDEF Bombed}
{	BombDate = '29-11-1993';{}
{$ELSE}
{	Bombdate = '  -  -    ';{}
{$ENDIF}

	WinCount: Integer = 0;

	PoundSign = '';

	NUL	= #0;
	ACK	= #6;
	BEL	= #7;
	BS	= #8;
	HT	= #9;
	LF	= #10;
	VT	= #11;
	FF	= #12;
	CR	= #13;
	NAK	= #21;
	ESC	= #27;
	SP	= #32;
	DEL	= #127;

	{--- display line formatting chars}
	{as above but setting 128 bit so it doesn't confuse with
	lock markers, etc}
	Tab 			= #137;
	RightSet 	= #146; {CtrlR - for display line}
	SkipTab 	= #138;

{  EndParaChar = #20;{}

	XON		= ''; (* Ctrl-Q *)
	XOFF	= ''; (* Ctrl-S *)

	ON		= TRUE;
	OFF		= FALSE;

	CRLF = CR+LF;

	{see help unit for help constants}

	{Bias on sorting - ie when sort key is equal, do we insert at beginning
	of list or end?}
	biEnd 	= True;
	biStart = False;

	{Extensions to Stream Status errors}
	{Files}
	stOutOfRange = 1; {attempt to get/put <0 or >size of file}
	{Devices}
	stAbandoned = 11; {user abandoned output}
	stOpenError = 12;
	stFormOpenError = 13;{couldn't open form}
	stFormReadError = 14;

	stCloseError = -7;

	{Error info}
	eiLocked = 33; {same as DOS error}

	{Editor types}
	edInternal  = 0;      {Turbo Vision Memo editor}
	edWP51      = 1;      {WordPerfect 5.1}
{	edASCII     = 2;      {Ordinary ASCII editor - eg EDIT}

	{--- misc strings ----}
	InvoiceColHeader = 'Date        Ref       For      Due';

	{--- window menus ---}
	mnPrint = '~P~rint';
	mnTag 	= 'Ta~g~';
	mnEdit 	= '~E~dit';
	mnView  = '~V~iew';

	{for natypes, see minilib}

	{--- Additional I/O codes ---}
	ioBadResponse = 198; 	{for modem}
	ioTimeOut = 199;      {for serial port}

	{---- Extensions -----}
{	smAuto = 0;     {automatice screen mode}

	{--- standard keys ---}
	kbNone = $0;

	kbShift = -32;   {Shifted/capitals subtracts 32}

	kbA = 7777;
	kbB = 12386;
	kbC = 11875;
	kbN = 12654;
	kbI = 5993;
	kbAsterisk = 2346;

	kbCtrlB = 12290;
	kbCtrlC = 11779;
	kbCtrlI = 5897;
	kbCtrlP = 6416;

	{oh I wish}
{	kbCtrlUp = 0;  {would be nice for page up/down alts}
{	kbCtrlDn = 0;
	kbShiftUp = 0; {super list}
{	kbAltIns = 0; {child insert?}


	{---- setup groups ------}
	sgDirectory = 'Directory';


	{---- setup identifiers --------}
	{for making sure no program typos dealing with programsetup.get, etc}
  siTerminal = 'TERMINAL';

	siDataPath = 'DATA PATH';
	siTerminalNo = 'TERMINAL';
	siDeadDataMode = 'DEAD DATA';
	siCountry = 'COUNTRY'; {this is not just *default* country, but the one
													you are assumed to be *in* (for labels, dialling, etc)}
	siVideoMode = 'VIDEO MODE';
	siPalette = 'PALETTE';

	siDefaultPrinter = 'PRINTER';
	siDefaultModem = 'MODEM';
	siDefaultVAT = 'DEFAULT VAT';

	siImpersonalDear = 'IMPERSONAL DEAR'; {ie sir/madam, etc}

  siMemDueLeeway = 'MEMBERSHIP DUE LEEWAY';

	siDefaultMeasure = 'DEFAULT UNITS';
	siNewsFlashInt = 'NEWS FLASH INTERVAL';

	siUserCoyID = 'USER COY ID';

	siAutoNew = 'AUTO NEW';

	siDefadType = 'DEF ADTYPE';
	siDefedType = 'DEF EDTYPE';

	siDefDirTopList = 'DEF TOP LIST';

	siCreateLetterBackup = 'CREATE BACKUP';

	siStartStdView = 'START STD VIEW';
	{etc}

	{for other sixxxx (setup identifier) strings, see individual units}

	{----- List types -----------}
	{General types}
	lsFilesView = $0100;
	lsSCodes    = $0200;

	lsIndexedJimmy = $1000;
	lsHook  = $2000;
	lsIndex = $3000;
	lsChain = $4000;

	{Specific/special lists}
	lsNone = 0; {used for non-special lists, eg scodes, etc}
	lsDesktop = 1; {not really a list, but it has a "new" option, which can
									be registered in the same sort of way}

	lsArchive = 2;

	lsDirectory = 3;
{	lsStaff = 4;{}
	lsUsers = 5;

	{in/out trays}
	lsLettersOut = 6;
	lsInvoicesOut = 7;

	lsHistory = 10;
	lsMoreAbout = 11;
	lsAddresses = 12;

	lsGoodsServices = 13;

	lsLiveStock = 20;
	lsLiveStockHistory = 21;
	lsLiveStockMore = 22;
	lsHerd = 23;
	lsHerdHistory = 24;
	lsHerdBulls = 25;

	lsDiary =30;
	lsDiaryRepeaters = 31;
	lsDiaryTodo = 32;
	{etc}

	lsContacts = 33;
	lsAccounts = 34;

	{rally}
	lsLeg 					= 40;
	lsRoute		 			= 41;
	lsStartList			= 42;
	lsControl				= 43;
	lsCar 					= 46;
	lsRace					= 47; {cars in race order}
	lsCarTiming 		= 48;
	lsControlTiming = 49;

	{order processing}
	lsSalesItems 		= 50;
	lsInvoiceItems 	= 51;
	lsPayments 			= 52;
  lsEstimateItems	= 53;

	{rongai}
	lsVehicles 		= 60;
	lsShips 			= 61;
	lsContainers 	= 62;
	lsPartNum			= 63;
	lsPartCatgy			= 64;
	lsPartSuppliers = 65;

	{options - telesales/courses}
	lsStudents = 70;
	lsMarkSheets = 71;
  lsAssessments = 72;

	{---- CUI/View control keys ----------}
	{ie, try and keep standard to everyone else!}
	kbHelp   		= kbF1;				ksHelp 			= 'F1';        {general help, one level up from Ctrl-F1}
	kbHelpLow   = kbCtrlF1;		ksHelpLow		= 'Ctrl-F1';   {low-level help, ie on button, measurement field, etc}
	kbHelpIndex = kbShiftF1; 	ksHelpIndex = 'Shift-F1';
	kbHelpLast 	= kbAltF1;		ksHelpLast 	= 'Alt-F1';

	kbSearch		= kbF2;				ksSearch		= 'F2';

	kbSetup 		= kbShiftF2;	ksSetup 		= 'Shft-F2';

	kbClose  		= kbAltF4;		ksClose			= 'Alt-F4';

	{window shape/size control}
	kbZoom   	= kbF5;        	ksZoom   	= 'F5';
	kbReSize 	= kbCtrlF5;			ksReSize 	= 'Ctrl-F5';

	kbNextWin = kbF6;					ksNextWin = 'F6';
	kbPrevWin = kbShiftF6;		ksPrevWin = 'Shft-F6';

	kbCancel 	= kbESC;				ksCancel 	= 'ESC';

	kbDelItem	= kbShiftDel; 	ksDelItem = 'Shft-Del';
	kbCut	  	= kbShiftDel;  	ksCut   	= 'Shft-Del';
	kbPaste  	= kbShiftIns;  	ksPaste  	= 'Shft-Ins';
	kbCopy		= kbCtrlIns;		ksCopy		= 'Ctrl-Ins';

{	kbTagItem = kbAsterisk;		ksTagItem = '*'; as well}
	kbTagItem = kbF7;					ksTagItem = 'F7';

	{---- Others/Kameleon ----------------}
	kbList	 		= kbUp;				ksList 	= 'Up';
	kbSuperList = kbPgUp; ksSuperList = 'Pg-Up';

	kbHistory 	= kbAltH;		ksHistory = 'Alt-H';
	kbMore			= kbAltM;		ksMore		= 'Alt-M';
	kbAccounts	= kbAltI;		ksAccounts= 'Alt-I';

	kbChange 		= kbF4;			ksChange 	= 'F4';
	kbSuperChange = kbShiftF4; ksSuperChange = 'Shft-F4';

	{Print}
	kbPrint 		= kbF8;   		ksPrint  = 'F8';  {brings up print box}
	kbLabel 		= kbShiftF8;	ksLabel	 = 'Shft-F8';
	kbDeferLabel = 0; 				ksDeferLabel = '';{}
	kbDefer 		= 0;  				ksDefer  = '';
{	kbPrintBox 	= kbAltF8;		ksPrintBox = 'Alt-F8';{}
	kbFax   		= kbCtrlF8;		ksFax    = 'Ctrl-F8';{}

	kbPrintList = kbF9;				ksPrintList = 'F9';
	kbStatement = kbShiftF9;  ksStatement = 'Shft-F9';
	kbLastPage  = kbAltF9;		ksLastPage  = 'Alt-F9'; {used by perf ent}

	kbFinish = kbF10;   		ksFinish = 'F10';

	kbDial	 = kbAltD;			ksDial = 'Alt-D';

	kbCopyJimmy = kbCtrlIns; ksCopyJimmy = 'Ctrl-Ins';

	kbAccept 		= kbEnter; 	ksAccept 		= 'Enter';

	kbNew    		= kbIns;		ksNew 			= 'Ins';
	kbPeerNew 	= kbCtrlP;	ksPeerNew 	= 'Ctrl-P';
	kbChildNew 	= kbCtrlC;	ksChildNew 	= 'Ctrl-C';


	{------ Stream Admin ID's -----------}
	{Put the major data file(s) at the start - this means that when
	we do a run through shutting down all files & opening afterwards, eg
	for wordperfect, we don't hit snags with admin files (eg indexes)
	logging on to the data files before we've opened them again}
	fiJimmys = 1;

	{--- Indexes ----------}
	fiArchiveIdx = 2; {general purpose archive index}
	ixArchive = 0; {for setting pointers, for above}

	{Directory}
	fiFullDirIdx = 3;
	fiCatDirIdx = 4;
{	fiStaffIdx = 5;{}
	fiUserIdx = 6;
	fiSpecialDirIdx = 7; {for making --> printing special extractions}

	{Products}
	fiCatProdIdx = 12;
	fiCodeProdIdx = 13;
	{reserve 11-20 for product indexes}
	fiFabricIdx = 14;

	{Diary index}
	fiDiaryIdx = 22;
	fiStaffDiaryIdx = 23; {sub index - ie by person for personal diaries}

	fiDiaryTodoIdx = 24;
	fiStaffDiaryTodoIdx = 25; {personal todo}

	fiDiaryActionIdx = 26; {diary repeaters/alarms}

	{---- Other data -----}
	fiTransactions = 30; {nominal ledger}


	fiFoundIdx = 31; {used for searches}

	{--- Chain-type admin -----}
	fiHooks = 32;

	{-- In/out trays --}
	fiLettersOutIdx = 33;
	fiInvoicesOutIdx=35;

	{---- String extensions -----}
	fiNoteText = 36;
	fiLetterText = 37;

	{----- ID Indexes -----------}
	fiWarrantyIdx = 40;
{	fiJobIDIdx = 41;
	fiInvoiceIDIdx = 42;
	fiEstimateIDIdx = 43;
	fiOrderIDIdx = 44;
	fiSalesOrderIDIdx = 45;

	{---- Documents --------}
	fiDocumentIdx = 47;

	{--- Livestock ----}
	fiFullStockIdx = 49; {ex-stock & livestock}
	fiLiveStockIdx = 50;
	fiHerdStockIdx = 51; {listed by herd}
	fiHerdIdx = 52;

	{--- Rally! ----}
	fiLegIdx = 60;
	fiCOntrolIdx = 61;
	fiCarNumberIdx = 63;
	fiCarRacePosIdx = 65;
	fiTimingsTable = 68;
	fiRouteIDIdx = 69;
{	fiCarRacePosClassIdx = 66;
{	fiCarGeogPosIdx = 67;{}

	{--- Membership ---}
	fiMemNumIdx 	= 70;
	fiMembersIdx 	= 71;
	fiMembersByClubIdx 	= 72;
	fiMembersByCatIdx 	= 73;

	{--- Rongai -----}
	fiVehicleIdx = 80;
	fiShipIdx = 81;
	fiContainerIdx = 82;
	fiRongaiContainerIdx = 83;
	fiPartNumIdx = 84;
	fiPartCatgyIdx = 85;

	fiMaxfi = 99; {see files}

	{-- Standard Commands --}
	{$IFDEF Windows}
	cmCancel = 11;
	cmOK = 10;
	cmYes = 9;
	{$ENDIF}


	{colorsel uses commands 71..76}


	cmNone = 100;

	cmEdit = 101;

	cmDel = 103;

	{beware - some of these commands match the cmnew commands for early srtypes - see sr's below}
	cmAccept = 104;
	cmReDraw = 105; {ask all subviews, esp lists, to redraw}

	cmRetry = 106;    {For errors, etc}
	cmOverride = 107;

	cmList = 108;
	cmSuperList = 109;

	cmStore = 110;  {Force "store" - might have more specific meaning than OK
									eg when print method may modify fields and return "store" to force
									re-storing, whereas OK may just mean it printed OK}

	cmHeap = 111;   {Used to update heap view}

	cmSearch = 112;

	cmListPaste = 113;
	cmListCut = 114; {as opposed to editor cut}

{	cmTotal = 120;{}

	cmHelp 			= 120;
	cmHelpLow 	= 121;
	cmHelpIndex = 122;
	cmHelpLast 	= 123;

	cmUpdateAll=126; {message to update all views - also cmredraw for lists}

	cmGetCountryView = 127; {any country scode view ought to return true - used by inptelnum}

	{jimmy storing/view updating & checking}
	cmJimmyStored 	= 130; {used to update list views once jimmy stored}
	cmGetFocusedJimmy = 131; {sent around views, should return selected jimmy in focused view}
	cmStoreJimmy 		= 132; {instruction to store jimmy}
	cmIsJimmyEdited = 133; {for looking through edit boxes for an already existing editjimmy}
	cmJimmyLocked = 134; {jimmys lock has changed - update views}
	cmFocusJimmy = 135;		{focuses on jimmy event.infoptr}

	cmCompareLoc = 136; {for comparing locations of boxes}

	{general purpose buttons}
	cmButton1 = 140; {Used for odd buttons in special places}
	cmButton2 = 141;
	cmButton3 = 142;
	cmButton4 = 143;
	cmButton5 = 144;
	cmButton6 = 145;
	cmButton7 = 146;

	cmButton : array[1..7] of word = (140,141,142,143,144,145,146); {same as above but as an array}

	cmTabSelected = 150; {for tabbed views see tuiedit.pas}

	cmSkip = 152;

	cmMerge = 153;

	cmKamDosShell = 156;

	cmChildNew = 160;
  cmPeerNew = 161;

	cmNewPage   = 168;

	cmForceLink = 169;
	cmCheckLink = 170;

	cmDial = 171;

	cmEditPalette = 172;

	cmCascadeView = 173; {cascade view to previous}
	cmUncascadeView = 174; {restore}

	cmCheckFileVer = 175; {used to update any lists by making them check their view ver vs the file ver}

	cmDateCHanged = 176;

	cmPasteNode = 180;
	cmCopyJimmy = 181;

	cmSetLinker = 185;
	cmClearLinker = 186;

	cmInvalid = 190; {Used for special validation checks after ExecView to mark for re-input}

	cmUpdateFromLink = 191;  {for links between fields - one may send another a cmUpdateFromLink command
														with infoptr pointing to self}

	cmSetChangedIndicator = 192; {for broadcasting events from changed input lines to editors indicator}
	cmGetChangedIndicator = 193; {for finding out whether changed}

	cmSoftReturn = 195;

	{-- Application Commands --}
	{Accept for input lines - eg input scode}
	{Should be in range 200-209, so that inpflds EditBox can trap for them}
	cmAcceptScode = 201;
{	cmAcceptDirectoryItem = 202;{}
	cmAcceptJimmy = 203;
	cmAcceptChainItem = 204;
{	cmAcceptProductItem = 205;{}
	cmAcceptFName = 206;
	cmAcceptNum = 207; {for calculator}

	{-- different kinds of output instruction --}
	cmPrint 		= 210;
	cmPrintBox 	= 211;
{	cmDeferPrint = 212;{}
	cmFax 			= 212;{}

	cmPrintList 			= 213;
	cmPrintTaggedList = 214;

	cmPrintAll 		= 215;
	cmPrintTagged = 226;


	cmHaveYouAMenu = 230;

	cmWP = 231;
	cmDeferredLabels = 233;
{	cmDeferredLetters = 233;
	cmDeleteDeferredLetters = 234;{}
	cmDeferredInvoices = 235;
	cmDeleteDeferredInvoices = 236;

	cmPasswordRelease = 240;
	cmShowAbout = 241;
	cmShowStatus = 242;

	cmCalculator = 243;
	cmCalendar = 244;
	cmASCIITable = 245;

{	cmLoadFile = 250; {for editors - loading file into text}
{

	{see also below for cm's reserved for selecting sr types from menus}


	{--- Stream Object ID's ---}
	{NB THESE *SHOULD* BE OVER 1000. DIFFICULT TO CHANGE NOW DUE TO
	ALREADY SAVING SOLITAIRE DATA AT 100+}
{  srPrinter = 100;       {Printer stream}
	srNone       =    0;     {For restrictions, etc}
	srv1Person  =  101;     {People database}
	srIndexItem  =  102;     {Index item for index stream}
	OldsrSCode   =  103;
	srSCodeItem  = 1003;
{	srApt        = 1004;    {For Diary}
	srCurtainQuoteItem = 1005;     cmNewCurtainQuoteItem = 1005;
	srHook  =  106;     {Chain item for chain stream}
{	srOrderHook = 1007;				{hooks for order processing}

{	srv2HardWare    =  107;     {cmNewHardWare =  107;{}
	srv4Job        =  108;    {  cmNewJob     =  108;{}
{	srSCodeCollection = 109;
{	srJobCon     =  110;      cmNewJobCon  =  110;{}

{	srLockItem   = 1012;{}
	srDiaryEvent = 1013;			cmNewDiaryEvent  = 1013;
	srEDLtr      = 1014;			{cmNewEdLtr   = 1014;    cmNewDesktopEdltr = 1514;{}
	srTextItem   =  115;


	srv2AltAddress = 1016;      {cmNewAltAddress=1016;{}
	srWPLtr      = 1017;	{		cmNewWPLtr   = 1017;		cmNewDesktopWPLtr = 1517;{}
{	srv3Invoice		=1018; {before split invoice/estimate}
{	srOrderItem= 1019;			cmNewInvoiceItem = 1019;
{	srv2Medical    = 1021;      {cmNewMedical = 1021;{}
	srOutputFilter=1022;
{	srPaper      = 1023;{}
	srStdWPLetter  = 1024;    {cmNewStdWPLetter = 1024;{}
	srv2MoreNote = 1025;		{cmNewMoreNote = 1025;{}
{	srFabricInvItem = 1026;   cmNewFabricInvItem = 1026;{}

	srSimpleCostedSCode = 1027;
	srHeaderSCodeItem = 1028;
	srCountrySCodeItem = 1029;

{	srv2Software    = 1029;   {  cmNewSoftware = 1029;{}
{	srv2Membership  = 1030;   {  cmNewMembership = 1030; {}
	srv4CodedInvNode= 1031;		{	cmCodedInvNode = 1031;{}
{	srMaterialItem= 1032;     cmNewMaterialItem = 1032; {no longer used... v1?}
	srStockItem   = 1034;     cmStockItem     = 1034;
	srWindowItem  = 1035;     cmNewWindowItem = 1035;

	srGatheringSCodeItem = 1036;

	srv4Product     = 1037;   {  cmNewProduct = 1037;
	srProductCatIndexItem = 1038; {product category index item}

	srTransaction = 1039;     cmNewTransaction = 1039;

	{directory jimmys from v4.0 and prev}
	srOldPerson = 1040;
	srOldCompany = 1041;

	srv3DirCatSCodeItem = 1042; {now obsolete - special category codes -v3}
	srv4PaymentNode = 1043;
	srStdEdLetter = 1044;     {cmNewStdEdLetter = 1044;{}
	srProductInvNode = 1045;  {cmNewProductInvNode = 1045;{}
{	srDiaryEvent = 1046;       cmNewDiaryEvent = 1046;{}

	srFreeTextInvNode = 1047; cmNewFreeTextInvNode = 1047;
	srCodedJobItem = 1048;    cmNewCodedJobItem = 1048;

	srPureNode = 1049;
	srJimmyChainItem = 1050;

{	srTestJimmy = 1050; 			cmNewTestJimmy = 1049;{}

{	srInvoiceNode = 1051;			cmNewInvoiceNode = 1051;{}
	srv4PurchaseOrder = 1052;  	{cmNewPurchaseOrder = 1052;		{		cmNewDesktopOrder = 1552;{}

	srOwnedProduct = 1053;		cmNewOwnedProduct = 1053;

	srv4PackingSlip = 1054;
{	srProductSlipNode = 1055; cmNewProductSlipNode = 1055;{}

	srBriefSO = 1056;					cmNewBriefSO = 1056;

	srCQEdging = 1057;				cmNewCQEdging = 1057;
	srFabricQuoteItem = 1058; cmNewFabricQuoteItem = 1058;

	srFQScodeItem = 1059;			cmNewFQSCodeItem = 1059;

	srPayment = 1060;					cmNewPayment = 1060;

	{--- directory -----}
	srv4Member = 1070;					{cmNewMember = 1070;{now a person with membership attachment}
	srUser = 1071;						cmNewUser = 1071;
	srPerson = 1072;					cmNewPerson = 1072;
	srCompany = 1073;					cmNewCompany = 1073;
	srStaff = 1074;						cmNewStaff = 1074;


	srLiveStock = 1080;				cmNewLivestock = 1080;
	srHerd = 1081;						cmNewHerd = 1081;

	{New more-about stuff - ie moved from MSMORE to JIMMYS.DAT}
	srHardWare    =  1100;    cmNewHardWare =  1100;{}
	srAltAddress = 1101;     {old - see sraddress}
	srMedical    = 1102;      cmNewMedical = 1102;{}
	srMoreNote = 1103;				cmNewMoreNote = 1103;{}
	srSoftware    = 1104;     cmNewSoftware = 1104;
	srv4Membership  = 1105;
	srMembership  = 1107;     cmNewMembership = 1107;

	{more nodes for jobs, etc}
	srv4HWInvNode = 1110;			{cmNewHWInvNode = 1110;{}
{	srTooSmallCOdedOrderItem = 1111;	{cmNewCodedOrderItem = 1111;{}
	srFreeTextOrderItem = 1112; cmNewFreeTextOrderItem = 1112;
	srGoodsOrderItem = 1113; cmNewGoodsOrderItem = 1113;
	srCodedOrderItem = 1111;	cmNewCodedOrderItem = 1111;{}
	srPickHWOrderItem = 1114;	cmNewPickHWOrderItem = 1114;

	{new history jimmys}
	srv4Estimate = 1120;			{cmNewv4Estimate = 1120;{}
	srv4Invoice = 1121;       {cmNewvInvoice = 1121;{}
	srHistoryNote = 1122; 		cmNewHistoryNote = 1122;
	srSalesOrder = 1123;			cmNewSalesOrder = 1123;
	srGoodsIn = 1124;					cmNewGoodsIn = 1124;
	srMemRenewal  = 1125;     cmNewMemRenewal = 1125;
	srCrush = 1126;						cmNewCrush		= 1126;
	srLetter = 1127;					cmNewLetter   = 1127;
	srWeaning = 1128;					cmNewWeaning = 1128;
	srTransfer = 1129;				cmNEwTransfer = 1129;
	srService = 1130;					cmNEwService = 1130;
	srLiveStockQNote = 1131;	cmNewLiveStockQNote = 1131;
	srReport = 1132;					cmNewReport = 1132;

	{order descendants}
	srInvoice = 1150;					cmNewInvoice = 1150;
	srEstimate = 1151;				cmNewEstimate = 1151;
	srJobSheet = 1152;				cmNewJobSheet = 1152;
	srPurchaseOrder = 1153;		cmNewPurchaseOrder = 1153;
	srQuickInvoice = 1154;		cmNewQuickInvoice = 1154;
	srPackingSlip = 1155;			cmNewPackingSlip = 1155;

	{shortcodes}
	srUnitScodeItem = 1200;
	srDirCatScodeItem = 1201; {was srch code}
	srUserFormScode = 1203;
	srAccCatScodeItem = 1204;
	srVATRateSCodeItem = 1205;
	SrCurrencySCode = 1206;
	srNumSCodeItem = 1207;
	srCostedSCodeItem = 1208;
  srDialMacroSCodeItem = 1209;

	{diary}
	{old diary repeater = 1250 - wasn't big enough - only in early rongai}
	srDiaryRepeater = 1251; 	cmNewDiaryRepeater = 1251;
	{labels}
{	srLabelPaper = 1300;{}

	{addresses}
{	srSmallAddress = 1306; {was too small to include tel nos safely}

	srAddress = 1306;					cmNewUKAddress = 1307;
														cmNewPOBoxAddress = 1308;
														cmNewUSAAddress = 1309;
														cmNewEuropeanAddress = 1310;
														cmNewemailAddress = 1311;

	{documents}
	srPriceList = 1350;	cmNewPriceList = 1350;
	{srProductItem = 1351; cmNewProductItem = 1351;
	srCodedPriceList = 1352; cmNewCodedPriceList = 1352;
	srWPDoc = 1353; 					cmNewWPDoc = 1353;

	{rally!}
	srLeg = 1360;							cmNewLeg = 1360;
	srControl = 1362;					cmNewControl = 1362;
	srCar			= 1363;					cmNewCar = 1363;
	srTiming	= 1364;					cmNewTiming = 1364;
	srPenalty = 1365;					cmNewPenalty = 1365;

	{rongai}
	srTractor = 1370;					cmNewTractor = 1370;
	srTrailer = 1371;					cmNewTrailer = 1371;
	srRongaiQtyOrderItem = 1372;		cmNewRongaiQtyOrderItem = 1372;
	srContainer = 1373;  			cmNewContainer = 1373;
	srShip = 1374;						cmNewShip = 1374;
	srRongaiDelivery = 1375;	cmNewRongaiDelivery = 1375;
	srRongaiPetrolItem = 1376; cmNewRongaiPetrolItem = 1376;
	srPartItem = 1377;				cmNewPartItem = 1377;
	srPartSupplier = 1378;		cmNewPartSupplier = 1378;

	{options - tele courses}
	srCourse = 1380;					cmNewCourse = 1380;
	srStudent = 1381;					cmNewStudent = 1381;
{	srCriteria = 1382;				cmNewCriteria = 1382;{}
	srMarkSheet = 1383;				cmNewMarkSheet = 1383;
	srAssessment = 1384;			cmNewAssessment = 1384;

	{material shop}
	srCurtainQuote	= 1390;		cmNewCurtainQuote = 1390;
	srCQAccessory		= 1391;		cmNewCQAccessory	= 1391;
	srCQPanel				= 1392;		cmNewCQPanel			= 1392;
	srFabric				= 1393;		cmNewFabric 			= 1393;


	{labels/devices, etc}
	srPrinterFilter = 1400;
	srPrinterDevice = 1401;
	srPaper = 1402;
	srLabelPaper = 1403;
	srFaxToPortDevice = 1404;

	srModemDevice = 1410;

	{products}
	srGoods 			= 1500; 		cmNewGoods = 1500;
	srStromsGoods = 1501;			cmNewStromsGoods = 1501;

	{createandeditjimmy proc assumes all creators registered between
  1000 and 1999}


	{---------------more commands---------------}
	cmOrderValuation = 2001;

	cmUnpaidOrders = 2003;
	cmUnsentOrders = 2004;

	cmAllUnpaidInvoices = 2005;
	cmOverdueUnpaidInvoices = 2006;
	cmOverdueLtrs = 2007;

	cmMoreAbout = 2020;
	cmHistory = 2021; {Patient History}
	cmAccounts = 2022;

	cmMakeNewsFlash = 2030;
	cmShowNewsFlash = 2031;



	{------ Lists 2100-2199 --------}
	cmArchiveList = 2101;

	cmStartDirectoryList = 2102;
	cmStartCatDirectoryList = 2103;
	cmNewStaffList = 2104;
	cmNewUserList = 2105;
	cmStartOftenDirList1 = 2106;
	cmStartOftenDirList2 = 2107;
	cmStartOftenDirList3 = 2108;
	cmStartSpecialDirList = 2109;

	cmStartMemList 			= 2110;
	cmStartMemNumList 	= 2111;

	cmStartDiary 				= 2120;
	cmStartStaffDiary 	= 2121;
	cmStartDiaryRepeater = 2122;
	cmStartUserDiary 		= 2123;
	cmStartWeekDiary 		= 2124;

	cmStartForSaleList 	= 2125;
	cmStartGoodsCodeList = 2126;

	cmNewInvoiceIDIdxList = 2127;
	cmNewEstimateIDIdxList = 2128;

	cmNewDocumentList = 2129;

	cmNewLivestockList = 2130;
	cmNewHerdList      = 2131;
	cmNewDeadstockList = 2132;
	cmNewFullstockList = 2133;

	{rally!}
	cmNewLegList			= 2140;
	cmNewRouteList	= 2141;
	cmNewControlList	= 2142;
{	cmNewCarDriverList			= 2143;{}
	cmNewCarNumberList = 2143;
	cmNewCarRacePosList = 2144;
	cmNewCarRacePosClassList = 2145;

	cmRallySetupLists = 2146;
	cmRallyPressLists = 2147;
	cmRallyAuditLists = 2148;
	cmTopTen = 2149;
	cmGeogPos = 2150;
	cmCompPos = 2151;

	cmNewStartList = 2152;
	cmMakeStartList = 2153;
{	cmPrintStartList = 2154;{}
	cmMakeRoute = 2155;

{	cmNewCarGeogPosList = 2154;{}
	cmEditRallySetup = 2157;

	{rally reports}
	cmDoLegBullshitSheet = 2158;

	{Rongai}
	cmStartVehicleList = 2160;
	cmStartShipList = 2161;
	cmStartRongaiContainerList = 2162;
	cmDriversIn = 2163; {drivers in report}
	cmDriversOut = 2164;
	cmStartContainerList = 2165;
	cmLoadingsRpt = 2166;
	cmStartPartNumList = 2167;
	cmStartPartCatgyList = 2168;

	{trays}
	cmStartLettersOutTray = 2170;
	cmStartInvoicesOutTray = 2171;


	{--- Configuration & setup 2200-2299 ------}
	cmDesktopSetup 				= 2200;
	cmEditSetup 					= 2201;
	cmAccountsSetup 			= 2202;
	cmEditInvoiceSetup 		= 2203;
	cmEditMatShopSetup 		= 2204;
	cmEditDirectorySetup 	= 2205;
	cmEditDialSetup 			= 2206;
	cmEditWPSetup 				= 2207;
	cmEditemailSetup 			= 2209;
	cmEditBackupSetup 		= 2210;

	cmEditProgramSetup 		= 2211;
	cmTekkyEditProgramSetup = 2212;

	cmEditForm = 2220;
	cmEditWPForm = 2221;
	cmPrintLastWPReport = 2222;
	cmInitWPPrinter = 2223;

	cmSetPrinter = 2230;
	cmSetFax = 2231;
	cmSetModem = 2232;

	cmEditFilter 	= 2242;
	cmEditPaper 	= 2243;
	cmEditLabels 	= 2244;
	cmEditDisplayOptions = 2245;
	cmEditSCodes 	= 2246;

	{options teletraining}
	cmMaintainActionCodes =2250;

	{----- Finding 2300-2399 ------------}
	cmFindHardwareByID = 2300;
	cmFindInvoiceByID = 2301;
	cmFindEstimateByID = 2302;
	cmFindOrderByID = 2304;
	cmFindJobByID = 2305;
	cmFindSalesOrderByID = 2306;
	cmFindDirectory = 2307;
	cmFindDelivery = 2308;
	cmFindPart = 2309;

	cmFindStudent = 2310;
	cmFindQuickInvoiceByID = 2311;

	{------- Reports 2400-2499 -----------}
	cmGeneralAnalysis = 2460;       srGeneralAnalysis = 2460;

	cmWarrantyReport = 2401;
	cmJobReport = 2402;
	cmUnsentInvoices = 2403;
	cmUnsentLetters = 2404;

	cmMakeSpecialDirList = 2410;
	cmDirectoryReport = 2411;
	cmHardwareSearch = 2412;
	cmSoftwareSearch = 2413;
	cmInvoiceAnalysis = 2414;

	cmPrintStatement = 2415;
	cmPrintAllStatements = 2416;

	{for reports..?}
	cmGo = 2470;
	cmGraph = 2471;
	cmOutput = 2472;
	cmAdmin = 2473;

	cmTrialBalance = 2483;
	cmNominalReport = 2484;
	cmEndOfYear = 2485;
	cmEndOfPeriod = 2486;

	{membership}
	cmOverdueMembers = 2491;

	{rally}
	cmPrintSectionTimes = 2500;
	cmPrintOverallSectionTimes = 2501;
	cmPrintFinalResults = 2502;

	{----- fixit stuff 3000- ------------}
	cmEditIndexItem = 3001; {debug type stuff}
	cmEditHook = 3002; {debug type stuff}
	cmEditTransaction = 3003; {debug type stuff}
	cmEditJimmy = 3004;
	cmEditInvoiceNode = 3005; {debug type stuff}
	cmEditLetterItem = 3006; {for directly editing text item chains}
	cmEditTable = 3007;

	cmMakeInvoiceIDIndex = 3010;  {fixit stuff}
	cmMakeEstimateIDIndex = 3011;  {fixit stuff}
	cmMakeJobIDIndex = 3012;
	cmMakeHWIDIndex = 3013;
	cmMakeOrderIDIndex = 3014;  {fixit stuff}
	cmMakeDirIndex = 3015;  {fixit stuff}
	cmMakeProdIndex = 3016;  {fixit stuff}

	cmListJobIDINdex = 3020;
	cmTrimJobIDIndex = 3021;

	cmUpdateDBase = 3102;
	cmCheckDBase = 3105;
	cmFixDBase = 3106;
	cmAutoFixDBase = 3107;
	cmPurgeDBase = 3108;

	cmSortIndex = 3110;
	cmReIndexFile = 3111;
	cmReIndexsrtype = 3112;
	cmReConstructAll = 3113;
	cmUpdateJimmys = 3114;
	cmReIndexJimmys = 3115;
  cmUpdateFromIndex = 3116;

	{-- Maintenance ---}
	cmBackup = 3230;
	cmRestore = 3231;
	cmMakeHoles = 3233;
	cmSetDateTime = 3234;
	cmKickOut = 3235;
	cmUndoKickOut = 3236;

	cmImport = 3240;
	cmDoLicence = 3241;

	{tagging}
	cmTagItem = 3300;
	cmTagAll = 3301;
	cmUntagAll = 3302;
	cmInvertTags = 3303;

	cmDelTagged = 3305;
	cmTagSelected = 3306;

	{--- Special prints ---}
	cmPrintLabel = 3310;
	cmDeferLabel = 3311;
	cmPrintLastPage 	= 3312;
	cmPrintFirstTen = 3313;



	{note video.pas takes cmxxx from 4000-4110}

	{--- large menus --------}
	cmDirectoryCategoryStart = 5000; {and leave 99 free}



	{------ Print types ------}
	{Print as...}
	pmPrintAs = $0FF;
	prStd     = $000; {standard printer}
	prLetter  = $001;
	prEstimate= $004;
	prInvoice = $008;
	prWorkSheet=$010;
	prRemSlip = $011;
	prReceipt = $012;
	prProForma = $014;
	prPurchaseOrder = $015;
	prSalesOrder = $016;
	prToAcc = $017; {for transactions - print as to account, otherwise as from account}

	{Extensiveness}
	pmScope		= $F00;
	prFullPage= $100;  {Full page, has to decide on targets, open streams, print header, etc}
	prFullBlck= $200;  {All information, but expect to be part of list (ie no header, etc)}
{	prSummary = $200; unused?! {Abbreviated - for a report, salient details}
	prOneLine = $300;		{One line summary - for reports, etc}
	prLabel   = $400;

	{for diary}
	prDaily		= $100; {for page to a day}
	prWeekly  = $200; {for page to a week}
	prMonthly = $300;

	{Target}
{	pmTarget	=$7000;
{	prOutput	=$0000; {prints to whatever output parameter is passed}
{{	prPrint 	=$1000; {outputs to printstream}
{	prFax     =$2000;	{opens fax file, prints to that & faxes}
{	prWP			=$3000; {send to Word Processor for printing}

	pmDefer   =$8000; {whether to do above now or send to appropriate defer list}
	prNow			=$0000;
	prDefer		=$8000;{}

	{---- Sentence code array ID's ------}
	scDirectoryCategory = 1;

	scMachineType = 2;
	scMachineMake = 3;
	scFloppyType = 4;
	scRAMType = 5;

	scHeading = 6;
	scLining = 7;
	scMaking = 8;
	scInterLining = 9;

	scEvents = 10;
	scProblems = 11;
	scAssessments = 12;
	scActions = 13;
	scOutcomes = 14;

	scLetters = 15;
	scInsurance = 16;
	scDetails = 17;   {For more about comment details}

	scSoftwareTitle = 18;

	{membership}
	scMembershipCategory = 19;
	scMembershipRegion = 20;
	scMembershipBranch = 21;

	scCQType = 21;
	scCQPanel = 22; {FabricQuote types - have a price of making & default material length}
	scCQAccessory = 23;

	scGoodsCategory = 24;
	scGoodsUnits = 25;
	scLocations  = 26;

	scCostCentres = 28;
	scVATRates = 29;
	scAccounts = 30;
	scPayTypes = 31;

	scCountries = 32;

	scEdgings = 34;

	scUserFormCodes = 35;

	scDocument = 36;

	{livestock}
	scQNoteWhat = 37; {for livestock sytem}
	scBreed = 38;
	scSex = 39;
	scBoughtFrom = 40;
	scCrushState = 41;
	scTrainedState = 42;
	scLiveStockSearch = 43;

	scSymptoms = 44;
	scDiagnosis = 45;
	scTreatment = 46; {outcome above}

	scCurrency = 47;
	scDialMacros = 48;

	{rally}
	scCarClass = 50;
	scCarEvent = 51;
{	scCarStatus = 52;{}
{	scPenaltyReasons = 53;{}
	scCPType 			= 54;
	scRallyCountries = 55;

	{rongai}
	scVehicleModel = 50;
	scVehicleStatus = 51;
	scVehicleMake = 52;
	scGoods 			= 53;
	scPartCatgy 	= 54;
	scPartCode 		= 55;
	scPartMakers 	= 56;

	{options}
	scCourseType = 60;
	scDisciplines = 61; {disciplines}



	scTempFixit = 99; {used for fixit stuff as temporary file}
	MaxNumSCodeTypes = 99;


	TerminalBullet : string = #1#2#3#4#5#6#7#8#9#10#11#12#13#14#15#16;

{var
	TekkyUser : boolean; {marks whether technical user - ie more tekky info please}
												{most of what used to be tekkymode is now moved to fixit-code-only}

IMPLEMENTATION
begin
	IdleOFf := False;

	DataPath :='';
	FormsPath :='';
	PrintersPath :='';
	WorkPath :='';
	TerminalNo :=0;

	DeadDataMode :=False;
end.