program HexDump;

uses minilib;

type
	TBlock = array[0..15] of char;

var SourceFile : file of TBlock;
		BytePos,Rec : longint;
		S : string;
		Block : TBlock;
		I : byte;
		OutputFile : text;
		StartPos : longint;

{$I-}
begin
	writeln('HexDump v1.1,  (c) SBS 1996.  Usage: HEXDUMP <File> <StartPos>');

	Assign(SourceFile, ParamStr(1));
	reset(SourceFile);

	StartPos := S2Num(ParamStr(2));

	Assign(OutputFile, '');
	rewrite(OutputFile);{}

	BytePos := 0;

	if StartPos<>0 then begin
		writeln(OutputFile, 'Looking for '+N2Str(StartPos));
		for Rec := 1 to StartPos div 16 do begin {to nearest previous block}
			Read(SourceFile, Block);
			inc(BytePos, 16);
		end;
	end;

	writeln(OutputFile,'');

	while not eof(SourceFile) do begin

		Read(SourceFile, Block);

		write(OutputFile,PadZero(N2Str(BytePos),5)+': ');

		S := '';

		for I := 0 to 15 do begin

			BytePos := BytePos +1;

			write(OutputFile,' '+PadZero(hex(ord(Block[I])),2));
			if I = 7 then write(OutputFile, ' ');

			if ((Block[I]>=#32) and (Block[I]<=#127)) {or (Block[I]>=#150)} then
				S := S + Block[I]
			else
				S := S + #249;

		end;

		writeln(OutputFile,'  '+S);

	end;

	close(SourceFile);
	close(OutputFile);

end.


