{***********************************************************
 ***          Hardware INPUT LINE                          ***
 ***********************************************************}
{$I compdirs}
{Selects a Hardware item directly from list}
unit INPHWARE;

INTERFACE

uses inpjimmy, objects, drivers;

type
	PInputHardware = ^TInputHardware;
	TInputHardware = object(TInputJimmy)

		DirectoryID : longint;  {Pointer to DirectoryItem who owns Hardwares}

		constructor Init(var Bounds : TRect; NFieldLen : integer; NDirectoryID : longint);
		function SetID : boolean; virtual; {returns false - no proc at the moment, have to list}
		function ExecuteList(ChainRec : longint) : word; virtual;
	end;

IMPLEMENTATION

uses global, views, edit, app,
			help,
			inplist,
			jimmys, jimhooks;

{===== INIT ==========}
constructor TInputHardware.Init;
begin
	inherited Init(Bounds,NFieldLen, fiHooks);   {Size of field is 6 chars}
	ListOptions := ListOptions or ipAutoList; {always automatically list}
	DirectoryID := NDirectoryID;
end;

function TInputHardware.SetID;
begin
	SetID := false; {should search through chain looking for match...}
end;


{--- Run the Hardware list ----}
function TInputHardware.ExecuteList(ChainRec : longint) : word;
var
	R : TRect;
	Control : word;
	HardwareView : PJimmyHookWindow; {}
  Jimmy : PJimmy;

begin
	ExecuteList := cmCancel;
	if DirectoryID = -1 then
		InputWarning('No Directory Entered','Cannot List')
	else begin
		R.Assign(0,0,50,15);
	 	{Move so first line appears over inputline - assumes owner of dialog box is desktop}
	 	R.Move(Owner^.Origin.X + Origin.X -1, Owner^.Origin.Y + Origin.Y-2);
	 	if R.B.Y>Desktop^.Size.Y then R.B.Y := Desktop^.Size.Y; {clip bottom}
	 	if R.B.X>Desktop^.Size.X then R.Move(Desktop^.Size.X - R.B.X,0); {shift left if not enough room}

    JImmy := PJimmy(JImmyStream^.GetAt(DirectoryID));

	 	{Make modal and input}
	 	New(HardwareView, Init(R, 'HARDWARE LIST', Owner, srHardware, hkMore, Jimmy, nil, nil));{Restrict to just Hardwares}

	 	if HardwareView<>nil then begin {ie not locked, etc}

			HardwareView^.List^.AcceptorLink := @Self; {make sure cmaccept gets passed directly to self}

			ExecuteList := Desktop^.ExecView(HardwareView);
			Dispose(HardwareView, Done);

		end;

		dispose(Jimmy, done);
	end;
end;
{}

end.
