{*************************************************************************
 ***                 INPUTLINES THAT ALSO SELECT FROM LIST             ***
 *************************************************************************}
{Parent object for inputline type input fields that select from a list.
Contains skeleton methods, also mouse handling, list options, etc}
{$I compflgs}
unit InpList;

INTERFACE

uses objects, drivers, tuiedit;

const
	loEntryOnly	= 0;
	loAllowList	= $01;
	loGetFirst 	= $02; {get first match - no check for duplicates}
	loStandard = loAllowList;

	loAllowSuperList = $04; {allow "super"/full list}
	loCheckSuper = $08; {check full list for matches before listing}

	loAutoList = $F0;    {set when automatic, immediate list required if no entry}

type
	PInputList = ^TInputList;
	TInputList = object(TInputELine)

		ListOptions : byte;     {Listing options}
		DoList : boolean;      {flag to request immediate list - difficult to do otherwise for receivedfocus}
		lsType : word;         {list type to be run}

		constructor Init(var Bounds : TRect; NFieldLen : integer; NlsType : word);

		procedure HandleEvent(var Event : TEvent); virtual; {mouse & keyboard dolist events -create cmList event}
		procedure Draw; virtual; {defaults to an up arrow}
		procedure Idle; virtual; {does automatic list if required}

	end;


IMPLEMENTATION

uses global, help, views;


{*********************************
 ***     INITIALISATION        ***
 *********************************}

constructor TInputList.Init;
begin
	inherited Init(Bounds,NFieldLen);   {Size of field is 6 chars}

	ListOptions := loStandard; {don't bother putting in as a parameter - leave
  														like MustInput, etc - only needs set as an exception}

	Options := Options or ofValidate;  {Force validation on exit}
	HelpCtx := hcInputList;

	DoList := False;
	EventMask := EventMask or evBroadCast; {Required by automatic lists to
																				pcik up "receive focus}
	lsType := NlsType;
end;


{***********************************
 ***       HANDLE EVENT          ***
 ***********************************}
procedure TInputList.HandleEvent(var Event : TEvent);
var	R : TRect;
begin
	{--- Keypress wanting list ----}
	if (Event.What = evKeyBoard) and ((Event.Keycode = kbList) or (Event.KeyCode = kbZoom)) then begin
			Event.What := evCommand;
			Event.Command := cmList;
	end;

	if (Event.What = evKeyBoard) and (Event.Keycode = kbSuperList) then begin
			Event.What := evCommand;
			Event.Command := cmSuperList;
	end;

	{--- Mouse wanting list -------}
	if (Event.What = evMouseDown) then begin
		MakeLocal(Event.Where, Event.Where);
		GetExtent(R);
		if ((Event.Where.X=0) and (Event.Where.Y=0)) {either a single click on up arrow}
				or (R.Contains(Event.Where) and Event.Double) then begin {or a double click on the line}
			focus; {a mouse might not act from the focused view!}
			Event.What := evCommand;
			Event.Command := cmList;
		end;
	end;

	{Automatic list on receiving focus}
	if (Event.What = evBroadCast) and (Event.Command = cmReceivedFocus)
		and ((ListOptions and loAutoList)>0)
		and (Event.InfoPtr = @Self) and (Data^='') then begin
		DoList := True;
	end;

	inherited HandleEvent(Event);
end;


procedure TInputList.Idle;
var Event : TEvent;
begin
	{once all the messages are dealt with, it'll idle, so do the list if
	required}
	if DoList then begin
		Event.What := evCommand;
		Event.Command := cmList;
		PutEvent(Event);
		DoList := False;
		ListOptions := ListOptions and not loAutoList; {switch off auto list, so nothing need be entered}
	end else
		inherited Idle;
end;


{*************************************
 ***        DISPLAY                ***
 *************************************}

procedure TInputList.Draw;
begin
	inherited Draw;                                    {Ordinary draw}
	if not GetState(sfDisabled) then WriteStr(0,0, #24, 4);                             {Little up arrow marker}
end;



end.
