{***********************************************************
 ***            PRODUCT INPUT LINE                       ***
 ***********************************************************}
{$I compdirs}
{would be nice if you could type in either the name and/or code to select}

{This one includes an auto-list feature - as soon as focus is received in
an empty line, it starts the list.  Should really be available to all
selector lines, and be changeable as an item in the program setup as whether
to autolist or not}

unit InpProd;

INTERFACE

uses objects, drivers, edit, inpjimmy;

var
	LastInpProductText : string; {for returning to same point in list}

type
	PInputProduct = ^TInputProduct;
	TInputProduct = object(TInputJimmy)

		constructor Init(var Bounds : TRect; NFieldLen : integer);

		function ExecuteList(IdxRec :longint) : word; virtual;
	end;


IMPLEMENTATION

uses views, global,
			app,
			minilib,
			inplist,
			kproduct
		;

	{*********************************
	 ***     INITIALISATION        ***
	 *********************************}

	constructor TInputProduct.Init;
	begin
		inherited Init(Bounds,NFieldLen, fiCatProdIdx);   {Size of field is 6 chars}
	end;


	{***********************************
	***       HANDLE EVENT          ***
	***********************************}
	{-------- RUN THE Product LIST ----------------}
	function TInputProduct.ExecuteList;
	var  R : TRect;
			 ProductList : PProductList; {}

	begin
		{Instantiate}
		R.Assign(0,0,55,15);
		{Move so that first line of list is over inputline - assume owner of owning box is desktop}
		R.Move(Owner^.Origin.X + Origin.X, Owner^.Origin.Y + Origin.Y-2);
		if R.B.Y>Desktop^.Size.Y then R.B.Y := Desktop^.Size.Y; {clip bottom}
		if R.B.X>Desktop^.Size.X then R.Move(Desktop^.Size.X - R.B.X,0); {shift left if not enough room}

		New(ProductList, Init(R, 'Product',fiCatProdIdx));

		if ProductList = nil then begin {if failed - eg lack of memory}
			ExecuteList := cmCancel;
			exit;
		end;

		ProductList^.List^.AcceptorLink := @Self; {make sure cmaccept gets passed directly to self}

		{If something entered, (not a number) move to that}
		if (DelSpace(Data^)<>'') {and (DelSpace(Data^)<>'0') and (S2Lint(Data^)=0)} then begin
																												{"not a number" just for Dirctry lists?}
{			IdxRec := -1;
{			ProductStream^.SearchName(Data^, DatRec, IdxRec);}
			ProductList^.List^.Search := Data^;
			ProductList^.List^.FocusText(ProductList^.List^.GetSearch4Index);
		end else
			if LastInpProductText<>'' then begin
				ProductList^.List^.Search := LastInpProductText;
				ProductList^.List^.FocusText(ProductList^.List^.GetSearch4Index);
				ProductList^.List^.ClearSearch; {don't keep}
			end;

		{Make modal & input}
		ExecuteList := Desktop^.ExecView(ProductList);
		Dispose(ProductList, Done);

		{done accept - set lastinpproducttext}
		LastInpProductText := Data^;
	end;


begin
	LastInpProductText := '';
end.
