{********************************************************************
 ***                                                              ***
 ***                      INPUT TELEPHONE NUMBER                  ***
 ***                           (WITH DIAL FACILITY)              ***
 ********************************************************************}
{$I COMPFlgs}

unit INPTEL;

INTERFACE

uses objects, drivers, tuiedit;

type
	PInputTelNum = ^TInputTelNum;
	TInputTelNum = object(TInputPStr)
		constructor Init(Bounds : TRect; NFieldLen : integer); {also sets help context}
		procedure Draw; virtual;
		procedure HandleEvent(var Event : TEvent); virtual;
	end;


IMPLEMENTATION

uses 	modems, {for dial}
			tuimsgs, {for pause box}
			views,
			scodes,
      help,
			global; {for help context}

{************************************************
 ***            INPUT TELEPHONE NUMBER        ***
 ************************************************}
constructor TInputTelNum.Init;
begin
	inherited init(Bounds, NFieldLen);
	HelpCtx := hcInputTelNum;
end;

procedure TInputTelNum.HandleEvent;
var R :TRect;
		TargetCountry : TSCode;
		P : PView;
begin
	{--- Mouse wanting dial - click on T -------}
	if (Event.What = evMouseDown) then begin
		MakeLocal(Event.Where, Event.Where);
		GetExtent(R);
		if ((Event.Where.X=0) and (Event.Where.Y=0)) {either a single click on up arrow}
				or (R.Contains(Event.Where) and Event.Double) then begin {or a double click on the line}
			focus; {a mouse might not act from the focused view!}
			Event.What := evCommand;
			Event.Command := cmDial;
		end;
	end;

	if (Event.What = evKeyboard) and (Event.KeyCode = kbDial) then begin
		Event.What := evCommand;
		Event.Command := cmDial;
	end;

	if (Event.What = evCommand) and (Event.Command = cmDial) then begin
		if Data^<>'' then begin
			TargetCountry := '';
			P := Message(Owner, evBroadCast, cmGetCountryView, nil);
			if P<>nil then P^.GetData(TargetCountry);
			Dial(Data^,TargetCountry)
		end else
			PauseMessage('Auto Dial','Nothing to Dial',hcADNothing);
	end;

	inherited HandleEvent(Event);
end;

procedure TInputTelNum.Draw;
begin
	inherited Draw;                  {Sets cursor pos & data}
	writeChar(0,0, 'T',4,1);         {T for telephone number}
end;

end.
