{************************************************************************
 ***                  PRINTING JIMMYS                                 ***
 ************************************************************************}
{Used for printing individual jimmys, but also for format types in
directory reports, etc, and perhaps for printing tagged}
{$I compdirs}

{PrintasLinker gives sourceview[1] as the printas type buttons, source[2]
as the editortype buttons, and target[1] as the form selection line}
unit jimprint;

interface

uses 	devices,
			objects,
			tuiedit, views, dialogs, global;

const
	{print targets}
	ptPrint   = 0;
	ptView		= 1;
	ptFax     = 2;
	ptemail		= 3;

type
	{******* PRINTING ******************}
	TJimmyPrintType = record
		Editor : word; {internal/wp}
		Target : word;
		DeviceName : string[8];
		PrintAs : word;
		FormName : string[8];
		NumCopies : byte;
		PlusLabel : boolean;
	end;

const
	BlankPrintType : TJimmyPrintType =
		(Editor 		: edInternal;
		 Target 		: ptPrint;
		 DeviceName : '';
		 PrintAs 		: 0;
		 FormName 	: '';
		 NumCopies 	: 1;
		 PlusLabel 	: False);

{more general purpose than just jimmys}
procedure DeviceFormLink(const Linker : PInputLinker; const CallingView : PView); far;
procedure AddStdDevFormFields(const EditBox : PEditBox; var DeviceFormLinker : PInputLinker);
function SetDeviceFrom(const Editor, Target : word; const DeviceName : FNameStr) : PDeviceStream;
function NewEditorLine(R : TRect) : PERadioButtons;

function GetJimmyPrintType(Title : string; var PrintType : TJimmyPrintType; PrintAs : PSItem; PrintAsLink : pointer) : word;

const
	svTarget = 1;
	svEditor = 2;
	tvDevice = 1;
	tvForm1 = 2; {eg header...}
	tvForm2 = 3; {..form}
	tvLabel = 4;

const
	NumTargets = 4;

implementation

uses
			{$IFDEF kwplink}
			kwplink,
			{$ENDIF}
			email,
			editfile,
			printers, faxes,
			kamsetup,
			help,
			app,
			inpfname, minilib;

{**************************************************************
 **              STANDARD LINKER                            ***
 **************************************************************}
{Links from two radio buttons (editor type - internal/wp/etc and
target - printer/fax/email/etc) to a device line (where you can pick
which printer/fax/etc to use) and up to two form lines, auto-switching
path & editor for the forms.  There is also an optional link to a label,
which assumes a label will only be wanted if printer - ie not fax/email/etc}
procedure DeviceFormLink(const Linker : PInputLinker; const CallingView : PView);
var	Editor, Target : word;
		F : byte;
{		InputDevice : PINputFName;
		InputForm : array[1..2] of PInputFName;{}

begin
	{from radio buttons marking internal/wp/etc}
	Linker^.SourceView[svEditor]^.GetData(Editor);

	{from radio buttons marking print/fax/file/email}
	if Linker^.SourceView[svTarget]<>nil then
		Linker^.SourceView[svTarget]^.GetData(Target)
	else
		Target := ptPrint;

	{============== SET FORMS ==========================}
	for F := tvForm1 to tvForm2 do if Linker^.TargetView[F]<>nil then with PInputFName(Linker^.TargetView[F])^ do begin
		case Editor of
			{$IFDEF Kwplink}
			edWP51 : begin
				Path				:= WPSetup.FormsPath;
				FileEditor 	:= EditWPFile;
			end;
			{$ENDIF}
			edInternal : begin
				Path				:= FormsPath;
				FileEditor	:= EditTextFile;
			end;
		end;

		DrawView;
	end;


	{============ SET DEVICE ==========================}
	if Linker^.TargetView[tvDevice]<>nil then with PInputFName(Linker^.TargetView[tvDevice])^ do begin
		case Editor of
			{$IFDEF Kwplink}
			edWP51 : begin
				{WordPerfect - only one device}
				SetState(sfDisabled, True);
				Data^ := '';
				MustInput := False;
			end;
			{$ENDIF}
			edInternal : begin
				case Target of
					ptPrint : begin
						{printer}
						SetState(sfDisabled, False);
						Ext := PrinterDeviceExt;
						Path := PrintersPath;
						MustExist := True;
						MustInput := True;
						FileEditor := EditPrinterDevice;
						Data^ := PrinterName;
					end;
					ptFax : begin
						{fax}
						SetState(sfDisabled, False);
						Ext := FaxDeviceExt;
						Path := PrintersPath;
						MustExist := True;
						MustInput := True;
						FileEditor := EditFaxDevice;{}
						Data^ := FaxName;
					end;
					ptView : begin
						{file - entry is filename}
						SetState(sfDisabled, False);
						Ext := '';
						Path := '';
						Data^ := 'VIEWFILE';
						FileEditor := nil;
						MustExist := False;
						MustInput := True;
					end;
					ptemail : begin
						{email - entry is account name?}
						Data^ := '';
						SetState(sfDisabled, True);
						MustInput := False;
					end;
				end; {case target}
			end; {ed internal}

		end; {case editor}

		DrawView;
	end; {inputdevice}

	{==== ALLOW LABELS? =========}
	if Linker^.TargetView[tvLabel]<>nil then with PInputBoolean(Linker^.TargetView[tvLabel])^ do begin
		case Target of
			ptPrint : begin
				SetState(sfDisabled, False);
			end else begin
				Data^ := ' ';
				SetState(sfDisabled, True);
			end;
		end;
		DrawView;
	end;


end;


{******************************************************************
 ***            STANDARD DEVICE/TARGET FIELDS                   ***
 ******************************************************************}
{standard radio buttons for selecting the editor type}
function NewEditorLine(R : TRect) : PERadioButtons;
var E : PERadioButtons;
begin
	New(E, init(R,
			NewSItem('I~n~ternal',
			NewSItem('~W~ordPerfect',
	nil))));

	E^.HelpCtx := hcEditorField;

	{switch off wp marker if wplink not available}
	{$IFNDEF kwplink} with PCluster(E)^ do EnableMask := EnableMask and not Exp2(edWP51);{} {$ENDIF}
	NewEditorLine := E;
end;

{standard set of fields for target as well as editor type, with input
linker created and its pointers set}
procedure AddStdDevFormFields(const EditBox : PEditBox; var DeviceFormLinker : PInputLinker);
var R : TRect;
begin
	New(DeviceFormLinker, init(@DeviceFormLink, EditBox));

	with EditBox^ do begin
		{Editor to be used}
		InsTitledField( 3,1, 15,2, '', NewEditorLine(R));
		DeviceFormLinker^.SetSourceView(current, svEditor);

		{target - can't make dynamic as getdata/putdata expects ptPrint, ptFax, etc}
		InsTitledField(	3,4,15,NumTargets, '', New(PERadioButtons, init(R,
																							NewSitem('~P~rint',
																							NewSItem('~V~iew',
																							NewSItem('Fa~x~',
																							NewSItem('~e~mail', nil)))))));
		if Fax=nil 											then with PCluster(Current)^ do EnableMask := EnableMask and not Exp2(ptFax);
		if EmailSetup.ViaFormat=vfNone 	then with PCluster(Current)^ do EnableMask := EnableMask and not Exp2(ptemail);
		Current^.HelpCtx := hcStdSendTargetRB;

		DeviceFormLinker^.SetSourceView(Current, svTarget);

		InsTitledField(30,3+NumTargets, 8,1, '~D~evice',
						New(PInputFName, init(R, 8, PrinterDeviceExt, PrintersPath,True, EditPrinterDevice)));
		Current^.HelpCtx := hcSelectDevice;
		DeviceFormLinker^.SetTargetView(Current, tvDevice);
	end;

	DeviceFormLinker^.CalculateLink(DeviceFormLinker^.SourceView[1]); {set device name according to defualt}
end;


{**************************************************************
 ***             STANDARD DEVICE SETTER                     ***
 **************************************************************}
{Given info, eg from a set of fields as above, will set which
device is to be used}
function SetDeviceFrom(const Editor, Target : word; const DeviceName : FNameStr) : PDeviceStream;
var Device : PDeviceStream;
begin
	{---- device -----}
	Device := nil;
	case Editor of
	{$IFDEF kwplink}
		edWP51 : begin
			Device := WPStream;
			{don't know why this is here - seems the wrong place anyway, mch 17/3/97}
{			if Target<>ptPrint then Device^.AutoSend := False else Device^.AutoSend := True;{}
			{But, for letters, if it's a view/file, then we need to make sure it
			doesn't get printed, similarly if it's a fax, it ought to be printed with the
			fax macro not the print one...}
			if (Target=ptView) then Device^.AutoSend := False;
		end;
	{$ENDIF}
		edInternal : begin
			case Target of
				ptPrint : begin
					if (DEviceName=PrinterName) or (DeviceName='') then
						Device := Printer
					else
						Device := GetDevice(PrintersPath+DeviceName+'.'+PrinterDeviceExt);
				end;
				ptFax : begin
					if DeviceName= FaxName then
						Device := Fax
					else
						Device := GetDevice(PrintersPath+DeviceName++'.'+FaxDeviceExt);
				end;
				ptView : Device := New(PDeviceStream, init('Temporary For Edit', DeviceName));
				ptEmail : Device := New(PEmailStream, init);
			end; {case target}
		end;

	end; {case editor}

	SetDeviceFrom := Device;
end;




{***************************************************************
 ***             STANDARD JIMMY PRINT REQ TYPE               ***
 ***************************************************************}
function GetJimmyPrintType(Title : string; var PrintType : TJimmyPrintType; PrintAs : PSItem; PrintAsLink : pointer) : word;
var Editbox : PEditBox;
		R : TRect;
		W,Control : word;
		DeviceLinker : PInputLinker;
		NumPrintAs : byte;
		PrintAsLinker : PInputLinker;

begin
	NumPrintAs := NumSitems(PrintAs);

	R.Assign(0,0,45,9+NumPrintAs+NumTargets);
	New(EditBox, init(R, Title, Desktop));

{	New(DeviceLinker, init(@DeviceFormLink, Editbox)); done in addstddev...}
	New(PrintAsLinker, init(PrintAsLink, EditBox));

	with EditBox^ do begin
		Options := Options or ofCentered;
		HelpCtx := hcJimmyPrintType;

		{--- standard editor/target selection fields -----}
		AddStdDevFormFields(EditBox, DeviceLinker);

		{-- set editor radio buttons ----}
		with PCluster(DeviceLinker^.SourceView[svEditor])^ do begin
			{can't switch editor types after first edit (except from internal) so
			make others non-selectable}
			W := S2Num(ProgramSetup.Get(siDefedType, N2Str(edInternal)));
			SetData(W);
			if (PrintType.Editor<>edInternal) then begin
				EnableMask := Exp2(PrintType.Editor); {make only that one enabled}
				SetData(PrintType.Editor);
			end;
		end;

		{printaslinker may need to know which editor is being used}
		PrintAsLinker^.SetSourceView(DeviceLinker^.SourceView[svEditor], 2);

		if PrintAs<>nil then begin
			InsTitledField( 3, 5+NumTargets,BiggestSItem(PrintAs)+3, NumPrintAs, '', New(PERadioButtons, init(R,PrintAs)));
			PrintAsLinker^.SetSourceView(Current, 1);

			InsTitledField(30, 4+NumPrintAs+NumTargets, 8,1, '~F~orm',
										New(PInputFName, init(R, 8, 'HDR HD1 FRM', FormsPath,True,EditTextFile)));
			PrintAsLinker^.SetTargetView(Current, 1);
			DeviceLinker^.SetTargetView(Current, tvForm1);
		end else begin
			Insert(New(PSkipBytes, init(9+2)));
		end;


		InsTitledField(10, 6+NumPrintAs+NumTargets,3,1, 'C~o~pies', New(PInputByte, init(R,3)));
		PrintASLinker^.SetTargetView(Current, 2);
		Current^.HelpCtx := hcJPTCopies;

		InsTitledField(10, 7+NumPrintAs+NumTargets,1,1, '~L~abel', New(PInputBoolean, init(R)));
		DeviceLinker^.SetTargetView(Current, tvLabel);
		Current^.HelpCtx := hcJPTLabel;

		InsOKButton(23, Size.Y-3, @PrintType);
		InsCancelButton(33, Size.Y-3);

		EndInit;
		SelectNext(False);

		SetData(PrintType);
	end;

	DeviceLinker^.CalculateLink(DeviceLinker^.SourceView[1]); {as editor may have changed above}
	if PrintType.FormName='' then PrintAsLinker^.CalculateLink(PrintAsLinker^.SourceView[1]);

	GetJimmyPrintType := Desktop^.execView(EditBox);
end;



end.

