{*******************************************************************
 ***               GIVES A SUMMARY OF THE PROGRAM, STATUS, ETC   ***
 *******************************************************************}
{$I compdirs}

unit KAbout;

INTERFACE

procedure ShowAbout;
procedure ShowStatus;

IMPLEMENTATION

uses tasks, global, objects, minilib,
			kamsetup,
			{$IFDEF kusers} muser, kusers, {$ENDIF}
			jimmys, {for company}

{$IFDEF WINDOWS}
	winprocs, wintypes,
	winapp,
	win,	{windows}
	winmsgs,
	strings,
{$ELSE}
	app, views, menus,
	tui, tuiapp, tuiedit, {text}
{$ENDIF}

			dattime,
			Status;

{***********************************
 **         ABOUT                 **
 ***********************************}
{Version number, release number, date program written, authors, description}
procedure ShowAbout;
var	L,Line : byte;
		Date : TDate;{}
		Text : array[0..15] of string[50];
		{$IFDEF Windows}
			AllText : PChar;
		{$ELSE}
			EditBox : PEditBox;
			R : TRect;
		{$ENDIF}

begin
	{---- Set up text array ------}
	for L := 0 to 15 do Text[L] := '';
	Line := 0;      {#3 does centralisation?}
	Text[Line] := #3'A small business administration system,'; inc(Line);
	Text[Line] := #3'designed to help reduce the more'; inc(Line);
	Text[Line] := #3'tedious aspects.';       inc(Line);
	inc(Line);
	Text[Line] := 'VERSION '+N2Str(ProgVer.Main)+'.'+N2Str(ProgVer.Sub)+ProgVer.Release; inc(Line);

{$IFDEF Kmatshop} 	Text[Line] := 'CurtainQuote System'; inc(Line); {$ENDIF}
{$IFDEF Solitaire} 	Text[Line] :=  'Solitaire System'; inc(Line); {$ENDIF}
{$IFDEF MSDOS}    	Text[Line] :=  'Real Mode'; inc(Line); {$ENDIF}
{$IFDEF DPMI}				Text[Line] :=  'Protected Mode'; inc(Line);{$ENDIF}
{$IFDEF Windows}		Text[Line] :=  'Windows Mode'; inc(Line);{$ENDIF}
	inc(Line);
{	GetFileDate('Kameleon.exe', Date); Text[Line] :=  'Compile date '+Date.Text(daAbbr); inc(Line);
	inc(Line);{}
	{$IFDEF singleuser}
		Text[Line] :=  'Single User - DO NOT NETWORK!';
	{$ELSE}
		Text[Line] :=  'Multi User (up to '+N2Str(ProgramStatus.GetMaxUsers)+' users)';
	{$ENDIF}
	Line := Line +2;

	Text[Line] := '         Design: Martin, Gordon        '; inc(Line);
	Text[Line] := '    Programming: Martin                '; inc(Line);
	Text[Line] := 'Testing/Critics: Sue, Ros, Colin, David'; inc(Line);
	inc(Line);
	Text[Line] :=  '(C) Small Business Solutions';       				inc(Line);
	Text[Line] :=  'Tel support available: +44 (0)1525 237456'; inc(Line);

	{--- Now to create box ----}
	{$IFDEF Windows}
		AllText := nil;
		for L := 0 to Line-1 do StrAppPS(AllText, Text[L]+#13); {build pchar message}
		MessageBox(0,AllText,'About Kameleon',mb_OK);
		StrDispose(AllText);
	{$ELSE}
		R.Assign(0,0,45,Line+5);
		New(EditBox, init(R, 'ABOUT KAMELEON',nil));
		with EditBox^ do begin
			Options := Options or ofCentered;
			for L := 0 to Line do
				InsTextCX(EditBox, L+1, Text[L]);

			InsOKButton(18, Line+2, nil);
		end;
		Desktop^.ExecView(EditBox);
		dispose(EditBox, done);
	{$ENDIF}
end;

{***********************************
 **        STATUS                 **
 ***********************************}
{Terminal number, last backup date, spare memory}
procedure ShowStatus;
var Line,B,L : byte;
		{$IFNDEF Windows}
			EditBox : PEditBox;
			R : TRect;
		{$ENDIF}
		S : string;
		Text : array[0..25] of string[50];
		Date : TDate;
		AllText : PChar;

begin
	for L := 0 to 25 do Text[L] := '';

	Line := 0;
	if UserCoyID<>-1 then begin
		Text[Line] 		:= GetJimmyIDName(UserCoyID, naFull, 0);
		inc(Line);
	end;

	{$IFDEF kusers}
		if CurrentUser<>nil then begin
			Text[Line] 	:= '  Logged On: '+SetLength(CurrentUser^.GetName(naFull,15),15);
			inc(Line);
		end;
	{$ENDIF}

	Text[Line] :=  '   Terminal: '+Setlength(N2Str(TerminalNo),15); inc(Line);
	inc(Line);

	ProgramStatus.GetLastBackupDate(Date);
	Text[Line] := 'Last Backup: '+Setlength(Date.Text(daAbbr),15); inc(Line);
	inc(Line);

	Text[Line] := 'Program Ver: '+N2Str(ProgVer.Main)+'.'+N2Str(ProgVer.Sub)+ProgVer.Release+space(11);
	inc(Line);
	Text[Line] := '   Data Ver: '+N2Str(DataVer.Main)+'.'+N2Str(DataVer.Sub)+DataVer.Release+space(11);
	inc(Line);

	inc(Line);
	Text[Line] :=  'Terminals In Use:'; inc(Line);

	{$IFDEF kusers}
	S := OtherUsersList;
	if S<>'' then begin
		inc(Line);
		for L := 1 to NumLines(S) do begin
			Text[Line] := GetLine(S,L);
			inc(Line);
		end;
	end;
	{$ELSE}
	S := space(30);
	for B := 1 to 30 do if ProgramStatus.GetWhoAtTerminal(B)<>-1 then S[B] := 'X';
	Text[Line] :=  #16+S+#17;  inc(Line);{}
	{$ENDIF}


	{$IFDEF WIndows}
		AllText := nil;
		for L := 0 to Line-1 do StrAppPS(AllText, Text[L]+#13); {build pchar message}
		MessageBox(0,AllText,'About Kameleon',mb_OK);
		StrDispose(AllText);
	{$ELSE}
		R.Assign(0,0,40,Line+5);
		New(EditBox, init(R, 'STATUS',nil));
		with EditBox^ do begin
			Options := Options or ofCentered;
			for L := 0 to Line do
				InsTextCX(EditBox, L+1, Text[L]);
			InsOKButton(15, Line+2, nil);
		end;
		Desktop^.ExecView(EditBox);
		dispose(EditBox, done);
	{$ENDIF}
end;


{INITITALISATION}
begin
	{$IFDEF fixit} writeln('Initialising kabout...'); {$ENDIF}
	RegisterTask(DesktopTasks, cmShowAbout, @ShowAbout);
	RegisterTask(DesktopTasks, cmShowStatus, @ShowStatus);
end.
