{***************************************************************************
 ***                                                                     ***
 *** New All-Singing/Dancing/Dropping OOP                                ***
 ***                                                                     ***
 ***                      KAMELEON MANAGEMENT SYSTEM                     ***
 ***                                                                     ***
 *** M Hill                                                      11/4/92 ***
 ***************************************************************************}
{$IFDEF MSDOS}
	{$M $6000,0,$30000} {increase stack size a bit}
{$ELSE}
	{$IFNDEF WINDOWS}
		{$M $9000}  {Increase stack size}
	{$ENDIF}
{$ENDIF}
{$I compdirs}  {Compiler directives}

{$IFDEF Install} Switch off install flag in compflgs.pas {$ENDIF}


program KameleonMS;

uses
		startup1,
{$IFDEF MSDOS}
		overlay, overinit,                   {Std overlay unit, plus overlay initialisation unit}
{$ENDIF}
		global, {initialise global stuff}
		tasks, {make sure all initialisation of task stuff is done first}
		kamsetup, {similarly paths}

{		apiracy,{}
		TuiApp,
		kabout,               {general notes, status, etc}
		drivers, {for failsyserror}
		DoHelp,
		Palettes,
		AsciiTbl,

{$IFDEF fixit} fixit, chkdata, {$ENDIF}

		 {---Custom modules for this system ---}
		 {Included here so can be overlaid}
		 {See kapplic for reports}
{$IFDEF krally}			krally, {$ENDIF}
{$IFDEF krongai}		krongai, krongord, krongrpt, krongai2,{} {$ENDIF}
{$IFDEF koptions}		koptions, {$ENDIF}
{$IFDEF kcompsup}		kcompsup, khwrpts, {$ENDIF}

{$IFDEF kdirctry} 	kperson, kcompany, kdirrpts,{}	{$ENDIF}
{$IFDEF kstaff}			kstaff,							{$ENDIF}
{$IFDEF kusers}			kusers,							{$ENDIF}
{$IFDEF kmemship}		kmemship, 					{$ENDIF}

{$IFDEF klivestk}  	klivestk,    {}				{$ENDIF}
{$IFDEF kDiary}  		kDiary,    					{$ENDIF}
{$IFDEF Kbooks} 		kbooks, 						{$ENDIF}
{$IFDEF ksbs}    		ksbs,      					{$ENDIF}
{$IFDEF Knewsfl}		newsfl, 						{$ENDIF}	{news flash}

{Documents}
{$IFDEF kPLists}  	kPlists,   					{$ENDIF}
{$IFDEF kWPDocs}  	kWPDocs,   					{$ENDIF}

{$IFDEF kmaint}		 kmaint,	{$ENDIF}

{$IFDEF kmnote}  	kmnote,  {$ENDIF}       {Detail comment}

{History list items}
{$IFDEF kjob}      	kjob,     {kjobrpts,{} {$ENDIF}       {Job sheet}
{$IFDEF kletter}		kletter,	{kltrrpts,{} {$ENDIF}
{$IFDEF kmatshop}  kmatshop,   {$ENDIF}
{$IFDEF kqnote}    kqnote,    {$ENDIF}
{$IFDEF kstock}		kstock,	{kgoodsin,{} {$ENDIF}

{Order processing}
{$IFDEF kestimat}		kestimat,		{$ENDIF}
{$IFDEF kinvoice}  kinvoice,  {} {$ENDIF}
{$IFDEF KQInv}		are you sure?  wendy only!	kQInv, {} {$ENDIF}
{$IFDEF kporder}   kporder,  {$ENDIF}
{$IFDEF ksorder}   ksorder,  {$ENDIF}

{Products/Services for sale}
{$IFDEF kForSale}  	kForSale,    				{$ENDIF}
{$IFDEF kProdOwn}  	kProdOwn,    				{$ENDIF}
{$IFDEF KStroms}		kStroms, kstock,		{$ENDIF} {Stromsholm goods special}
{		copyjim, {for making jimmys from other jimmys}

{		reports,{}

		{For error processing}
		dbg,
		tuimsgs, minilib,
{$IFDEF fixit} crt, {$ENDIF}
		stdstart,
		startup2; {last minute preparations!}

{------------- OVERLAYS -------------------}
{above always units}
{$O tuimsgs} {$O dbg} {$O kamsetup} {$O apiracy} {$O kabout} {$O doHelp}
{$O ASCIITbl} {$O Palettes} {$O startup2}

{Often-used: don't overlay!}
{{$O tuiedit}
{{$O tuilist}
{{$O minilib} {overinit unit uses it to read the parameters line...}
{{$O dattime} {similarly don't overlay dattime as its used in the status line}
{{$O tuiapp}

{Always present, occasionally used units (so always overlay them)}
{$O forms} {$O labels}
{$O devices} {$O printers} {$O faxes} {$O modems}
{$O autodial} {$O doscom} {$O email}
{$O messtext}
{$O reports}
{$O ColorSel}
{$O files}
{$O tuigrphs}
{$O tuicalc} {calculator}
{$O Stddlg}
{$O MultCurr}
{$O lstrings}
{$O indxutil}
{$O video}

{$O inpjimmy}
{$O inplist}
{$O inpdnt}

{Always present, often used, but too many relocation items..}
{$O jimmys} {$O jimhooks} {$O jimindxs} {$O jimprint}
{$O linklist} {$O indexes} {$O tuijimmy}
{$O notes}

{Units dependant on "flavour"}
{$IFDEF fixit}			{$O fixit} {$O chkdata} {$O alljimmy} {$ENDIF}

{$IFDEF kdirctry} 	{$O kperson} {$O kcompany} {$O kdirctry}	{d$O kdirrpts} {$O kdirsetu} {$O address} {$ENDIF}
{$IFDEF kDiary}  		{$O kdiary}		{$ENDIF}
{$IFDEF KBooks} 		{$O kbooks}		{$O kbksrpts}	{$ENDIF}
{$IFDEF ksbs}    		{$O ksbs}			{$ENDIF}

{$IFDEF klivestk}		{$O klivestk}	{$ENDIF}

{$IFDEF kmaint}  		{$O kmaint}		{$O indxutil}	{$ENDIF}
{$IFDEF kfixit}			{$O kfixit}			{$ENDIF}

{$IFDEF kcompsup}		{$O	kcompsup} {$ENDIF}
{$IFDEF kdetcomm}  {$O kmnote}  {$ENDIF}       {Detail comment}
{$IFDEF kppmedcl}  {$O kppmedcl}  {$ENDIF}
{$IFDEF kmemship}  {$O kmemship}  {$ENDIF}
{$IFDEF kprodown}  {$O kprodown}  {$ENDIF}

{History list items}
{$IFDEF kjob}      {$O kjob}      {$ENDIF}       {Job sheet}
{$IFDEF kporder}  	{$O kporder}  {$ENDIF}
{$IFDEF kstock}			{$O	kstock}	{{$O kgoodsin}	{$ENDIF}
{$IFDEF kbriefso}		{$O kbriefso}	{$ENDIF}
{$IFDEF kmatshop}  	{$O kmatshop}   {$ENDIF}
{$IFDEF kevent}    	{$O kevent}    {$ENDIF}
{$IFDEF kLetter}    {$O kletter}   {$ENDIF}
{$IFDEF kwplink}   	{$O kWPLink}   {$ENDIF}
{$IFDEF kinvoice}  	{$O kinvoice}  {$O kinvrpts}	{$ENDIF}


{$DEFINE blug}

{$IFDEF blug}

{generally used units; may want to remove these for speed}
{{$O views}
{{$O dialogs} {$O validate}
{{$O objects}
{{$O app}

{$O Validate}
{$O TUIEDIT}
{$O INPDNT  }
{{$O INPHWARE}
{{$O KANALYSE}
{$O MEASURES}
{$O MEMORY  }
{$O MENUS   }
{$O TUILIST}
{$O NOTES}
{$O EDITOR}
{$O SCODES  }
{$O TASKS }
{$O STATUS }
{$ENDIF}



{*************************
 ***   ERROR HANDLING  ***
 *************************}
var
	NextExitProc : pointer;
{	ErrorFile : text;{}

procedure ExitKameleon; far;
var Msg : string;
begin
	ExitProc := NextExitProc;

	if ExitCode>0 then begin
		Msg := N2Str(ExitCode)+' at '+loc(ErrorAddr)+' Ver '+N2Str(ProgVer.Main)+'.'+N2Str(ProgVer.Sub)+ProgVer.Release;
		{$IFDEF MSDOS}
			Msg := Msg+' Real';
		{$ELSE}
			Msg := Msg+' Prot';
		{$ENDIF}
		{$IFDEF SingleUser} 	Msg := Msg+' Single'; {$ELSE} Msg := Msg + ' Multi'; {$ENDIF}
		{$IFDEF Development}	Msg := Msg+' Dev';	{$ENDIF}
		{$IFDEF Fixit}				Msg := Msg+' Fixit';	{$ENDIF}

		RecordError('RUNTIME ERROR',Msg,'');
{$IFDEF Fixit}
		ErrorBleep;
		Writeln('RUNTIME ERROR '+Msg);
		ReadKey;
{$ELSE}
		MessageBox('RUNTIME ERROR',
								'Please contact SBS with these details:'+#13#10+Msg,
								mfError + mfContinueButton + mfErrorBleep, 0);
{$ENDIF}
		ExitCode := 0;
		ErrorAddr := nil;
	end;
end;

function KameleonSysError(ErrorCode: Integer; Drive: Byte): Integer;
begin
	{leave as default for the moment}
	KameleonSysError := SystemError(ErrorCode, Drive);
end;

{*****************************************
 ***      MAIN BODY                    ***
 *****************************************}

begin
	{Set up new critical error handling}
{	SysErrorFunc := @KameleonSysError;{}
	FailSysErrors := True; {eg hard drive fails, etc - let Kameleon capture}

	{set up new exit procedure for trapping/recording run-time errors}
	{{$IFNDEF development}
	NextExitProc := ExitProc;
	ExitProc := @ExitKameleon;{}
	{{$ENDIF}

	{$IFDEF fixit} writeln('TKameleon init...'); {$ENDIF}
	New(Kameleon, init);
	Kameleon^.Run;
	Dispose(Kameleon, Done);

end.
