{***************************************************
 ***                 BOOKS SETUP                 ***
 ***************************************************}
{$I compflgs}
unit KBksSetu;

interface

uses setup, scodes, tuiedit;

type
	PBooksSetup = ^TBooksSetup;
	TBooksSetup = object(TSetup)
		DefaultVATRate : TSCode;
		{accounting catagories for auto-postings}
		acIncome    : TSCode;
		acExpenses  : TSCode;
		acPurchases : TSCode;  {subcategory of expenses}

		acBankAccount: TSCode;
		acVATAccount : TSCode;

		acDebtors    : TSCode;
		acCreditors  : TSCode;

		procedure Load; virtual;
		procedure Store; virtual;
		procedure SetButtonDefaults; virtual;
		procedure AddSetupLines(EditBox : PEditBox); virtual;
	end;

var
	BooksSetup : TBooksSetup;

implementation


procedure EditBooksSetup;
begin BooksSetup.Edit; end;


procedure TBooksSetup.Load;
var ScodeItem : PSCodeItem;
begin
	acIncome 			:= ProgramSetup.Get('INCOME A/C',			'INC');
	acExpenses 		:= ProgramSetup.Get('EXPENSES A/C', 	'EXP');
	acPurchases 	:= ProgramSetup.Get('PURCHASES A/C',	'PUR');
	acBankAccount := ProgramSetup.Get('BANK A/C'				'BNK');
	acVATAccount 	:= ProgramSetup.Get('VAT A/C', 				'VAT');
	acDEbtors 		:= ProgramSetup.Get('DEBTORS A/C',		'DB');
	acCreditors 	:= ProgramSetup.Get('CREDITORS A/C',	'CR');
end;

procedure TBooksSetup.SetButtonDefaults;
begin
	acIncome    :='INC';
	acExpenses  :='EXP';
	acPurchases :='PUR';

	acBankAccount:='BNK';
	acVATAccount :='VAT';

	acDebtors    :='DB';
	acCreditors  :='CR';
end;

procedure TBooksSetup.Store;
begin
	ProgramSetup.Put('INCOME CAT',acIncome);
	ProgramSetup.Put('ACCOUNTS EXPENSES CAT',acExpenses);
	ProgramSetup.Put('ACCOUNTS PURCHASES CAT',acPurchases);
	ProgramSetup.Put('ACCOUNTS BANK CAT',acBankAccount);
	ProgramSetup.Put('ACCOUNTS VAT CAT',acVATAccount);
	ProgramSetup.Put('ACCOUNTS DEBTORS CAT',acDebtors);
	ProgramSetup.Put('ACCOUNTS CREDITORS CAT',acCreditors);

  ProgramSetup.Store;
end;

{============ EDIT ======================}
procedure TBooksSetup.AddSetupLines;
var	R : TRect;

begin
	with EditBox^ do begin
  	GrowTo(37, 15);
		InsTitledField(18,  2,15, 1, 'Default VAT', New(PinputScode, Init(R, scVATRates)));
  	InsTitledField(18,  4,15, 1, 'Ctgys Income', New(PinputScode, Init(R, scAccounts)));
  	InsTitledField(18,  5,15, 1, 'Expenses', New(PinputScode, Init(R, scAccounts)));
  	InsTitledField(18,  6,15, 1, 'Purchases', New(PinputScode, Init(R, scAccounts)));
  	InsTitledField(18,  7,15, 1, 'Bank Act', New(PinputScode, Init(R, scAccounts)));
  	InsTitledField(18,  8,15, 1, 'VAT Act', New(PinputScode, Init(R, scAccounts)));
  	InsTitledField(18,  9,15, 1, 'Debtors', New(PinputScode, Init(R, scAccounts)));
  	InsTitledField(18, 10,15, 1, 'Creditors', New(PinputScode, Init(R, scAccounts)));
	end;
end;





begin
	BooksSetup.init('Book-Keeping');
end.
