{***********************************************************************
 ***                    DIRECTORY SETUP OBJECT                       ***
 ***********************************************************************}
{$I compflgs}

unit KDirSetu;

INTERFACE

uses tuiedit, scodes, setup;

const
	{default top list when displaying person/coy}
	dtMore 			= 0;
	dtContacts 	= 1;
	dtBills			= 2;

type
	PDirectorySetup = ^TDirectorySetup;
	TDirectorySetup = object(TSetup)

		Often : array[1..3] of TSCode;
		DefadType : word;
		DefTopList : word; {more/contacts/bills}

		procedure Load; virtual;
		procedure Store; virtual;
		procedure AddSetupLines(EditBox : PEditBox); virtual;
	end;

var
	DirectorySetup : TDirectorySetup;

procedure SetUpDirectoryListMenu;

IMPLEMENTATION

uses tasks,
			global,
			address,
			dialogs,
			tui,
			tuiapp, {oftendiritem}
			minilib, objects, views, kamsetup;

procedure EditDirectorySetup; far;
begin DirectorySetUp.Edit; end;



procedure TDirectorySetup.Load;
begin
	Often[1]		:= Get('OFTEN CODE1','CUS');
	Often[2]		:= Get('OFTEN CODE2','PRO');
	Often[3]		:= Get('OFTEN CODE3','SUP');

	DefadType		:= S2Num(Get(siDefadType, 		N2Str(adUK)))-1; {1-based}
	DefTopList	:= S2Num(Get(siDefDirTopList, N2Str(dtContacts)));
end;


procedure TDirectorySetup.Store;
begin
	Put('OFTEN CODE1', Often[1]);
	Put('OFTEN CODE2', Often[2]);
	Put('OFTEN CODE3', Often[3]);

	Put(siDefadType, 			N2Str(DefadType+1));
	Put(siDefDirTopList, 	N2Str(DefTopList));

	ProgramSetup.Store;
	SetUpDirectoryListMenu;
end;

{============ EDIT ======================}
procedure TDirectorySetup.AddSetupLines;
var R : TRect;
begin
	with EditBox^ do begin
		GrowTo(38, 17);

		InsTitledField(16, 1,20,1, 'Dir List ~1~', New(PInputSCode, init(R, scDirectoryCategory)));
		InsTitledField(16, 2,20,1, '~2~', 					New(PInputSCode, init(R, scDirectoryCategory)));
		InsTitledField(16, 3,20,1, '~3~', 					New(PInputSCode, init(R, scDirectoryCategory)));

		{--- Def Address Type ----}
		R.XYLD(16, 5, 15, 4); Insert(New(PERadioButtons, init(R,
																		NewSItem('~U~K',
																		NewSItem('~P~O Box',
																		NewSItem('US~A~',
																		NewSItem('~E~urope', nil)))))));
		AddLabel('Def. Address', Current);

		R.XYLD(16,10, 15, 3); Insert(New(PERadioButtons, init(R,
																		NewSItem('~M~ore-About',
																		NewSItem('C~o~ntacts',
																		NewSItem('B~i~lls', nil))))));
		AddLabel('Top Box List', Current);
	end;
end;

procedure SetUpDirectoryListMenu;
var NewCode : TSCode;
		SCodeItem : PScodeItem;
		B : byte;
begin
	ScodeCollection[scDirectoryCategory]^.LogOn; {automatically creates category submenu}

	{set menu items}
	for B := 1 to 3 do begin
		NewCode := DirectorySetup.Often[B];

		if (NewCode<>'') then begin
			{have to do it with scodeitem, as expandscode deletes tildes}
			SCodeItem := GetSCode(scDirectoryCategory, NewCode);
			if SCodeItem<>nil then begin
				DisposeStr(OftenDirItem[B]^.Name);
				OftenDirItem[B]^.Name := NewStr(SCodeItem^.Description^);
			end;
		end;
	end;

	ScodeCollection[scDirectoryCategory]^.LogOff;
end;


begin
	DirectorySetup.Init('Directory');
	RegisterTask(DesktopTasks, cmEditDirectorySetup, @EditDirectorySetup);
end.
