{************************************************************************
 ***                                                                  ***
 *** New Fabbo Singing Dancing OOP                                    ***
 ***                            EstimateS                             ***
 ***                                                            Nov 94***
 *** M Hill                                                 rev Aug 96***
 ***********************************************************************}
{For making Estimates{}
{Similar to Porder, but also has an extra hooked on chain for collecting goods
re this estimate.  Actually only used for CurtainQuote fabrics at the moment}

{$I compdirs}  {Compiler directives}
unit kEstimat;

INTERFACE

uses 	linklist,
			notes, dattime,
			multcurr,
			jimmys,
			tuiedit,
			objects,
			global,
			jimprint,
			views,
			forms, devices,
			files,
			dialogs,
			ordproc;

{*****************************
 ***  Estimate              ***
 *****************************}
{const
	TEstimateSize = 100;
{	EstimateIDLength = 15;{}
const
	hkGoodsItems = 2; {comes after hkOrderItems}


type
	PEstimate = ^TEstimate;
	TEstimate = object(TOrder)

		Ptr2Goods : longint;
{now in torder		Comment   : PFreeTextData;            {Text on Estimate}

		constructor Init(Param : PJimmyInitParam);
		procedure CommonInit; virtual; {init procedures common to Init and Load (eg scode logging)}
		destructor Done; virtual;

		{--- Editing ----}
		procedure MakeEditBox(var EditBox : PEditBox; Caller : PView); virtual;

		{--- Viewing -----}
		function DisplayLine(ListForWho : longint; lstype : byte; Maxlen : integer; View : word) : string; virtual;
		function GetName(naType : byte; Maxlen : integer) : string; virtual; {used for various displays/prints -
																																					eg selection lines, window headers, etc}
		{--- Printing ----}
		procedure SetFormCodes(const FormCodes: PFormCodeCollection); virtual;
		procedure PrintFull(const Device : PDeviceStream; const PrintAs : word); virtual;
		procedure GetDefaultPrintType(var PrintType : TJimmyPrintType; var PrintAs : PSItem; var PrintAsLink : pointer); virtual;

		{--- Database ----}
		function RecSize : word; virtual; {space to be reserved in jimmy file}
		function srType : word; virtual; {descendants set as fixed, so can be
																			used to identify jimmy for file operations, etc}
		function PtrOffset : byte; virtual; {extra ver no}

		procedure Storefields(var S : TDataStream); virtual;
		constructor Load(var S : TDataStream);

		{--- Hooking on others -----}
		function NumhkTypes : byte; virtual;
		procedure GetHookOn(const hkType : byte; var HookRec : PLongint); virtual;
	end;


IMPLEMENTATION

uses tui, tuimsgs,
			idindex,
			{$IFDEF kusers} kusers, {$ENDIF}
			kamsetup,
			help,
			inpdnt,
			kinvsetu, {for checking overdue level}
			kdirctry,
			tasks,
			tuijimmy,
			jimhooks,
			minilib;

{***********************************************************************
 ***                                                                 ***
 ***                      Estimate                                ***
 ***                                                                 ***
 ***********************************************************************}
constructor TEstimate.Init(Param : PJimmyInitParam);
begin
	inherited init(param);
end;

procedure TEstimate.COmmonInit;
begin
	inherited CommonInit;
end;

destructor TEstimate.Done;
begin
	inherited Done;
end;

{==== CREATE DISPLAY-LINE-FORMAT STRING ============}
function TEstimate.DisplayLine;
var S : string;
begin
	S := Date.Digit8+' ESTIMATE '+PadSpaceL(N2Str(Ref),5)+'  For '+PadspaceL(TotallerGroup.Total.Text(mtFull),9);;

	DisplayLine := S;
end;

function TEstimate.GetName;
begin
	GetName := 'EST #'+N2Str(Ref)+' '+GetJimmyIDName(ForWho,naRef,0)+' '+Date.Text(daDigit8);
end;


{**************************************************
 ***             EDIT BOX                       ***
 **************************************************}

procedure TEstimate.MakeEditBox;
var	R: TRect;
		ForLine, RefLine, ByLine, PmntView, ItemView : PView;

begin
	R.Assign(0, 0, 60, 19);
	CentreOnView(R, Caller);
	EditBox := New(PJimmyEditBox, Init(R, 'Estimate',Caller, @Self));

	with EditBox^ do begin
		Insert(New(PSkipBytes, init(sizeof(TJimmy))));
		Insert(New(PSkipBytes, init(4+sizeof(TDate)))); {skip ptr2items & lastprint}

		R.Assign(0,0,0,0); Insert(New(PStateField, init(RecNo)));

		Insert(New(PINputTotallerGroup, init(Size.X-22, 13, EditBox)));

		{ref, etc}
		InsTitledField(7,  1, 5, 1, 'Ref', New(PInputRefNum, init(R,5, srEstimate)));
		Insert(New(PSkipBytes, init(4))); {oldref}
		InsTitledField(20, 1,10, 1, '~D~ate', New(PinputDate, Init(R)));

		ForLine := InsTitledField(7,  3,25,1, '~T~o',  New(PInputDirectory, init(R, 30,  fiFullDirIdx, lsDirectory,'')));
		PInputELine(ForLine)^.MustInput := True;
		Insert(New(PSkipBytes, init(sizeof(ForWhoRef))));

		ByLine  := InsTitledField( 7, 4,25,1, '~B~y',  New(PInputDirectory, init(R, 30,  fiCatDirIdx, lsDirectory,'STA')));

		ItemView := InsTitledField(7, 6,50,7, '~F~or',
															New(PDlgHookView,	Init(R, lsSalesItems, 0, hkOrderItems, @Self,PJimmyEditBox(EditBox))));
		Insert(PHookViewer(ItemView)^.VScrollBar);

		InsTitledField(7, 14, 25, 4, 'N~o~tes', New(PInputFreeText, Init(R,200,20,nil)));

		{-- Buttons --}
		Insert(New(PJimmyOKButton, Init(37,Size.Y-3, @Self)));
		Insert(New(PjimmyCancelButton, init(47,Size.Y-3, @Self)));

		{$IFDEF development}
		Insert(New(PRecalcButton, init(13,Size.Y-1, '~R~ecalc', 0, bfNormal, nil)));
		{$ENDIF}

		EndInit;
	end;

	if ForWho=-1 then
		ForLine^.FOcus
	else
		ItemView^.Focus; {hmmm, this makes it automatically save...}
end;

{*****************************************
 ***     STREAMING DEFINITIONS         ***
 *****************************************}
function TEstimate.RecSize;
begin RecSize := 100; end;

function TEstimate.srType;
begin srType := srEstimate; end;

function TEstimate.PtrOffset;
begin PtrOffset := inherited PtrOffset + 1; end; {extra ver in load}

constructor TEstimate.Load(var S : TDataStream);
var	B,Ver,OV : byte;
begin
	S.Read(Ver, 1);

	case Ver of
		1 : begin
			{pre ptr2goods}
			S.Read(OV,1); {order version}

			CommonInit;
			S.Read(B,1); {locks}
			S.Read(B,1); {markers}

			S.Read(Ptr2Items, 4);

			S.REad(Ref, 4); OldRef := Ref;
			S.Read(ForWho, 4);
			Date.Load(S);
			LastPrint.Load(S);
			TotallerGroup.Load(S);
			if OV=2 then S.Read(State, 1);
			ForWhoRef := nil;
			S.Read(ByWho, 4);
			Notes^.Load(S);
			if not LastPrint.Blank then State := State or osSent; {botch fix for old}
		end;
		2 : begin
			{v4.3a - moved all to Torder, added Ptr2Goods}
			inherited Load(S);
		end;
	else
		DBaseMessage(@S, 'Version '+N2Str(Ver)+' not understood'#13#10'Estimate.Load',mfError,hcInternalErrorMsg);
		fail;
	end;
end;

procedure TEstimate.StoreFields(var S : TDataStream);
var	Ver : byte;

begin
	Ver := 2; S.Write(Ver, 1);

	inherited StoreFields(S);
end;

{--- Hooking on others -----}
function TEstimate.NumhkTypes;
begin NumhkTypes := 2; end; {inherited hkorderitems + hkgoodsitems}

procedure TEstimate.GetHookOn(const hkType : byte; var HookRec : PLongint);
begin
	inherited GetHookOn(hkType, HookRec);
	case hktype of
		hkGoodsItems : HookRec := @Ptr2Goods;
	end;
end;


{*****************************************
 ***  PRINTING                         ***
 *****************************************}
const
	EstimatePrintType : TJimmyPrintType =
		(Editor : edInternal;
		 Target : ptPrint;
		 DeviceName : '';
		 PrintAs : 0;
		 FormName : 'ESTIMATE';
		 NumCopies : 1;
		 PlusLabel : False);

procedure TEstimate.GetDefaultPrintType
										(var PrintType : TJimmyPrintType; var PrintAs : PSItem; var PrintAsLink : pointer);
begin
	PrintAs := 	NewSItem('~E~stimate', nil);
	PrintType := EstimatePrintType;
	PrintAsLink := nil;
end;

procedure TEstimate.SetFormCodes;
begin
	inherited SetFormCodes(FormCodes);

	with FormCodes^ do begin
		{comment}
	end;
end;

procedure TEstimate.PrintFull;
begin	PrintForm(Device, 'ESTIMATE'); end;

{*****************************************
 ***  INITIALISATION/REGISTRATION      ***
 *****************************************}
const
	{--- Required for Stream ----}
	REstimate : TStreamRec = (
		ObjType : srEstimate;
		VmtLink : Ofs(TypeOf(TEstimate)^);
		Load : @TEstimate.Load;
		Store : @TEstimate.Store
	);


function CreateEstimate(P : pointer) : pointer; far;
begin	CreateEstimate := New(PEstimate, init(P)); end;


begin
{$IFDEF fixit} writeln('KEstimate...'); {$ENDIF}
	RegisterJimmy(REstimate, CreateEstimate, lsAccounts, '~E~stimate');

	{Register with desktop}
	RegisterNewWithList(lsDesktop, '~E~stimate', cmNewEstimate);{}
{	RegisterTask(DesktopTasks, cmNewEstimate, @CreateEditJimmy);{}

	RegisterNewWithList(lsHistory, '~E~stimate', cmNewEstimate);{}
end.
