{****************************************************************************
 ***                                                                      ***
 ***                          HARDWARE REPORTS                            ***
 ***                                                                      ***
 *** M Hill                                                               ***
 ****************************************************************************}
{$I compdirs}  {Compiler directives}
{A bit clumsy at the moment, need to develop a proper directory hook search,
which is designed for searching the attached hooks of directory items.

This one runs through the directory, looking at the more-about lists,
finding any sware/hware that matches, and returning true in the matchitem -
though this true refers to the directory item, and so another search has
to be done for the relevant items when printing in outputitem...}

unit KHWRPTS;

INTERFACE

procedure ExpWarrantySearch;

IMPLEMENTATION

uses
			tuiapp, tui,
			tasks, menus, global,
			datTime, inpdnt,
			kcompsup,
			forms, devices,
			app,
			objects,
			files,
			jimmys, jimhooks, jimprint,
			reports, kdirrpts,kdirctry,
			scodes,
			tuiedit, views,
			minilib; {comparepartialstrings}


{**********************************************************
 ***                                                    ***
 ***             EXPIRED WARRANTY SEARCH                ***
 ***                                                    ***
 **********************************************************}
type
	PWarrantySearchOptions = ^TWarrantySearchOptions;
	TWarrantySearchOptions = record
		SearchRange : TDateRange;
	end;

	PWarrantySearch = ^TWarrantySearch;
	TWarrantySearch = object(TDirectoryReport)

		CurrentDirectoryID : longint;

		constructor Init;
		destructor Done; virtual;
		function EnterCriteria(eaType : word) : word; virtual;
		function MatchItem(Item : PObject) : boolean;      virtual;
		procedure SetHeaderCodes(FormCodes : PFormCodeCollection); virtual;
		procedure OutputItem(item : PObject; ItemNo : longint); virtual;
	end;


constructor TWarrantySearch.Init;
var Search : PWarrantySearchOptions;
begin
	New(Search);
	with Search^.SearchRange do begin
		Start.SetToToday;
		Start.Day := 1;
		Finish.SetToDate(Start);
		Finish.AddMOnth(True);
	end;

	inherited Init('WARRANTY SEARCH', '', fiFullDirIdx, -1, -1,  Search, nil);

	AskForSearch := true;
	FileAdmin(fiHooks)^.LogOn;
end;

destructor TWarrantySearch.Done;
begin
	FIleAdmin(fiHooks)^.LogOff;
	inherited Done;
end;


{==== GET SEARCH CRITERIA =================}
function TWarrantySearch.EnterCriteria;
var	EditBox : PEditBox;
		Bounds, R : TRect;

begin
	EditBox := nil;
	EnterCriteria := cmOK;

	case eaType of
		{=================== SEARCH ==================================}
		eaSearch : begin
			Bounds.Assign(0,0,27,8);
			New(EditBox, init(Bounds,ucase(Title)+' SEARCH',Desktop));

			with EditBox^ do begin
				Options := Options or ofCentered;

				Insert(New(PSKipBytes, init(2)));

				InsTitledField(12,2,10, 1,'For Date', New(PInputDate, Init(R)));
				InsTitledField(12,3,10, 1, 'To',      New(PInputDate, Init(R)));

				SetData(PDirectorySearchOptions(SearchOptions)^);{}

				InsOKButton(Size.X-21, Size.Y-3, SearchOptions);
				InsCancelButton(Size.X-11, Size.Y-3);

				EndInit;

				EnterCriteria := Desktop^.ExecView(EditBox);

				dispose(EditBox, done);
			end; {with}
		end; {eaSearch}
	else {case}
		EnterCriteria := inherited EnterCriteria(eaType);
	end;
end;

procedure TWarrantySearch.SetHeaderCodes;
begin
	inherited SetHeaderCodes(FormCodes);

	with FormCodes^ do begin
		SetStr('RTITLE','EXPIRED WARRANTY REPORT');
		SetStr('RPTDESC',CRLF+delspace(PWarrantySearchOptions(SearchOptions)^.SearchRange.Text(daAbbr))+CRLF);
		SetStr('LISTHDR','  Type, Make & Model                   Serial No         Expiry   Warranty');
	end;
end;


	function CheckWareMatch(const Hook : PHook; const SearchOptions : PWarrantySearchOptions) : boolean; far;
	var Jimmy : PJImmy;
	begin
		CheckWareMatch := False;
		{-- Hardware ---}
		if Hook^.srType = srHardware then begin
			Jimmy := GetJimmy(Hook^.JImmyID);
			if (Jimmy <> nil) then begin
				if not PHardware(Jimmy)^.DOExpiry.Blank and
					PWarrantySearchOptions(SearchOptions)^.SearchRange.inRange(PHardware(Jimmy)^.DOExpiry) then
						CheckWareMatch := True;
				dispose(Jimmy, done);
			end;
		end;
		if Hook^.srType = srSoftware then begin
			Jimmy := GetJimmy(Hook^.JImmyID);
			if (Jimmy <> nil) then begin
				if not PSoftware(Jimmy)^.DOExpiry.Blank and
					PWarrantySearchOptions(SearchOptions)^.SearchRange.inRange(PSoftware(Jimmy)^.DOExpiry) then
						CheckWareMatch := True;
				dispose(Jimmy, done);
			end;
		end;
	end;



{==== CHECK MATCH JIMMY ============}
function TWarrantySearch.MatchItem;
var	FoundHook : PHook;
		M : boolean;

	function CheckMatch(Hook : PHook) : boolean; far;
	begin
		CheckMatch := CheckWareMatch(Hook, PWarrantySearchOptions(SearchOptions));
	end;

begin
	M := inherited MatchItem(Item); {check for aliases}

	if M then begin {if was OK}
		{using firstthat means it doesn't bother searching beyond that}
		FoundHook := PHook(HookFile^.FirstThat(PDirectoryitem(Item)^.Ptr2More, @CheckMatch));

		M := FoundHook<>nil;
		if FoundHook<>nil then dispose(FoundHook, done);
	end;

	MatchItem := M;
end;


type
	PWarePrintInfo = ^TWarePrintInfo;
	TWarePrintInfo = object(TObject)
		SearchOptions : PWarrantySearchOptions;
		DirectoryID : longint;

		constructor Init(NOptions : PWarrantySearchOptions; NID : longint);
	end;

	constructor TWarePrintInfo.Init;
	begin
		inherited Init;
		SearchOptions := NOptions;
		DirectoryID := NID;
	end;

procedure PrintMatchingItems(const Device : PDeviceStream; const Code, SubCode,Param : TFCodeStr; const Info : PObject); far;
var WarePrintInfo : PWarePrintInfo;
		DirectoryItem : PDirectoryItem;

	procedure PrintIfMatched(Hook : PHook); far;
	var Ware : PJimmy;
	begin
		if CheckWareMatch(Hook, WarePrintInfo^.SearchOptions) then begin
			Ware := GetJimmy(Hook^.JimmyID);
			Ware^.PrintLine(Device);
			dispose(Ware, done);
		end;
	end;

begin
	WarePrintInfo := PWarePrintInfo(Info);

	DirectoryItem := PDirectoryItem(GetJimmy(WarePrintInfo^.DIrectoryID));

	HookFile^.ForEach(DirectoryItem^.Ptr2More, @PrintIfMatched);

	dispose(DirectoryItem, done);
end;

procedure TWarrantySearch.OutputItem;
begin
	CurrentDirectoryID := PJimmy(Item)^.RecNo; {for above function}

	{set up a formcode with all the hardware items listed}
	OutputDevice^.FormCodes^.Insert(New(PFlushFormCode, init('ITEMS', PrintMatchingItems,
					New(PWarePrintInfo, init(SearchOptions, PJimmy(Item)^.RecNo)))));

	inherited OutputItem(Item, ItemNo);


end;


const
	WarrantyPrintOptions : TDIrectoryPrintOptions = (
		Tag 	: False;
		List 	: False;

		Editor 	: edInternal;
		Target  : ptPrint;
		DeviceName : '';
		PrintAs : paSummary;
		Header 	: 'WARRANTY';
		Form   	: 'WARRANTY';
		MarkHistory : False;
		SortKey : '');

procedure ExpWarrantySearch;
var Search : TWarrantySearch;
begin
	with Search do begin
		Init;
		PrintOptions := WarrantyPrintOptions;
		OnSearchOKDo := cmPrint;
		DoSearch;
		Done;
	end;
end;



begin
	RegisterTask(DesktopTasks, cmWarrantyReport, @ExpWarrantySearch);
end.

