{***********************************************************************
 ***                     INVOICE SETUP OBJECT                        ***
 ***********************************************************************}
{$I compflgs}

unit KinvSetU;

INTERFACE

uses tuiedit, setup;

const
	siCopyToHistory = 'COPY TO HISTORY';

type
	PInvoiceSetup = ^TInvoiceSetup;
	TInvoiceSetup = object(TSetup)

		DefaultDiscountDays : byte;
		DisplayDiscounted : boolean;
		DDOverride : boolean; {days discount override first overdue period}
		OverduePeriod : array[1..3] of word;
		CopyToHistory : boolean; {make a copy of invoice in history}

		procedure Load; virtual;
		procedure Store; virtual;
		procedure SetButtonDefaults; virtual;
		procedure AddSetupLines(EditBox : PEditBox); virtual;
	end;

var
	InvoiceSetup : TInvoiceSetup;


IMPLEMENTATION

uses tasks,
			global,
			minilib, objects, views, kamsetup;

procedure EditInvoiceSetup; far;
begin InvoiceSetUp.Edit; end;



procedure TInvoiceSetup.Load;
begin
	DefaultDiscountDays := S2Num(GEt('DISCOUNT DAYS','28'));
	DisplayDiscounted 	:= GetBoolean('DISPLAY DISCOUNTED',True);
	DDOverride 					:= GetBoolean('DD OVERRIDE',True);

	OverduePeriod[1] 		:= S2Num(Get('OVERDUE 1','30'));
	OverduePeriod[2] 		:= S2Num(Get('OVERDUE 2','60'));
	OverduePeriod[3] 		:= S2Num(Get('OVERDUE 3','90'));

	CopyToHistory 			:= GetBoolean(siCopyToHistory,True); {make a copy of invoice in history}

	if OverduePeriod[1] + OverduePeriod[2] + OverduePeriod[3] = 0 then
		SetButtonDefaults;
end;

procedure TInvoiceSetup.SetButtonDefaults;
begin
	DefaultDiscountDays := 28;
	DisplayDiscounted 	:= True;
	DDOverride 					:= True;
	OverduePeriod[1] 		:= 30;
	OverduePeriod[2] 		:= 60;
	OverduePeriod[3] 		:= 90;
	CopyToHistory 			:= False;{}
end;

procedure TInvoiceSetup.Store;
begin
	Put(				'DISCOUNT DAYS'			,N2Str(DefaultDiscountDays));
	PutBoolean(	'DISPLAY DISCOUNTED',DisplayDiscounted);
	PutBoolean(	'DD OVERRIDE'				,DDOverride);

	Put('OVERDUE 1', N2Str(OverduePeriod[1]));
	Put('OVERDUE 2', N2Str(OverduePeriod[2]));
	Put('OVERDUE 3', N2Str(OverduePeriod[3]));

	PutBoolean(siCopyToHistory, CopyToHistory); {make a copy of invoice in history}

	ProgramSetup.Store;
end;

{============ EDIT ======================}
procedure TInvoiceSetup.AddSetupLines;
var R : TRect;
begin
	with EditBox^ do begin
		GrowTo(35, 16);

		InsTitledField(25,  2, 3, 1, 'Default Days ~D~iscount', New(PinputByte, Init(R, 3)));
		InsTitledField(25,  4, 1, 1, 'Display Discount Totals', New(PinputBoolean, init(R)));
		InsTitledField(25,  5, 1, 1, 'DD Override Overdue', New(PinputBoolean, init(R)));

		InsTitledField(25,  7, 5, 1, 'Overdue 1', New(PInputWord, init(R, 5)));
		InsTitledField(25,  8, 5, 1, 'Overdue 2', New(PInputWord, init(R, 5)));
		InsTitledField(25,  9, 5, 1, 'Overdue 3', New(PInputWord, init(R, 5)));

		InsTitledField(25, 11, 1, 1, 'Copy To History', 				New(PinputBoolean, init(R)));
	end;
end;



begin
	InvoiceSetup.Init('Invoice');
	RegisterTask(DesktopTasks, cmEditInvoiceSetup, @EditInvoiceSetup);
end.
