{*************************************************************************
 ***                                                                   ***
 ***                         LETTER REPORTS                            ***
 ***                                                                   ***
 *************************************************************************}
{$I compdirs}
unit KLtrRpts;

INTERFACE

procedure UnsentLetters;

procedure PrintDeferredLetters;
procedure DeleteDeferredLetters;
function  GetNoDeferredLtrs(Path : string) : word;

IMPLEMENTATION

uses	kdirctry,
			jimhooks,
			jimindxs,
			minilib,
			kamsetup,
			app,
			tasks,
			dos,
			doslink,
      global,
      jimmys,
      kletter,
      files,
      printout,
			views, tuimsgs;

{*************************************************************************
 ***                                                                   ***
 ***                         UNSENT LETTERS REPORT                     ***
 ***                                                                   ***
 *************************************************************************}
{Lists all Letters that have not been sent/completed/etc}
procedure UnsentLetters;
var
	ProBox : PProgressBox;
	Rec : longint;
	DirectoryItem : PDirectoryItem;
	Letter : PLetter;
	Control : word;
	S : string;

begin
	{********************************
	 ***      PRODUCE REPORT      ***
	 ********************************}
	ProBox := NewProgressBox('UNSENT LETTERS REPORT','');
	PrintStream.ClearCodes;
	PrintStream.SetCode('RTITLE','UNSENT LETTERS REPORT');
	PrintStream.StartRpt('UNSLTRS'); {}

	FileAdmin(fiJimmys)^.LogOn;
	FileAdmin(fiFullDirIdx)^.LogOn;
	FileAdmin(fiHooks)^.LogOn; {saves continual opening & closing}

	ThinkingAllowed := False;  {"Loading list" appears a lot & slows it down...}

	Rec := 0;
	while Rec<Stream(fiFullDirIdx)^.NoRecs-1 do begin
		if Rec div 10 = Rec /10 then ProBox^.Update('Looking through Directory'+#13#10+
																								'Done',Rec,Stream(fiFullDirIdx)^.NoRecs-1);

		DirectoryItem := PDirectoryItem(PIndexedJimmyStream(Stream(fiFullDirIdx))^.GetJimmyAtIdx(Rec));

		if DirectoryItem <> nil then begin

			if DirectoryItem^.GotByIx=1 then begin {avoid aliases}
				{Run through chain}
				Letter := PLetter(HookFile^.FindFirst(DirectoryItem^.Ptr2History, srLetter));

				while Letter<>nil do begin

					{---- No date = not sent ---}
					if (Letter^.DateSent.Blank) then begin

						{Print letter details}
						PrintStream.writeln('');
						S := PadSpaceR(DirectoryItem^.GetName(naReport,0),40)
									+' Ref: '+PadSpaceR(Letter^.Ref,5);
						PrintStream.writeln(S);

					end;

					Dispose(Letter, Done);
					Letter := PLetter(HookFile^.FIndNext);
				end;

			end; {ix=1}

			dispose(DirectoryItem, done);

		end; {if not nil}

		{Cancel}
		if ProBox^.Command = cmCancel then Rec := Stream(fiFullDirIdx)^.NoRecs-1; {Force for loop to end}

		Rec := Rec +1;
	end; {while through directory}

	PrintStream.EndPrint;

	Desktop^.Delete(Probox);
	Dispose(ProBox, done);

	FileAdmin(fiFullDirIDx)^.LogOff;
	FileAdmin(fiJimmys)^.LogOff;
	FileAdmin(fiHooks)^.LogOff;

	ThinkingAllowed := True;

end;

{**************************************************************************
 ***                                                                    ***
 ***                      DEFERRING LETTERS                             ***
 ***                                                                    ***
 **************************************************************************}

function GetNoDeferredLtrs(Path : string) : word;
var FileInfo : SearchRec;
		NoLtrs : integer;
		FileNo : integer;
begin
	{Looks for last DFR*.LTR}
	{There are two ways we could do this - read in the directory and look,
	or an easy way (but slower?), try opening each one, as soon as it fails
	you know you've reached the end...}
	NoLtrs := 0;

  {or use dos unit functions}
	FindFirst(Path+'DFR*.LTR', Archive, FileInfo);
	while DosError = 0 do	begin
		 FileNo := S2Lint(Copy(FileInfo.Name,4,5));
		 if FileNo >NoLtrs then NoLtrs := FileNo;  {highest letter number}
		 FindNext(FileInfo);
	end;{}

	GetNoDeferredLtrs := NoLtrs;
end;


procedure PrintDeferredLetters;
var NoLtrs : integer;
		LtrNo : integer;
		LtrName : string;
		Letter : text;
		LastIOResult : integer;
		Line : string;
		Control :word;

begin
	{Print ordinary editor letters}
	NoLtrs := GetNoDeferredLtrs(DataPath);

	if NoLtrs =0 then
		PauseMessage('No editor letters to print','')
	else begin

		Control := ConfirmMessage('About to print editor letters',L2Str(NoLtrs)+' to print');

		if Control = cmYes then begin

			PrintStream.ClearCodes;
			PrintStream.StartPrint('','');

			for LtrNo := 1 to NoLtrs do begin
				ThinkingOn('Printing  No. '+L2Str(LtrNo));

				LtrName := 'DFR'+PadZero(L2Str(LtrNo),4)+'.LTR';
				Assign(Letter, DataPath + LtrName);
{$I-}
				reset(Letter);
				LastIOResult := IOresult;
{$I+}
				if LastIOResult <> 0 then
					DBaseWarning('Could not open letter '+LtrName,'Going on to next...')
				else begin

					while not eof(Letter) do begin
						Readln(Letter, Line);
						PrintStream.Writeln(Line);
					end;
				end;

				close(Letter);

				{And delete letter}
				DeleteFile(DataPath+LtrName);  {in doslink - uses DOS interrupt}

				ThinkingOff;
			end;

			PrintStream.EndPrint;

		end; {Control = cmOK}

	end;
end;

procedure DeleteDeferredLetters;
var NoLtrs : integer;
		LtrNo : integer;
		LtrName : string;
		Control :word;

begin
	{Print ordinary editor letters}
	NoLtrs := GetNoDeferredLtrs(DataPath);

	if NoLtrs =0 then
		PauseMessage('No editor letters to clear','')
	else begin

		Control := ConfirmMessage('About to clear editor letters',L2Str(NoLtrs)+' present');

		if Control = cmYes then begin

      ThinkingOn('Deleting');
			for LtrNo := 1 to NoLtrs do begin
				LtrName := 'DFR'+PadZero(L2Str(LtrNo),4)+'.LTR';
				DeleteFile(DataPath+LtrName);  {in doslink - uses DOS interrupt}
      end;
      ThinkingOff;
		end;
  end;
end;


begin
{$IFDEF kdirctry}
	RegisterTask(DesktopTasks, cmDeferredLetters, PrintDeferredLetters);
	RegisterTask(DesktopTasks, cmDeleteDeferredLetters, DeleteDeferredLetters);

	{Unsent letters report option}
	RegisterTask(DesktopTasks, cmUnsentLetters, UnsentLetters);
{$ENDIF}
end.

