{****************************************************************************
 ***                                                                      ***
 *** New Fabbo Singing Dancing OOP                                        ***
 ***                         More-about Note                              ***
 ***                                                                      ***
 *** M Hill                                                      Jan 1993 ***
 ****************************************************************************}
{$I compdirs}  {Compiler directives}

unit KMNote;

INTERFACE

uses
{$IFDEF WINDOWS}
	wui;	{windows}
{$ELSE}
	tuiedit,views, {text}
{$ENDIF}
		global, files, scodes, jimmys, notes, devices, forms, objects;

{const
 TMoreNoteSize = 25;{}

type
 PMoreNote = ^TMoreNote;
 TMoreNote = object(TJimmy)

	 ForWho		 : longint;
	 Code      : TSCode;
	 Notes     : PFreeTextData;

	 {-- Methods --}
	 constructor Init(Param : PJImmyInitParam);
	 procedure CommonInit; virtual;
	 destructor Done; virtual;

		function DisplayLine(ListForWho : longint; lstype : byte; Maxlen : integer; View : word) : string; virtual;

	 procedure MakeEditBox(var EditBox : PEditBox; Caller :PView); virtual;

		procedure Print(prType : word; Device : PDevicestream); virtual;

	 {DataBase}
		constructor Load(var S : TDataStream);
		procedure   StoreFields(var S : TDataSTream);              virtual;

		function RecSize : word; virtual;
		function srType : word; virtual;

		{for fixit, etc}
		function NumIDs : byte; virtual; {the number of jimmy ID ptrs in the data}
		function GetJimmyID(const jiType : byte) : PLongint; virtual; {each jimmy ID}

		{-- Hooking to others -----}
		function NumHookTo : byte; virtual;
		procedure GetHookTo(const htType : byte; var HookToID,SubHookToID : PLongint;
												var hkType : byte; var Key : longint; var InsertBias : boolean); virtual;
	end;

function CreateMoreNote(P : pointer): pointer;

const
	{--- Required for Stream ----}
	RMoreNote : TStreamRec = (
		ObjType : srMoreNote;
		VmtLink : Ofs(TypeOf(TMoreNote)^);
		Load : @TMoreNote.Load;
		Store : @TMoreNote.Store
	);

	{--- Required for Stream ----}
	Rv2MoreNote : TStreamRec = (
		ObjType : srv2MoreNote;
		VmtLink : Ofs(TypeOf(TMoreNote)^);
		Load : @TMoreNote.Load;
		Store : @TMoreNote.Store
	);{}


IMPLEMENTATION

uses tasks,
			lstrings,
			help,
			tui, tuijimmy,
		 tuimsgs,  minilib;

{**************************************************************
 ***                                                        ***
 ***               DEFINE MoreNote OBJECT              ***
 ***                                                        ***
 **************************************************************}

constructor TMoreNote.Init;
begin
	inherited Init;
	if Param <> nil then ForWho := Param^.ForWho else ForWho := -1;
end;

procedure TMoreNote.CommonInit;
begin
	inherited CommonInit;
	New(NOtes, init);
	SCodeCollection[scDetails]^.LogOn;
end;

destructor TMoreNote.Done;
begin
	SCodeCollection[scDetails]^.LogOff;
	Dispose(Notes, done);
	inherited done;
end;

{==== CREATE DISPLAY-LINE-FORMAT STRING ============}
function TMoreNote.DisplayLine;
var S : string;
begin
	if not Notes^.Loaded then Notes^.LoadText;
	if delspaceR(Code)<>'' then S := ucase(SCodeCollection[scDetails]^.Desc(Code)) +CRLF else S := '';
	LSRewidth(Notes^.Text, Maxlen);
	LSRemove(Notes^.TExt, EndParaChar);
	DisplayLine := S + LS2String(Notes^.Text);
end;

{*****************************************
 ***        SCREEN INPUT BOX           ***
 *****************************************}

procedure TMoreNote.MakeEditBox;
var	R: TRect;

begin
	if not NOtes^.Loaded then Notes^.LoadText;
	R.Assign(0, 0, 40, 16) ;
	CentreOnView(R, Caller);
	EditBox := New(PJimmyEditbOx, init(R, 'Comment',Caller, @Self));

	inherited MakeEditBox(EditBox, Caller);

	with EditBox^ do begin

		Insert(New(PSkipBytes, init(4))); {skip ForWho pointer}

		InsTitledField(1,1,36, 1, '', New(PInputScode, init(R, scDetails)));

		R.Assign(1,3,39,12);
		Insert(New(PInputFreeText, Init(R, 500, 38, nil)));

		{-- Buttons --}
		Insert(New(PJimmyOKButton, Init(14,13, @Self)));
		Insert(New(PJimmyCancelButton, init(25,13, @Self)));

    EndInit;
	end;
end;


{*****************************************
 ***     STREAMING DEFINITIONS         ***
 *****************************************}
function TMoreNote.recSize;
begin RecSize := 25; end;


function TMoreNote.srType;
begin	srType := srMoreNote; end;

{-- Hooking to others -----}
function TMoreNote.NumHookTo;
begin NumHookTo := 1; end;

{for returning which jimmys ID's this jimmys should be hooked *to*}
procedure TMoreNote.GetHookTo;
begin
	inherited GetHookTo(htType, HookToID,SubHookToID, hkType, Key, InsertBias);
	case httype of
		1 : begin
			HookToID := @ForWho;
			hkType := hkMore;
			InsertBias := biStart;
		end;
	end;
end;

constructor TMoreNote.Load(var S : TDataStream);
var Ver : byte;
		Rubbish : longint;

begin
	S.Read(Ver, 1);
	case Ver of
	4 : begin
		{v4.1 - added lock}
		inherited Load(S);
		S.Read(ForWho, 4);
		S.Read(Code, sizeof(Code));
		Notes^.Load(S);
	end;
	3 : begin
		{Jimmy time}
		CommonINit;
		S.Read(ForWho, 4);
		S.Read(Code, sizeof(Code));
		Notes^.Load(S);
	end;
	2 : begin
		CommonINit;
		S.Read(Rubbish, 4); {old ptr2cha}
		S.Read(ForWho, 4);
		S.Read(Code, sizeof(Code));
		Notes^.Load(S);
	end;
	1 : begin
		CommonINit;
		S.Read(Rubbish, 4); {old ptr2cha}
		S.Read(ForWho, 4);
		Code := 'DIR';  {Directions}
		Notes^.Load(S);
	end else
		DBaseMessage(@S, 'Version '+N2Str(Ver)+' not understood'#13#10'TMoreNote.Load', mfError,hcInternalErrorMsg);
		fail;
	end;
end;

procedure TMoreNote.StoreFields(var S : TDataStream);
var	Ver : byte;
begin
	Ver := 4; S.Write(ver ,1);

	inherited StoreFields(S);

	S.Write(ForWho, 4);
	S.Write(Code, sizeof(Code));
	Notes^.Store(S);
end;

{============== POINTERS TO OTHER JIMMYS===================}
function TMoreNote.NumIDs;
begin NumIDs := 1; end;

function TMoreNote.GetJImmyID;
begin
	case jiType of
		1 : GetJimmyID := @ForWho;
	else
		GetJimmyID := nil;
	end;
end;


{*************************************
 **        PRINT SUMMARY           ***
 *************************************}
procedure TMoreNote.Print;
var I : byte;
begin
	inherited Print;
{	LoadSupplements;

	if Device = nil then begin
		inherited Print(prType, Device);
		exit;
	end;

	case prType of
		prFullBlck : begin
			{======= PRINT SUMMARY ================}
{			Device^.Writeln(UCase(SCodeCollection[scDetails]^.Desc(Code)));
			Device^.Writeln('');
			LSReWidth(Notes^.Text, Device^.Paper^.Width-Device^.Paper^.LeftMargin);
			for I := 1 to LSNumLines(Notes^.Text) do
				Device^.Writeln(LSGetLine(Notes^.Text, I));  {A bit clumsy to put it mildly}
{		end;
	else
		inherited Print(prType, Device);
	end;{}
end;



function CreateMoreNote;
begin CreateMoreNote := New(PMoreNote, Init(PJimmyInitParam(P))); end;


{**********************************
 ***         MORE GLOBALS       ***
 **********************************}
begin
{$IFDEF fixit} writeln('MNote...'); {$ENDIF}
	{Register Various sentence codes}
	New(SCodeCollection[scDetails], Init('Kdetails.SC',   'Notes/Comments', StdScodeCreator));

	{Register with streams}
	RegisterType(Rv2MoreNote);
	RegisterType(RMoreNote);

	{Register existence with more about list}
	RegisterCreator(cmNewMoreNote, CreateMoreNote);
	RegisterNewWithList(lsMoreAbout, '~N~ote', cmNewMoreNote);

{$IFDEF klivestk}
	RegisterNewWithList(lsLiveStockMore, '~N~ote', cmNewMoreNote);
{$ENDIF}
end.
