{************************************************************************
 ***                                                                  ***
 *** New Fabbo Singing Dancing OOP                                    ***
 ***                            PURCHASE ORDER                        ***
 ***                                                            Nov 94***
 *** M Hill                                                 rev May 96***
 ***********************************************************************}
{For making Purchase orders}

{$I compdirs}  {Compiler directives}
unit kPOrder;

INTERFACE

uses 	linklist,
			notes, dattime,
			multcurr,
			jimmys,
			tuiedit,
			objects,
			global,
			jimprint,
			views,
			forms, devices,
			files,
			dialogs,
			ordproc;

{*****************************
 ***  POrder              ***
 *****************************}
type
	PPOrder = ^TPOrder;
	TPOrder = object(TOrder)

{now in torder		SupRef : string[10]; {supplier reference}

{		Comment   : PFreeTextData;            {Text on POrder}

		procedure CommonInit; virtual; {init procedures common to Init and Load (eg scode logging)}
		destructor Done; virtual;

		{--- Editing ----}
		procedure MakeEditBox(var EditBox : PEditBox; Caller : PView); virtual;

		{--- Viewing -----}
		function DisplayLine(ListForWho : longint; lstype : byte; Maxlen : integer; View : word) : string; virtual;
		function GetName(naType : byte; Maxlen : integer) : string; virtual; {used for various displays/prints -
																																					eg selection lines, window headers, etc}
		{--- Printing ----}
		procedure PrintFull(const Device : PDeviceStream; const PrintAs : word); virtual;
		procedure GetDefaultPrintType(var PrintType : TJimmyPrintType; var PrintAs : PSItem; var PrintAsLink : pointer); virtual;

		{--- Database ----}
		function RecSize : word; virtual; {space to be reserved in jimmy file}
		function srType : word; virtual; {descendants set as fixed, so can be
																			used to identify jimmy for file operations, etc}
		function PtrOffset : byte; virtual; {extra ver no}

		procedure Storefields(var S : TDataStream); virtual;
		constructor Load(var S : TDataStream);
	end;


IMPLEMENTATION

uses tui, tuimsgs,
			idindex,
			inpdnt,
			help,
			kinvsetu, {for checking overdue level}
			kdirctry,
			tasks,
			tuijimmy,
			jimhooks,
			minilib;

{***********************************************************************
 ***                                                                 ***
 ***                      POrder                                ***
 ***                                                                 ***
 ***********************************************************************}
procedure TPOrder.COmmonInit;
begin
	inherited CommonInit;
end;

destructor TPOrder.Done;
begin
	inherited Done;
end;

{==== CREATE DISPLAY-LINE-FORMAT STRING ============}
function TPOrder.DisplayLine;
var S : string;
begin
	S := Date.Digit8+' PURCHASE ORDER';

	DisplayLine := S;
end;

function TPOrder.GetName;
begin
	GetName := 'PUR #'+N2Str(Ref)+' '+GetJimmyIDName(ForWho,naRef,0)+' '+Date.Text(daDigit8);
end;


{**************************************************
 ***             EDIT BOX                       ***
 **************************************************}

procedure TPOrder.MakeEditBox;
var	R: TRect;
		ForLine, RefLine, ByLine, PmntView, ItemView : PView;

begin
	R.Assign(0, 0, 70, 19);
	CentreOnView(R, Caller);
	EditBox := New(PJimmyEditBox, Init(R, 'Purchase Order',Caller, @Self));

	with EditBox^ do begin
		Insert(New(PSkipBytes, init(sizeof(TJimmy))));
		Insert(New(PSkipBytes, init(4+sizeof(TDate)))); {skip forop & lastprint}

		R.Assign(0,0,0,0); Insert(New(PStateField, init(RecNo)));

		{price group}
		Insert(New(PInputTotallerGroup, init(Size.X-21, 13, EditBox)));

		{ref, etc}
		InsTitledField(7,  1, 5, 1, 'Ref', New(PInputRefNum, init(R,5, srPurchaseOrder)));
		Insert(New(PSkipBytes, init(4))); {oldref}
		InsTitledField(20, 1,10, 1, '~D~ate', New(PinputDate, Init(R)));

		ForLine := InsTitledField( 7,  3,30,1, '~T~o',  New(PInputDirectory, init(R, 30,  fiFullDirIdx, lsDirectory,'')));
		PInputELine(ForLine)^.MustInput := True;

		InsTitledField(50, 3, 10, 1, 'Cust Ref', New(PInputPStr, init(R,10)));

		ByLine  := InsTitledField( 7, 4,30,1, '~B~y',  New(PInputDirectory, init(R, 30,  fiFullDirIdx, lsDirectory,'')));

		ItemView := InsTitledField(7, 6,60,7, '~F~or',
																New(PDlgHookView,	Init(R, lsSalesItems, 0, hkOrderItems, @Self, PJimmyEditBox(EditBox))));
		Insert(PHookViewer(ItemView)^.VScrollBar);

		InsTitledField(7, 14, 20, 4, 'N~o~tes', New(PInputFreeText, Init(R,200,20,nil)));

		{-- Buttons --}
		Insert(New(PJimmyOKButton, Init(48,Size.Y-3, @Self)));
		Insert(New(PjimmyCancelButton, init(58,Size.Y-3, @Self)));

		EndInit;
	end;

	if ForWho=-1 then
		ForLine^.FOcus
	else
		ItemView^.Focus; {hmmm, this makes it automatically save...}
end;

{*****************************************
 ***     STREAMING DEFINITIONS         ***
 *****************************************}
function TPOrder.RecSize;
begin RecSize := 100; end;

function TPOrder.srType;
begin srType := srPurchaseOrder; end;

function TPOrder.PtrOffset;
begin PtrOffset := inherited PtrOffset + 1; end; {extra ver in load}

constructor TPOrder.Load(var S : TDataStream);
var	Ver : byte;

begin
	S.Read(Ver, 1);

	case Ver of
		1 : begin
			inherited Load(S); {common init, lock, delete marker}
			S.Read(ByWho, 4);
			Notes^.Load(S);
			ForWhoRef := NewStr(S.REadStr);
		end;
		2 : begin
			{all moved to TOrder}
			inherited Load(S); {common init, lock, delete marker}
		end;
	else
		DBaseMessage(@S, 'Version '+N2Str(Ver)+' not understood'#13#10'POrder.Load',mfError,hcInternalErrorMsg);
		fail;
	end;
end;

procedure TPOrder.StoreFields(var S : TDataStream);
var	Ver : byte;

begin
	Ver := 2; S.Write(Ver, 1);

	inherited StoreFields(S);
end;


{*****************************************
 ***  PRINTING                         ***
 *****************************************}
const
	POrderPrintType : TJimmyPrintType =
		(Editor : edInternal;
		 Target : ptPrint;
		 DeviceName : '';
		 PrintAs : 0;
		 FormName : 'PORDER';
		 NumCopies : 1;
		 PlusLabel : False);

procedure TPOrder.GetDefaultPrintType
										(var PrintType : TJimmyPrintType; var PrintAs : PSItem; var PrintAsLink : pointer);
begin
	PrintAs := 	nil;
	PrintType := POrderPrintType;
	PrintAsLink := nil;
end;


procedure TPOrder.PrintFull;
begin	PrintForm(Device, 'PORDER'); end;


{*****************************************
 ***  INITIALISATION/REGISTRATION      ***
 *****************************************}
const
	{--- Required for Stream ----}
	RPOrder : TStreamRec = (
		ObjType : srPurchaseOrder;
		VmtLink : Ofs(TypeOf(TPOrder)^);
		Load : @TPOrder.Load;
		Store : @TPOrder.Store
	);


function CreatePOrder(P : pointer) : pointer; far;
begin	CreatePOrder := New(PPOrder, init(P)); end;


begin
{$IFDEF fixit} writeln('KPOrder...'); {$ENDIF}
	RegisterJimmy(RPOrder, CreatePOrder, lsHistory, '~P~urchase Order');

	{Register with directory history}
{	RegisterNewWithList(lsHistory, '~S~ales Order', cmNewPOrder);{}

	{Register with desktop}
	RegisterNewWithList(lsDesktop, '~P~urchase Order', cmNewPurchaseOrder);{}
{	RegisterTask(DesktopTasks, cmNewPurchaseOrder, @CreateEditJimmy); {see jimmys}
end.
