{****************************************************************************
 ***                                                                      ***
 *** New Fabbo Singing Dancing OOP                                        ***
 ***                          OwnedProduct DETAILS                            ***
 ***                                                                      ***
 *** M Hill                                                      Nov 1992 ***
 ****************************************************************************}
{$I compdirs}  {Compiler directives}

unit KPRODOWN;

INTERFACE

uses dattime, kmore, output, views, objects,
			inpflds, inptext;

const
 TOwnedProductSize = TMoreItemSize + 30;        {GUESSED}

type
 POwnedProduct = ^TOwnedProduct;
 TOwnedProduct = object(TMoreItem)

		Obtained  : TDate;
		ProductID : longint;
		Quantity  : word;
		SerialNum : string[20];
		Notes			: PNoteData;

	 	{-- Methods --}
		constructor Init(Param : pointer);
 		procedure CommonInit; virtual;
		destructor Done; virtual;
	 	function DisplayLine(Maxlen : integer) : string; virtual;
	 	procedure StartEditBox(var EditBox : PEditBox; Caller : PView);  virtual;
		function Print(prType : word; Output : Poutputstream) : word; virtual;

	 	{DataBase}
	 	constructor Load(var S : TStream);
	 	procedure   Store(var S : TSTream);              virtual;

 	end;


IMPLEMENTATION

uses  files, global,
			estrings,
			inpdnt,
			messages,
			scodes,
			kproduct, inpprod;


{**************************************************************
 ***                                                        ***
 ***               DEFINE OwnedProduct OBJECT                     ***
 ***                                                        ***
 **************************************************************}

constructor TOwnedProduct.Init;
begin
	inherited INit(Param);
	Quantity := 1;  {Default}
  Obtained.Clear;
	ProductID := -1;
	SerialNum := '';
end;

procedure TOwnedProduct.CommonInit;
begin
	inherited CommonInit;
	New(Notes, init);
end;

destructor TOwnedProduct.Done;
begin
	dispose(notes, done);
	inherited Done;
end;

{==== CREATE DISPLAY-LINE-FORMAT STRING ============}
function TOwnedProduct.DisplayLine(maxlen : integer) : string;
var Product : PProduct;
		S : string;

begin
	FileAdmin[fiProducts]^.LogOn;
  Product := PProduct(ProductStream^.GetAtID(ProductID,lkIgnore));
	FileAdmin[fiProducts]^.LogOff;

	if Product<>nil then begin
		S := ExpandScode(scProductCategory, Product^.Category)+' '+Product^.Desc;
		dispose(Product, done);
	end else
		if ProductID=-1 then
			S := ''
		else
			S := 'Cannot retrieve Product '+L2Str(ProductID);

	DisplayLine := S+' x'+L2Str(Quantity)+'   '+SerialNum;
end;


{*****************************************
 ***        SCREEN INPUT BOX           ***
 *****************************************}
procedure TOwnedProduct.StartEditBox;
var	R: TRect;

begin
	if not Notes^.Loaded then Notes^.LoadText;

	R.Assign(0,0,45,14);
	EditBox := New(PEditBox, init(R, 'Owned Product'));
	inherited StartEditBox(EditBox, Caller);

	with EditBox^ do begin
		InsTitledField(11, 2,10,1, 'Obtained', New(PInputDate, Init(R)));
		InsTitledField(11, 3,30,1, 'Product', New(PInputProduct, Init(R, 20)));
		InsTitledField(11, 4, 5,1, 'Quantity', New(PInputWord, Init(R, 5)));
		InsTitledField(11, 5,20,1, 'Serial #', New(PInputELine, Init(R, 20)));
		InsTitledField(11, 6,30,4, 'Notes', New(PInputNote, init(R, 500, 60, nil, @Self)));

		{-- Buttons --}
		InsOKButton(24,11, @Self);
		InsCancelButton(35,11);
	end;
end;


{*****************************************
 ***     STREAMING DEFINITIONS         ***
 *****************************************}
constructor TOwnedProduct.Load(var S : TStream);
var	Ver : byte;

begin
	S.Read(Ver, 1);

	CommonInit;

	case Ver of
		1 : begin
			inherited Load(S);
			Obtained.Load(S);
			S.Read(ProductID,4);
			S.Read(Quantity,2);
			S.REad(SerialNum, sizeof(SerialNum));
			Notes^.Load(S);
		end
	else
		DBaseError(@S, 'Version number '+L2str(ver)+'not understood','Retrieving Owned Product');
	end;
end;


procedure TOwnedProduct.Store(var S : TStream);
var	StartPos : longint;
		Ver : byte;

begin
	StartPos := S.GetPos;

	Ver := 1; S.Write(Ver,1);

	inherited Store(S);  {Store chain & person pointers}
	Obtained.Store(S);
	S.Write(ProductID,4);
	S.Write(Quantity,2);
	S.Write(SerialNum, sizeof(SerialNum));
	Notes^.Store(S);

	FillRecord(S, TOwnedProductSize, StartPos);
end;


{*******************************************
 ***            PRINT SUMMARY            ***
 *******************************************}
function TOwnedProduct.Print;
begin
	Print := cmCancel;
	if prType = prSummary then begin
	end;
end;


{=============== NEW FUNC ===========}
function CreateOwnedProduct(P : pointer) : pointer;
begin	CreateOwnedProduct := New(POwnedProduct, Init(P)); end;

const
	{--- Required for Stream ----}
	ROwnedProduct : TStreamRec = (
		ObjType : srOwnedProduct;
		VmtLink : Ofs(TypeOf(TOwnedProduct)^);
		Load : @TOwnedProduct.Load;
		Store : @TOwnedProduct.Store
	);

{************************************
 ***         INITIALISATION       ***
 ************************************}
begin
	{Register Various sentence codes}
	RegisterType(ROwnedProduct); {Register for streams}

{$IFDEF kProdOwn}
	{Register existence with more list}
	NewMoreItem('~O~wns',cmNewOwnedProduct, CreateOwnedProduct); {}
{$ENDIF}

end.


