{************************************************************************
 ***                                                                  ***
 *** New Fabbo Singing Dancing OOP                                    ***
 ***                            QUICK-INVOICE                         ***
 ***                                                            Nov 94***
 *** M Hill                                                 rev May 96***
 ***********************************************************************}
{Now that I've added a "Quick" marker to the main invoice, this object only
survives for Kilimanjaro water, Kenya, v4.2.  With the quick marker set,
other systems should use that, so that invoice numbers, etc, stay consistent}

{$I compdirs}  {Compiler directives}
unit kQInv;

INTERFACE

uses 	jimmys,
			kinvoice;

{*****************************
 ***  Invoice              ***
 *****************************}

type
	PQuickInvoice = ^TQuickInvoice;
	TQuickInvoice = object(TInvoice)

		procedure CommonInit; virtual;
		function srType : word; virtual;
	end;


IMPLEMENTATION

uses objects,
			tuiboxes,
			tuimsgs,
			tasks,
			ordproc,
			global,
			idindex,
			help,
			app,
			minilib;



{***********************************************************************
 ***                                                                 ***
 ***                      Invoice                                ***
 ***                                                                 ***
 ***********************************************************************}
procedure TQuickInvoice.CommonInit;
begin
	inherited CommonInit;
	Quick := True;
end;

function TQuickInvoice.srType;
begin srType := srQuickInvoice; end;


{*****************************************
 ***  INITIALISATION/REGISTRATION      ***
 *****************************************}
const
	{--- Required for Stream ----}
	RQuickInvoice : TStreamRec = (
		ObjType : srQuickInvoice;
		VmtLink : Ofs(TypeOf(TQuickInvoice)^);
		Load : @TQuickInvoice.Load;
		Store : @TQuickInvoice.Store
	);

function CreateQInvoice(P : pointer) : pointer; far;
var Q : PQuickInvoice;
begin
	New(Q, init(P));
	Q^.State := Q^.State or osSent; {automatically sent - for kilimanjaro...}
	CreateQInvoice := Q;
end;

{*****************************************
 ***    FIND INVOICE BY ID             ***
 *****************************************}
procedure FindQuickInvoiceByID; far;
var Control : word;
		Ref : longint;
		Invoice : PQuickInvoice;
		ID : longint;

begin
	Ref := 0;
	Control := InputLintBox('FIND QUICK INVOICE', 'Ref #', Ref);

	if Control<>cmCancel then begin
		ID := GetIDPtr(srQuickInvoice, Ref);
		if ID=-1 then
			ProgramWarning('Could not find Quick Invoice Ref '+N2Str(Ref),hcInternalErrorMsg)
		else begin
			Invoice := PQuickInvoice(GetJimmy(ID));
			Invoice^.Edit(Desktop, nil);
		end;
	end;
end;




begin
{$IFDEF fixit} writeln('KQInv...'); {$ENDIF}
	RegisterType(RQuickInvoice);
	RegisterCreator(cmNewQuickInvoice, CreateQInvoice);

	RegisterTask(DesktopTasks, cmFindQuickInvoiceByID, @FindQuickInvoiceByID);

end.
