{***********************************************************************
 ***                     RALLY SETUP OBJECT                          ***
 ***********************************************************************}
{$I compflgs}

unit KRlySetu;

INTERFACE

uses tuiedit, setup;

const
	siCarNumDig 		= 'CARNUM DIGIT';
	siCurrentLeg		= 'CURRENT LEG';

	siStartInterval = 'START INTERVAL';
	siCPGap = 'CP GAP';

	siEarlyPenalty  = 'EARLY PENALTY';
	siEarlyPenaltyPer = 'EARLY PER';
	siLatePenalty   = 'LATE PENALTY';
	siLatePenaltyPer = 'LATE PER';

	siViewInt = 'VIEW UPDATE INT';
	siWebReportInt = 'WEB REPORT INT';

type
	PRallySetup = ^TRallySetup;
	TRallySetup = object(TSetup)

		CurrentLegID		: longint;

		CarNumDig				: byte; {number of digits for car}
		StartInterval 	: word; {seconds}
		CPGap						: word;

		EarlyPenalty 		: word; {seconds penalty...}
		EarlyPenaltyPer : word; {...per whole number seconds early}
		LatePenalty			: word;
		LatePenaltyPer	: word;

		ViewInt					: word; {seconds}
		WebReportInt		: word;
		NewsFlashInt		: word;

		procedure Load; virtual;
		procedure Store; virtual;
		procedure SetButtonDefaults; virtual;
		procedure AddSetupLines(EditBox : PEditBox); virtual;
	end;

var
	RallySetup : TRallySetup;


IMPLEMENTATION

uses tasks,
			global,
			idindex,
			krally,
			tuimsgs, app,
			indexes,
			jimindxs,
			jimmys,
			files,
			inpjimmy,
			krlyview,
			minilib, objects, views, kamsetup;

procedure EditRallySetup; far;
begin RallySetUp.Edit; end;



procedure TRallySetup.Load;
begin
	CurrentLegID			:= S2Num(Get(siCurrentLeg, '-1'));

	CarNumDig					:= S2Num(Get(siCarNumDig, '3'));
	StartInterval 		:= S2Num(Get(siStartInterval,'180'));
	CPGap							:= S2Num(Get(siCPGap,'180'));

	EarlyPenalty			:= S2Num(Get(siEarlyPenalty,'120'));
	EarlyPenaltyPer		:= S2Num(Get(siEarlyPenaltyPer,'60'));
	LatePenalty				:= S2Num(Get(siLatePenalty,'60'));
	LatePenaltyPer		:= S2Num(Get(siLatePenaltyPer,'60'));

	ViewInt						:= S2Num(Get(siViewInt, '60'));
	WebReportInt			:= S2Num(Get(siWebREportInt, '0'));
	NewsFlashInt			:= S2Num(Get(siNewsFlashInt, '0'));
end;

procedure TRallySetup.SetButtonDefaults;
begin
	CurrentLegID := -1;

	CarNumDig	 := 3;

	StartInterval := 180;
	CPGap := 180;

	EarlyPenalty	:= 120;
	EarlyPenaltyPer := 60;
	LatePenalty 	:= 60;
	LatePenaltyPer := 60;

	ViewInt := 60;
	WebReportInt := 0;
	NewsFlashInt := 0;
end;

procedure TRallySetup.Store;
begin
	Put(siCurrentLeg,			N2Str(CurrentLegID));

	Put(siCarNumDig, 			N2Str(CarNumDig));
	Put(siStartInterval, N2Str(StartInterval));
	Put(siCPGap,						N2Str(CPGap));

	Put(siEarlyPenalty, 	N2Str(EarlyPenalty));
	Put(siEarlyPenaltyPer, 	N2Str(EarlyPenaltyPer));
	Put(siLatePenalty, 			N2Str(LatePenalty));
	Put(siLatePenaltyPer, 	N2Str(LatePenaltyPer));

	Put(siViewInt,						N2Str(ViewInt));
	Put(siWebReportInt,				N2Str(WebReportInt));
	Put(siNewsFlashInt, 			N2Str(NewsFlashInt));

	ProgramSetup.Store;
end;

{============ EDIT ======================}
procedure TRallySetup.AddSetupLines;
var R : TRect;
begin
	with EditBox^ do begin
		GrowTo(46, 18);
		InsTitledField(22,  1,20, 1, 'Leg', New(PInputIndexedJimmy, init(R, 20, fiLegIdx, lsLeg, '')));

		InsTitledField(22,  3, 1, 1, 'Digits for Car Nmbrs', New(PinputByte, Init(R, 1)));

		InsTitledField(22,  5, 4, 1, 'Start Interval/secs', New(PinputWord, Init(R, 4)));
		InsTitledField(22,	6, 4, 1, 'Control Spacing',	New(PInputWord, init(R, 4)));

		InsTitledField(22,  8, 4, 1, 'Early Penalty', 			New(PinputWord, init(R, 4)));
		InsTitledField(39,  8, 4, 1, 'per whole', 			New(PinputWord, init(R, 4)));

		InsTitledField(22, 10, 4, 1, 'Late Penalty', 			New(PinputWord, init(R, 4)));
		InsTitledField(39, 10, 4, 1, 'per whole', 			New(PinputWord, init(R, 4)));

		InsTitledField(22, 12, 4, 1, 'Update Interval',	New(PInputWord, init(R, 4)));
		InsTitledField(22, 13, 4, 1, 'Web Rpt Interval',	New(PInputWord, init(R, 4)));
		InsTitledField(22, 14, 4, 1, 'News Flash Interval',	New(PInputWord, init(R, 4)));
	end;
end;

{**************************************************************
 ***                                                        ***
 ***                 CREATE START LIST                      ***
 ***                                                        ***
 **************************************************************}
procedure CreateStartList(Leg : PLeg);
var StartFile : PIDIndexFile;
		Control : PControl;
		Car : PCar;
		fiType : word;
		IndexItem : PIndexItem;
		IdxREc, IDRec : longint;


begin
	ThinkingOn('Creating Start List');

	New(StartFile, init(srCar, 1));
	StartFile^.Clear;

	Control := PControl(GetJimmy(Leg^.CPStart));

	if Control^.RoutePos = 1 then begin
		{first leg - create in order of car number}
		fiType := fiCarNumberIdx;
	end else begin
		{secondary legs - create in order of cumulative time, ie race pos}
		fiType := fiCarRacePosIdx;
	end;

	dispose(Control, done);

	FileAdmin(fiType)^.LogOn;
	IDRec := 1;
	for IdxRec := 0 to Stream(fiType)^.NoRecs-1 do begin
		IndexItem := PIndexItem(Stream(fiType)^.GetAt(IdxRec));
		if not IndexItem^.Hole then begin
			Car := PCar(GetJimmy(INdexItem^.Idx2Dat));

			if (Car^.Status and stRunning)>0 then begin
				{write start pos}
				StartFIle^.SetIDPtr(IDRec, Car^.RecNo);

				{set back pointer}
				Car^.StartPos := IDRec;
				PutJimmy(Car);
				Car^.Storeself; {re-index, etc}
{				Car^.Storeop(1); {store pointer}

				inc(IDrec);
			end;
			dispose(Car, done);
		end;
		dispose(IndexItem, done);
	end;
	FileAdmin(fiType)^.LogOff;

	dispose(StartFile, done);

	ThinkingOff;
end;


procedure MakeStartList; far;
var EditBox : PEditBox;
		R : Trect;
		Control : word;
		LegID : longint;
		Leg : PLeg;

begin
	R.Assign(0,0,35,8); R.Move(20,5);
	New(EditBox, init(R, 'MAKE START LIST',nil));

	with EditBox^ do begin
		InstitledField(15, 2,15, 1, 'For Leg',   New(PInputIndexedJimmy,
						Init(R, 20, fiLegIdx, lsLeg, '')));
		PInputELine(CUrrent)^.MustInput := True;
		Current^.SetData(RallySetup.CurrentLegID);

		InsOKButton(5, 5, @LegID);
		InsCancelButton(16, 5);

		EndInit;
	end;

	Control := Desktop^.ExecView(EditBox);

	dispose(EditBox, done);

	if Control=cmOK then begin
		Leg := PLeg(GetJimmy(LegID));
		CreateStartList(Leg);
		dispose(Leg, done);

		StartStartList;
	end;
end;

{**************************************************************
 ***                                                        ***
 ***                 RE-CREATE ROUTE                        ***
 ***                                                        ***
 **************************************************************}
procedure ReCreateRoute; far;
var RouteFile : PIDIndexFile;
		Control : PControl;
		fiType : word;
		IndexItem : PIndexItem;
		IdxREc, IDRec : longint;


begin
	ThinkingOn('Recreating Route');

	New(RouteFile, init(srControl, 1));
	RouteFile^.Clear;

	fiType := fiControlIdx;

	FileAdmin(fiType)^.LogOn;
	IDRec := 1;
	for IdxRec := 0 to Stream(fiType)^.NoRecs-1 do begin
		IndexItem := PIndexItem(Stream(fiType)^.GetAt(IdxRec));
		if not IndexItem^.Hole then begin
			Control := PControl(GetJimmy(INdexItem^.Idx2Dat));

			{write start pos}
			RouteFIle^.SetIDPtr(IDRec, Control^.RecNo);

			{set back pointer}
			Control^.RoutePos := IDRec;
			PutJimmy(Control);

			inc(IDrec);

			dispose(Control, done);
		end;
		dispose(IndexItem, done);
	end;
	FileAdmin(fiType)^.LogOff;

	dispose(RouteFile, done);

	ThinkingOff;
end;




begin
	RallySetup.Init('Rally');
	RegisterTask(DesktopTasks, cmEditRallySetup, @EditRallySetup);

	RegisterTask(DesktopTasks, cmMakeStartList, @MakeStartList);
	RegisterTask(DesktopTasks, cmMakeRoute, @RecreateRoute);
end.
