{***********************************************************************
 ***                                                                 ***
 ***                        REPORTS                                  ***
 ***                                                                 ***
 ***********************************************************************{}
unit KRongRpt;

INTERFACE

IMPLEMENTATION

uses kdiary,
			krongord,
			printers,
			forms, devices,
			tuimsgs,
			dattime,
			kdirctry,
			jimindxs,
			global,
			tasks, menus,
			jimmys,
			files,
			objects,
			views,
			app,
			tui,
			tuiedit,
			minilib;


{**********************************
 ***         DRIVERS IN/OUT     ***
 **********************************}
procedure DiaryDrivers(List : PDiaryView; Out : boolean);
var	IdxRec : longint;
		Delivery : PRongaiDelivery;
		S : string;
const
	InS		= '[REG   ][<GOODS> from <FROM.NAME>   ] [DRIVER.NSF        ] [DRIVER.NATID]<REF>'#13#10
				+ '                                      [TURNBOY.NSF       ] [TURNBOY.NATID]'#13#10#13#10;
	OutS	= '[REG   ][<GOODS> to <TO.NAME>       ] [DRIVER.NSF        ] [DRIVER.NATID]<REF>'#13#10
				+ '                                      [TURNBOY.NSF       ] [TURNBOY.NATID]'#13#10#13#10;

begin
	ThinkingOn('Printing Drivers');

	if not List^.ListEmpty then begin

		if Out then S := 'OUT' else S := 'IN';

		Printer^.FOrmCodes^.SetStr('RTITLE', 'DRIVERS '+S+' '+List^.PageDate.Text(daAbbr));
		Printer^.FormCodes^.SetStr('LISTHDR','Reg     Goods & Dest                  Driver & Turnboy     ID            Dlvy');

		Printer^.StartPrint('GATE','REPORT');

		{run through day (ie firstitem to lastitem) printing delivery items}
		for IdxRec := List^.FIrstItem to List^.LastItem do begin
			DElivery := PRongaiDelivery(PIndexedJimmyStream(Stream(List^.fiType))^.GetJimmyAtIdx(IdxRec));
			if Delivery<>nil then begin
				if Delivery^.srtype = srRongaiDelivery then begin

					Delivery^.SetFOrmCodes(Printer^.FOrmCodes);
					Printer^.FormCodes^.SetStr('REG','<TRACTOR.REG>');

					if Out then
						case Delivery^.gotbyix of
							{want to print if takenfrom rongai, or passing out today}
							1 : if (Delivery^.TakeFrom = 0) then Printer^.writeCodedStr(OutS);{}
							3 : Printer^.WRiteCodedStr(OutS);
						end
					else
						{drivers in}
						case Delivery^.gotbyix of
							{want to print if takenfrom rongai, or passing out today,
							but only once if both}
{							1 : if (Delivery^.TakeTo = 0) and (Delivery^.RongaiIn.Days<>Delivery^.Date.Days) then
										Printer^.writeCodedStr(InS);{}
							2 : Printer^.WRiteCodedStr(InS);
						end;

					Printer^.FormCodes^.Clear;
				end;
				dispose(Delivery, done);
			end;
		end;

		Printer^.EndPrint;
	end;

	ThinkingOff;
end;

procedure DiaryDriversIn(P : pointer); far;
begin	DiaryDrivers(PDiaryView(P), False); end;

procedure DiaryDriversOut(P : pointer); far;
begin	DiaryDrivers(PDiaryView(P), True); end;

{**********************************
 ***         LOADING LIST       ***
 **********************************}
procedure DiaryLoadingsRpt(P : pointer); far;
var List : PDIaryView;
		EditBox : PEditBox;
		Selector : record
			Shipper : longint;
			ForCoy : longint;
		end;
		Control : word;
		IdxRec : longint;
		Delivery : PRongaiDelivery;
		R : TRect;

const
	LineCode		= '[REG   ][GOODS    ]  [CONT.NUM       ] <DRIVER.NS>, <DRIVER.NF> (ID <DRIVER.NATID>)'#13#10;

begin
	List := PDiaryView(P);

	{do a selector dialog box - select shipping line and for company}
	R.Assign(0,0,32,9);
	CentreOnView(R, List);
	New(EditBox, init(R, 'Loadings Report', P));

	with EditBox^ do begin
		InsTitledField(10,2,19,1, 'Agent', New(PInputDirectory, init(R, 30, fiFullDirIdx, lsDirectory, '')));
		InsTitledField(10,4,19,1, 'For Coy', New(PInputDirectory, init(R, 30, fiFullDirIdx, lsDirectory, '')));
		InsOKButton(7,6, @Selector);
		InsCancelButton(17,6);
		EndInit;
	end;

	Control := Desktop^.ExecView(EditBox);

	dispose(Editbox, done);

	if Control = cmCancel then exit;

	{--- do report ---}
	ThinkingOn('Printing Loadings');

	if not List^.ListEmpty then begin

		Printer^.FOrmCodes^.SetStr('RTITLE', 'LOADINGS FOR '+List^.PageDate.Text(daAbbr));
		Printer^.FOrmCodes^.SetStr('RPTDESC', GetJimmyIDName(Selector.Shipper,naReport,0)
																						+'  '+GetJimmyIDName(Selector.FOrCoy, naReport, 0));

		Printer^.StartPrint('LOADINGS','REPORT');

		{run through day (ie firstitem to lastitem) printing delivery items}
		for IdxRec := List^.FIrstItem to List^.LastItem do begin
			DElivery := PRongaiDelivery(PIndexedJimmyStream(Stream(List^.fiType))^.GetJimmyAtIdx(IdxRec));
			if Delivery<>nil then begin
				if Delivery^.srtype = srRongaiDelivery then begin

					if ((Delivery^.ForWho=Selector.ForCoy) or (Selector.ForCOy = -1)) and
							((Delivery^.AgentID=Selector.Shipper) or (Selector.Shipper = -1)) then begin

						Delivery^.SetFOrmCodes(Printer^.FOrmCodes);
						Printer^.FormCodes^.SetStr('REG','<TRACTOR.REG>');

						Printer^.WriteCodedStr(LineCOde);

						Printer^.FormCodes^.Clear;

					end;
				end;
				dispose(Delivery, done);
			end;
		end;

		Printer^.EndPrint;
	end;

	ThinkingOff;
end;




begin
	{extra reports}
	RegisterWithList(lsDiary, '~P~rint', NewItem('Drivers In', '', kbNone, cmDriversIn, hcNoContext, nil), 		DiaryDriversIn);
	RegisterWithList(lsDiary, '~P~rint', NewItem('Drivers Out', '', kbNone, cmDriversOut, hcNoContext, nil), 	DiaryDriversOut);
	RegisterWithList(lsDiary, '~P~rint', NewItem('Loadings', '', kbNone, cmLoadingsRpt, hcNoContext, nil), 		DiaryLoadingsRpt);
end.
