{**************************************************
 ***             SBS UTILITIES                  ***
 **************************************************}
{$I compdirs}

unit KSBS;

INTERFACE

procedure ReleaseCode;

IMPLEMENTATION

uses tasks, global,
			{$IFDEF Windows}
			win, winapp, winedit,
			{$ELSE}
			tui,	tuiapp,	tuiedit,
			menus, views, dialogs, app, tuimsgs,
			{$ENDIF}
			objects,  minilib;



{**********************************************
 ***              RELEASE CODE              ***
 **********************************************}
procedure ReleaseCode;
var EditBox : PEditBox;
		R : TRect;
		Control : word;
		Code : record
						 First : word;
						 Second : word;
					end;

begin
	{===== LETTER DETAILS ===========}
	R.Assign(0, 0, 30,7);
	New(EditBox, Init(R, 'RELEASE CODE',nil));

	Code.First := 0;
	Code.Second := 0;

	with EditBox^ do begin
		Options := Options or ofCenterX or ofCenterY;  {Centralise}

		{--- Set up box interior ---}
		InsTitledField(10,  2, 3, 1, 'Code', New(PinputWord, Init(R, 3)));
		InsTitledField(20,  2, 3, 1, '/',    New(PinputWord, Init(R, 3)));

		{-- Buttons --}
		InsOKButton(4,  4, @Code);
		InsCancelButton(16, 4);

		EndInit;
	end;

	{--- Run Filename requester Box ----}
	Control := Desktop^.ExecView(EditBox);

	dispose(EditBox, done);

	{--- Display password ----------}
	if Control <> cmCancel then begin
		R.Assign(0,0, 40,18);
		New(EditBox, init(R, 'PASSWORD',nil));

		with EditBox^ do begin
			Options := Options or ofCenterX or ofCenterY;  {Centralise}

			{--- Set up box interior ---}
			InsText(EditBox, 4, 2, 'v1  - extend: '+hex(Code.First+Code.Second));
			InsText(EditBox, 4, 3, '     release: '+hex(Code.First+1)+'/'+hex(Code.Second+2));

			InsText(EditBox, 4, 5, 'v4 - enter nn/mm where:');
			InsText(EditBox, 4, 6, '         nn = '+hex(Code.First)+' (extend)');
			InsText(EditBox, 4, 7, '              '+hex(Code.First+1)+' (extend)');
			InsText(EditBox, 4, 8, '         mm = as below, except');
			InsText(EditBox, 4, 9, '              '+hex(Code.Second)+' (single user)');

			InsText(EditBox, 4,11, 'v4.1+ - enter nn/mm where:');
			InsText(EditBox, 4,12, '         nn = '+hex(Code.First+1)+' (extend)');
			InsText(EditBox, 4,13, '              '+hex(Code.First+2)+' (release)');
			InsText(EditBox, 4,14, '         mm = '+hex(Code.Second+1)+' (single user)');
			InsText(EditBox, 4,15, '              '+hex(Code.Second+5)+' (5 user)');
			InsText(EditBox, 4,16, '              '+hex(Code.Second+10)+' (10 user)');

			{-- Buttons --}
			InsOKButton(Size.X-11,  Size.Y-3, nil);

			EndInit;
		end;

		Desktop^.ExecView(EditBox);

		dispose(EditBox, done);

		ReleaseCode; {go around again, until cancel pressed}
	end;

end;


begin
	RegisterTask(DesktopTasks, cmPasswordRelease, @ReleaseCode);
end.