{************************************************************************
 ***                                                                  ***
 *** New Fabbo Singing Dancing OOP                                    ***
 ***                            SALES ORDERS                          ***
 ***                                                            Nov 94***
 *** M Hill                                                 rev Apr 96***
 ***********************************************************************}
{For placing SalesOrders with suppliers.{}

{$I compdirs}  {Compiler directives}
unit kSOrder;

INTERFACE

uses 	linklist,
			notes, dattime,
			multcurr,
			jimmys,
			objects,
			global,
			views,
			tuiedit,
			forms, devices,
			files,
			ordproc;

{*****************************
 ***  SalesOrder              ***
 *****************************}
{const
	TSalesOrderSize = 100;
{	SalesOrderIDLength = 15;{}

type
	PSalesOrder = ^TSalesOrder;
	TSalesOrder = object(TOrder)

{now in TOrder		CustRef		: string[10];

		Comment   : PFreeTextData;            {Text on SalesOrder}

		{Automatic fields - also appearing on edit box - some stored}
{		Total     	: TMoney;                {Total excl VAT}
{		VAT       	: TMoney;                {VAT on amount}

{		StockUpdated : boolean;{}

		constructor Init(Param : PJimmyInitParam);
		procedure CommonInit; virtual; {init procedures common to Init and Load (eg scode logging)}
		destructor Done; virtual;

		{--- Editing ----}
		procedure MakeEditBox(var EditBox : PEditBox; Caller : PView); virtual;

		{--- Viewing -----}
		function DisplayLine(ListForWho : longint; lstype : byte; Maxlen : integer; View : word) : string; virtual;
		function GetName(naType : byte; Maxlen : integer) : string; virtual; {used for various displays/prints -
																																					eg selection lines, window headers, etc}
		{--- Printing ----}
{		procedure SetFormCodes(const FormCodes: PFormCodeCollection); virtual;
		procedure Print(prType : word; Device : PDeviceStream); virtual;

		{--- Database ----}
		function RecSize : word; virtual; {space to be reserved in jimmy file}
		function srType : word; virtual; {descendants set as fixed, so can be
																			used to identify jimmy for file operations, etc}
		function PtrOffset : byte; virtual; {extra ver no}

		procedure Storefields(var S : TDataStream); virtual;
		constructor Load(var S : TDataStream);
	end;


IMPLEMENTATION

uses tui, tuimsgs,
			idindex,
			inpdnt,
			help,
			kdirctry,
			tasks,
			tuijimmy,
			jimhooks,
			minilib;

{***********************************************************************
 ***                                                                 ***
 ***                      SalesOrder                                ***
 ***                                                                 ***
 ***********************************************************************}
constructor TSalesOrder.Init(Param : PJimmyInitParam);
begin
	inherited init(param);
end;

procedure TSalesORder.COmmonInit;
begin
	inherited CommonInit;
end;

destructor TSalesORder.Done;
begin
	inherited Done;
end;

{==== CREATE DISPLAY-LINE-FORMAT STRING ============}
function TSalesOrder.DisplayLine;
var S : string;
begin
	S := Date.Digit8+' SALES ORDER #'+N2Str(Ref);
	if ForWhoRef<>nil then S :=S+' ('+ForWhoRef^+') ';
	S := S+TotallerGroup.Total.Text(mtRound);

	DisplayLine := S;
end;

function TSalesORder.GetName;
begin
	GetName := 'SALES #'+N2Str(Ref)+' '+GetJimmyIDName(ForWho,naRef,0)+' '+Date.Text(daDigit8);
end;


{**************************************************
 ***             EDIT BOX                       ***
 **************************************************}
procedure TSalesOrder.MakeEditBox;
var	R: TRect;
		ForLine, RefLine, ByLine, ItemView : PView;

begin
	R.Assign(0, 0, 55, 17);
	CentreOnView(R, Caller);
	EditBox := New(PJimmyEditBox, Init(R, 'Sales Order',Caller, @Self));

	with EditBox^ do begin
		Insert(New(PSkipBytes, init(sizeof(TJimmy))));
		Insert(New(PSkipBytes, init(4+1+sizeof(TDate))));

		Insert(New(PInputTotallerGroup, init(Size.X-22,Size.Y-4, EditBox)));

		InsTitledField(7,  1, 5, 1, 'Ref', New(PInputRefNum, init(R,5, srSalesORder)));
		Insert(New(PSkipBytes, init(4))); {oldref}
		InsTitledField(20, 1,10, 1, '~D~ate', New(PinputDate, Init(R)));

		ForLine := InsTitledField(7,  3,23,1, '~F~rom',  New(PInputDirectory, init(R, 30,  fiFullDirIdx, lsDirectory,'')));
		PInputELine(ForLine)^.MustInput := True;

		R.XYLD(37,3, 8,1); Insert(New(PInputPStr, init(R, 10)));	AddLabel('Cust Ref', Current);
		RefLine := Current;
		ByLine  := InsTitledField( 7, 5,23,1, '~B~y',  New(PInputDirectory, init(R, 30,  fiFullDirIdx, lsDirectory,'')));

		ItemView := InsTitledField(7, 7,45,6, '~G~oods',
																New(PDlgHookView,	Init(R, lsSalesItems, 0, hkOrderItems, @Self, PJimmyEditBox(EditBox))));
		Insert(PHookViewer(ItemView)^.VScrollBar);

		{-- Buttons --}
		Insert(New(PJimmyOKButton, Init(8,Size.Y-3, @Self)));
		Insert(New(PjimmyCancelButton, init(18,Size.Y-3, @Self)));

		EndInit;
	end;

	if ForWho=-1 then
		ForLine^.FOcus
	else
		RefLine^.Focus;
end;

{*****************************************
 ***     STREAMING DEFINITIONS         ***
 *****************************************}
function TSalesOrder.RecSize;
begin RecSize := 100; end;

function TSalesOrder.srType;
begin srType := srSalesOrder; end;

function TSalesOrder.PtrOffset;
begin PtrOffset := inherited PtrOffset + 1; end; {extra ver in load}

constructor TSalesOrder.Load(var S : TDataStream);
var	Ver : byte;

begin
	S.Read(Ver, 1);

	case Ver of
		1 : begin
			inherited Load(S); {common init, lock, delete marker}
			ForWhoRef := NewStr(S.ReadStr);
			S.Read(ByWho, 4);
			Notes^.Load(S);
		end;
		2 : begin
			{4.3a - all fields moved to TOrder}
			inherited Load(S); {common init, lock, delete marker}
			OldRef := -1; {temp fix for NSS}
		end;
	else
		DBaseMessage(@S, 'Version '+N2Str(Ver)+' not understood'#13#10'SalesOrder.Load',mfError,hcInternalErrorMsg);
		fail;
	end;
end;

procedure TSalesOrder.StoreFields(var S : TDataStream);
var	Ver : byte;

begin
	Ver := 2; S.Write(Ver, 1);

	inherited StoreFields(S);

{	S.WriteStr(@CustRef);
	COmment^.store(S);{}
end;

{*****************************************
 ***  INITIALISATION/REGISTRATION      ***
 *****************************************}
const
	{--- Required for Stream ----}
	RSalesOrder : TStreamRec = (
		ObjType : srSalesOrder;
		VmtLink : Ofs(TypeOf(TSalesOrder)^);
		Load : @TSalesOrder.Load;
		Store : @TSalesOrder.Store
	);


function CreateSalesOrder(P : pointer) : pointer; far;
begin	CreateSalesOrder := New(PSalesOrder, init(P)); end;


begin
{$IFDEF fixit} writeln('KSOrder...'); {$ENDIF}
	RegisterType(RSalesOrder);

	RegisterCreator(cmNewSalesOrder, CreateSalesOrder);

	{Register with directory history}
	RegisterNewWithList(lsHistory, '~S~ales Order', cmNewSalesOrder);

	{Register with desktop}
	RegisterNewWithList(lsDesktop, '~S~ales Order', cmNewSalesOrder);{}
{	RegisterTask(DesktopTasks, cmNewSalesOrder, @CreateEditJimmy); see jimmys}

end.
