{****************************************************************************
 ***                                                                      ***
 *** New Fabbo Singing Dancing OOP                                        ***
 ***                          W P  DOCUMENTS                              ***
 ***                                                                      ***
 *** M Hill                                                        Mar 95 ***
 ****************************************************************************}
{Provides access to WordPerfect documents, using a kind of filing system to
access them}
{$I compdirs}  {Compiler directives}

unit KWPDocs;

INTERFACE

uses objects, edit, kdocs, output, views;

const
	TWPDocSize =  TDocumentSize + 80;

type
	PWPDoc = ^TWPDoc;
	TWPDoc = object(TDocument)

    Drive : string[1];
    Path : string[60];
    Name : string[11];

		{-- Methods --}
		constructor Init;

		function DisplayLine(Maxlen : integer; View : word) : string; virtual;

		{Database stuff}
		constructor Load(var S : TStream);
		procedure   Store(var S : TSTream);

		{Processing stuff}
		procedure MakeEditBox(var EditBox : PEditBox; Caller : PView); virtual;

		function Print(prType : word; Output : POutputStream) : word; virtual;
end;

{***************************************************************************
 ***                 IMPLEMENTATION                                      ***
 ***************************************************************************}
IMPLEMENTATION

uses	idxjimmy, jimmys,
      displays, menus, tasks,
      kwplink,
			errors,
      files,
      doslink,
      scodes,
			minilib,
			global;



{****************************************************************************
 ***                                                                      ***
 ***                THE WPDoc OBJECT                                     ***
 ***                                                                      ***
 ****************************************************************************}

function CreateWPDoc(P : pointer) : pointer; far;
begin	CreateWPDoc := New(PWPDoc, init); end;

constructor TWPDoc.Init;
begin
	inherited Init;
	Drive := '';
  Path := WPSetup.Path;
  Name := '';
end;


function TWPDoc.DisplayLine;
begin
	DisplayLine := Desc;
end;


{****************************************************
 *** STREAMING                                    ***
 ****************************************************}
{THE LOAD AND STORE *MUST* MATCH, AS THE INDEX IS CALCULATED ASSUMING
RECORDS ALL OF THE SAME LENGTH. SEE ABOVE "TDatSIZE" CONSTANT TO SET
THE SIZE}
 const
	 {--- Required for Stream ----}
	 RWPDoc : TStreamRec = (
		 ObjType : srWPDoc;
		 VmtLink : Ofs(TypeOf(TWPDoc)^);
		 Load : @TWPDoc.Load;
		 Store : @TWPDoc.Store
	 );

{------- LOAD MAIN DATA ----------}
constructor TWPDoc.Load;
var Ver : byte;
begin
	inherited Load(S);

	S.Read(Ver,1);

	S.Read(Drive, sizeof(Drive));
	S.Read(Path, sizeof(Path));
  S.Read(Name, sizeof(name));

end;

{-------- STORE MAIN DATA ----------}
procedure TWPDoc.Store;
var	StartPos : longint;
		Ver : byte;

begin
	StartPos := S.GetPos;

  inherited Store(S);

	Ver := 1; S.Write(Ver, 1);

  S.Write(Drive, sizeof(Drive));
  S.Write(path, sizeof(path));
  S.Write(Name, sizeof(name));

	TopUpRecord(S, TWPDocSize, STartpos);
end;



{***************************************************************************
 ***                EDIT PRICE LIST                                      ***
 ***************************************************************************}
procedure TWPDoc.MakeEditBox;
var R : TRect;

begin
	R.Assign(0, 0, 55, 20); {Size of box}
	New(EditBox, Init(R, 'WP Document Registration',Caller));

	with EditBox^ do begin
		inherited MakeEditBox(EditBox,Caller);

    insert(New(PSkipBytes, init(sizeof(TDocument)-sizeof(TJimmy)-sizeof(DocType)-sizeof(Desc))));

		InsTitledField(14, 2,30, 1, 'Type', New(PInputSCLine, init(R,11, scDocument)));
		InsTitledField(14, 3,20, 1, 'Desc', New(PInputELine, init(R,20)));

		InsTitledField(14, 4, 1, 1, 'Drive', New(PInputELine, init(R,1)));
		InsTitledField(14, 5,20, 1, 'Path', New(PInputELine, init(R,60)));
		InsTitledField(14, 6,11, 1, 'Name', New(PInputELine, init(R,11)));

		{-- Buttons --}
		Insert(New(PJimmyPrintButton, init(15,17, @Self)));
		Insert(New(PJimmyOKButton, Init(26,17, @Self)));
		InsCancelButton(37,17);

		EndInit;

	end;
end;


{*****************************************************************
 ***                      PRINT                                ***
 *****************************************************************}
function TWPDoc.Print;
var S : string;
begin
  if prType <> (prFullPage+prOutput+prNow) then begin
		Print := inherited Print(prType, Output);
		exit;
	end;

  if Drive<>'' then S := Drive +':' else S := '';
  S := S + ChkEndSlash(Path)+Name;

  PrintWPFile(S);
end;



{******************************************
 ***         UNIT INSTALLATION          ***
 ******************************************}
{unit initialisation procedure}
begin
	AddItemEnd(DocumentsNewMenu, NewItem('~W~ordPerfect Document', '', kbNone, cmNewWPDoc, hcNoContext, nil));
	RegisterCreator(cmNewWPDoc, CreateWPDoc);
	RegisterType(RWPDoc);
end.


