{**************************************************************************
 ***                                                                    ***
 ***                         MESSAGE TEXT COLLECTIONS                   ***
 ***                                                                    ***
 **************************************************************************}
{An object for storing text from files, to make Kameleon configurable}
{Used so we can wire in messages onto disk rather than firmwire into the
software itself}
{$I compflgs}

unit MessText;

INTERFACE

const
	msDosError = 1;
	msIOError = 2;
	msHints	= 3;
	msListTitles = 4;

function GetMessage(const msType, msIndex : word) : string;

function IOError(IOErr : integer) : string;  {Returns message corresponding to error number}


IMPLEMENTATION

uses
{$IFDEF WIndows}
{$ELSE}
	views,
{$ENDIF}
	global, minilib, help;

{------- IO ERRORS  ---------------}
function IOError;
begin
	case IOErr of
		0 			: IOError := '';
		1..99 	: IOError := N2Str(IOErr)+': '+GetMessage(msDosError, IOErr);
		100..199: IOError := N2Str(IOErr)+': '+GetMEssage(msIOError, IOErr);
	else
		IOError := N2Str(IOErr)+'??Unknown Error';
	end;
end;


function GetMessage;
begin
	GetMessage := '?? No Message';

	case msType of
		msDosError :
			case msIndex of {see p400 of dos ref guide - many more}
				0 : GetMessage := 'No Error';
				1 : GetMessage := 'Invalid Function';
				2 : GetMessage := 'File Not Found';
				3 : GetMessage := 'Path Not Found';
				4 : GetMessage := 'No Handles Available';
				5 : GetMessage := 'Access Denied';
				6 : GetMessage := 'Invalid Handle';
				7 : GetMessage := 'Memory Control Blocks Destroyed';
				8 : GetMessage := 'Not Enough Memory';
				9 : GetMessage := 'Invalid Memory Block Access';
				10 : GetMessage := 'Invalid Environment';
				11 : GetMessage := 'Invalid Format';
				15 : GetMessage := 'Invalid Drive';
				18 : GetMessage := 'No More Files';
				19 : GetMessage := 'Disk write protected';
				20 : GetMessage := 'Unknown unit';
				21 : GetMessage := 'Drive not Ready';
				22 : GetMessage := 'Unknown command';
				23 : GetMessage := 'CRC error';
				24 : GetMessage := 'Bad Request structure length';
				25 : GetMessage := 'Seek Error';
				26 : GetMessage := 'Unknown media type';
				27 : GetMessage := 'Sector not found';
				28 : GetMessage := 'Out of paper';
				29 : GetMessage := 'Write fault';
				30 : GetMessage := 'Read fault';
				31 : GetMessage := 'General Failure';
				32 : GetMessage := 'Sharing violation';
				33 : GetMessage := 'Lock violation';{}
				34 : GetMessage := 'Invalid disk change';
			else
      	GetMessage := '?? see p400 Dos Ref';
      end;

    msIOError :
    	case msIndex of
				100 : GetMessage := 'Disk Read Error';
				101 : GetMessage := 'Disk Write Error';
				102 : GetMessage := 'File not Assigned';
				103 : GetMessage := 'File not Open';
				104 : GetMessage := 'File not open for input';
				105 : GetMessage := 'File not open for output';
				106 : GetMessage := 'Invalid numeric format';
				150 : GetMessage := 'Disk is write protected';
				151 : GetMessage := 'Unknown unit';
				152 : GetMessage := 'Drive not ready';
				153 : GetMessage := 'Unknown Command';
				154 : GetMessage := 'CRC error in data';
				155 : GetMessage := 'Bad drive request structure length';
				156 : GetMessage := 'Disk seek error';
				157 : GetMessage := 'Unknown media type';
				158 : GetMessage := 'Sector not found';
				159 : GetMessage := 'Printer out of paper';
				160 : GetMessage := 'Device write fault';
				161 : GetMessage := 'Device read fault';
				162 : GetMessage := 'Hardware fault';
				163 : GetMEssage := 'Share problem?'; {returned by OS/2 when accessing HINTS.RES across network with stOpenRead}

				{defined by mch}
				ioBadResponse : GetMessage := 'Bad Response';
				ioTimeOut 		: GetMessage := 'Time Out';
			else
				GetMessage := '?? Unknown I/O Error';
			end;

{		msHints :
			case msIndex of
				hcNoContext : GetMessage := '';
				hcHelpOnHelp : GetMessage := 'ESC=Exit, Tab/ShiftTab=select topic, Enter=View';

				hcDesktop  : GetMessage := 'Press Alt and highlighted letter for menu';
				hcListView  : GetMessage := 'Ins=New, Enter=Accept, Menus';
				hcDialogBox  : GetMessage := 'ESC=Cancel F10=Continue Tab=Next';{}
{				hcIndexedListView  : GetMessage := 'ESC=Exit, Ins=New, Enter=Accept, Menus';
				hcDirectoryList  : GetMessage := 'ESC=Exit Ins=New Enter=Accept  Menus';
				hcLabelPosDlg  : GetMessage := 'Enter which label to start printing on.  Keep allows print later.';{}

				{Lines}
{				hcInputList  : GetMessage := 'Press '+ksList+' or '+ksZoom+' to select from list';
				hcInputDirectory : GetMessage := 'Type surname,forname or '+ksList+'/'+ksZoom+'=List';
				hcInputSCode  : GetMessage := 'Type code, or '+ksList+'/'+ksZoom+'=List Codes';
				hcInputTelNum  : GetMessage := 'Press '+ksDial+' to dial';
				hcInputLength  : GetMessage := '';{}

				{Menus}
{				hcMenuBar  : GetMessage := 'Left/Right & Enter=select, or press Alt and letter';
				hcMenuBox  : GetMessage := 'Up/Down & Enter=select, or press highlighted letter';

				{Menu hints}
{				hcEndOfYearHint  : GetMessage := 'Clears all Transactions and sets balances to zero';
				hcEndOfPeriodHint  : GetMessage := 'Clears all Transactions, updates balances of accounts';{}

{				hcForms : GetMessage := 'Editor Box with form codes';
			else
				GetMessage := '?? No Hint '+N2Str(msIndex);
			end;{}

		msListTitles :
			{pass msindex as lstype}
			case msIndex of
				lsNone 		: GetMessage := '';
				lsDesktop : GetMessage := 'Desktop';
				lsArchive : GetMessage := 'Archive';

				lsDirectory : GetMessage := 'Directory';
{				lsStaff 			: GetMessage := 'Staff List';{}
				lsUSers 		: GetMessage := 'User List';

				lsHistory 	: GetMessage := 'History of';
				lsMoreAbout : GetMessage := 'More About';
				lsAddresses : GetMessage := 'Addresses of';
				lsAccounts  : GetMessage := 'Account Details of';
				lsContacts  : GetMessage := 'Contacts of';

				lsGoodsServices	 	: GetMessage := 'Goods & Services';

				lsLiveStock 				: GetMessage := 'Livestock';
				lsLiveStockHistory 	: GetMessage := 'History of';
				lsLiveStockMore 		: GetMessage := 'More About';
				lsHerd 							: GetMessage := 'Herd';
				lsHerdHistory 			: GetMessage := 'History of';
				lsHerdBulls 				: GetMessage := 'Bulls of';

				lsDiary 					: GetMessage :=	'Diary';
				lsDiaryRepeaters 	: GetMessage := 'Diary Repeaters';

				{rally}
				lsLeg 				: GetMessage := 'Course legs';
				lsRoute		 		: GetMessage := 'Controls';
				lsCar 				: GetMessage := 'Cars';
				lsCarTiming 	: GetMessage := 'Car Timings';
				lsControlTiming : GetMessage := 'Control Timings';

				{order processing}
				lsSalesItems 		: GetMessage := 'Sales Order Items';
				lsInvoiceItems 	: GetMessage := 'Invoice Items';
				lsPayments 			: GetMessage := 'Payments';

				{rongai}
				lsVehicles 			: GetMessage := 'Vehicles';
				lsShips 				: GetMessage := 'Ships';
				lsContainers 		: GetMessage := 'Containers';

				{options}
				lsStudents 			: GetMessage := 'Students';
			else
				GetMessage := '??No list title?? MessText';
			end;
	end; {type case}


end;


end.

