{*******************************************************************
 ***                 MULTI USER BITS                             ***
 *******************************************************************}
{Separated the lockmessage, etc from tuimsgs as it causes jimmys, etc
to be linked into tuixxx modules, a bit of a pain for testing purposes!}
{$I compdirs} {single user flag}

{$IFDEF SIngleUser} {Should it have reached here? {} {$ENDIF}

unit muser;

interface

function LockMessage(Message : string; const Terminal : byte; const mfOptions : word) : word;

function OtherTerminalsRunning : boolean;
function CloseOtherTerminalsMessage : word;

function CheckFileLock(fiType : word; Message : string) : byte;
procedure SetFileLock(fiType : word; On : boolean);

function OtherUsersList : string;

implementation

uses
		{$IFDEF kusers} jimmys, {$ENDIF}
		status,
		help,
		dosutils, {for setting filemode}
		global,
		minilib,
		tuimsgs;

function OtherTerminalsRunning : boolean;
begin
	OtherTerminalsRunning := ProgramStatus.NumTerminalsRunning>1;
end;

function OtherUsersList;
var S : string;
		ID : longint;
		I : integer;
begin
	S := '';
	for I := 1 to 30 do {if I<>TerminalNo then{} begin

		ID := ProgramStatus.GetWhoAtTerminal(I);
		if ID<>-1 then begin
			if I=TerminalNo then S := S + #16;

			S := S + 'Terminal '+N2Str(I);

			{$IFDEF kusers}
			if ID>=0 then {could be -2 if partly not a kusers systen}
				S := S +' - '+GetJimmyIDName(ID, naDisplay, 0);
			{$ENDIF}

			if I=TerminalNo then S := S + #17;
			S := S + #13;
		end;
	end;

	while (S[length(S)]=#13)  do dec(byte(S[0]));

	OtherUsersList := S;
end;

function CloseOtherTerminalsMessage;
var S : string;
begin
	S := OtherUsersList;
	if S<>'' then S := #13+S;

	CloseOtherTerminalsMessage := LockMessage(
						'There must be no other users running Kameleon'#13#10+
						'Please exit Kameleon on all other terminals:'#13#10+
						S,
						0, mfWarning + mfCancelOverRetry);
end;

function LockMessage(Message : string; const Terminal : byte; const mfOptions : word) : word;
var Command : word;
		S : string;
begin
	IdleOff := True;
	if Terminal<>0 then begin
		{$IFDEF KUsers} S := ' - '+GetJimmyIDName(ProgramStatus.GetWhoAtTerminal(Terminal), naRef,0);
		{$ELSE}					S := ''; {$ENDIF}
		Message := Message + 'In Use'#13' (Terminal '+N2Str(Terminal)+S+')';
	end;

	{$IFDEF Windows}
	{$ELSE}
		Command := MessageBox('LOCK', Message, mfWarning or mfWarningBleep or mfOptions,hcLockMsg);
	{$ENDIF}

	RecordError('Lock Message:',' '+Message,' Response:'+N2Str(Command));
	LockMessage := Command;
	IdleOff := False;
end;

{****************************************************
 ***               FILE LOCKING                   ***
 ****************************************************}
{shortcuts at the moment -get rid of them at some point}
{---------- SET LOCK ------------}
procedure SetFileLock;
begin
	if On then ProgramStatus.SetfiLock(fiType, TerminalNo) else ProgramStatus.SetfiLock(fiType,0);
end;

{--------------- GET LOCK -------------}
function GetFileLock(fiType : word) : byte;
begin	GetFileLock := ProgramStatus.GetfiLock(fiType); end;

{--------------- CHECK LOCK  -------------}
{Dialog box override/retry/etc}
function CheckFileLock;
var	Control : word;
		Lock : word;
		Terminal : byte;

begin
	Terminal := GetFileLock(fiType);
	CheckFileLock := Terminal;

	if Terminal>0 then begin
		Control := LockMessage(Message,Terminal,mfCancelOverRetry);
		if Control = cmRetry then begin
			CheckFileLock := CheckFileLock(fiType, Message);
			exit;
		end;
		if Control = cmCancel then exit;
		{override - set to 0}
		CheckFileLock := 0;
		SetFileLock(fiType,False);
	end;
end;

end.
