{**************************************************************************
 ***                  POP-UP MESSAGE ACROSS NETWORK                     ***
 **************************************************************************}
{$I compdirs}

unit newsfl;

interface

procedure MakeNewsFlash;
procedure ShowNewsFlash;

implementation

uses tasks,
			app,
			editfile,
			objects,
			tuiedit,
			global,
			dattime,
			views,
			kamsetup,
			status,
			dialogs,
			minilib;

procedure MakeNewsFlash;
var Command,T : word;
		Status : byte;
		FName : FNameStr;
begin
	FName := WorkPath + 'NEWS.FLS';
	Command := EditTextFile(FName,'');

	if Command=cmOK then begin
		{mark all running terminals so they know a newsflash has appeared}
		for T := 1 to MaxTerminal do begin
			if {(T<>TerminalNo) and{} (ProgramStatus.GetWhoAtTerminal(T)<>-1) then begin
				Status := ProgramStatus.GetTerminalStat(T);
				ProgramStatus.SetTerminalStat(T, Status or tsNewsFlash);
			end;
		end;
	end;

end;

procedure ShowNewsFlash;
var News : text;
		Box : PEditBox;
		R : Trect;
		Line : string;
		MaxX, MaxY : integer;

begin
	Assign(News, WorkPath+'NEWS.FLS');
	{$I-}
	Reset(news);
	{$I+}
	if IOREsult=0 then begin
		R.Assign(0,0,20,5);
		New(Box, init(R,'!NEWS FLASH!',nil));
		Box^.Options := Box^.Options or ofCentered;

		MaxY := 1; MaxX := 20;
		while not eof(News) do begin
			Readln(News, Line);
			if MaxX<(length(Line)+6) then MaxX := Length(Line)+6;

			inc(MaxY);

			R.XYLD(3,MaxY,length(Line),1);
			Box^.Insert(New(PStaticText, init(R, Line)));
		end;

		Box^.GrowTo(MaxX, MaxY+5);

		Box^.Insert(New(POurButton, init(Box^.Size.X div 2 - 5, Box^.Size.Y-3, 'O~K~', cmOK, bfDefault, nil)));

		close(News);

		Desktop^.Insert(Box);
	end;
end;

var NFSecs : longint;
		NewsFlashInt : word;

procedure CheckForNewsFlash; far;
var Status : byte;
begin
	if (NewsFlashInt<>0) and (TimeNow.Secs>NFSecs + NewsFlashInt) then begin

		{check if newsflash has changed}
		Status := ProgramStatus.GetTerminalStat(TerminalNo);

		if Status and tsNewsFlash >0 then begin
			ShowNewsFlash;

			{mark this terminal as having read it}
			ProgramStatus.SetTerminalStat(TerminalNo, Status and not tsNewsFlash);
		end;

		NFSecs := TimeNow.Secs;
	end;
end;

begin
	{$IFDEF knewsfl}
		RegisterTask(DesktopTasks, cmMakeNewsFlash, @MakeNewsFlash);

		RegisterNewWithList(lsDesktop, '~N~ews Flash', cmMakeNewsFlash);
	{$ENDIF}

	RegisterTask(DesktopTasks, cmShowNewsFlash, @ShowNewsFlash);

	NewsFlashInt := S2Num(ProgramSetup.Get(siNewsFlashInt, '0'));

	RegisterTask(IdleTasks, 0, @CheckForNewsFlash);
	NFSecs := TimeNow.Secs;
end.
