{*************************************************************
 ***                   Palette Editor                      ***
 *************************************************************}
{taken from the tvdemo program in \bp\examples, and modified to
fit Kameleon}
{$I compflgs}

unit Palettes;

INTERFACE

uses views; {for ppalette}

procedure EditPalette;
procedure LoadPalette(const FileName : string; const Palette : PPalette);
procedure StorePalette(FileName : string; Palette : PPalette);
procedure LoadDefaultPalette;

IMPLEMENTATION

uses memory,
			dosutils, {for fileexists}
			tuimsgs,
			colorsel, dialogs, global, help, app, tuiapp, tasks, menus;


procedure LoadDefaultPalette;
begin
{	if FileExists('KAMELEON.PAL') then LoadPalette('KAMELEON.PAL', KameleonPalette);{}
	DoneMemory;       {clear buffers}
	{Kameleon is still in its .init, so a pointer has not yet been assigned.
	However the application is up and displayed; so we shall cheat and use
	the desktop owner field}
	Desktop^.Owner^.Redraw; {redraw with new colour scheme}
end;

procedure LoadPalette(const FileName : string; const Palette : PPalette);
{note that the space must already be assigned on heap/wherever for the
palette}
var PalFile : file of char;
		B : char;
		W : word;
begin
	ThinkingOn('Loading Palette');
	Assign(PalFile, FileName);
	reset(palFile);
	for W := 1 to length(CAppColor)+length(CHelpColor) do begin {hmmm, how big *is* a palette anyway?}
		Read(PalFile, B);
		Palette^[W] := B;
	end;
	Close(PalFile);
	ThinkingOff;
end;



procedure StorePalette(FileName : string; Palette : PPalette);
var PalFile : file of char;
		B : char;
		W : word;

begin
	ThinkingOn('Storing Palette');
	Assign(PalFile, FileName);
	rewrite(palFile);
	for W := 1 to length(CAppColor)+length(CHelpColor) do begin {hmmm, how big *is* a palette anyway?}
		B := Palette^[W];
		Write(PalFile, B);
	end;
	Close(PalFile);
	ThinkingOff;
end;




procedure EditPalette;
var
	D: PColorDialog;
begin
	D := New(PColorDialog, Init('Edit Colour Scheme',
		ColorGroup('Desktop',       DesktopColorItems(nil),
		ColorGroup('Menus',         MenuColorItems(nil),
		ColorGroup('Edit Boxes',		DialogColorItems(dpGrayDialog, nil),
		ColorGroup('Lists', 				DialogColorItems(wpBlueWindow, nil), {ie dpBlueDialog}
		ColorGroup('Utility Windows',
			ColorItem('Frame passive',     64,  {dpBluedialog offset}
			ColorItem('Frame active',      65,
			ColorItem('Frame icons',       66,
			ColorItem('Scroll bar page',   67,
			ColorItem('Scroll bar icons',  68,
			ColorItem('Header',						 69,
			ColorItem('Text',							 70,
			ColorItem('Selected',					 71,
			ColorItem('Marker',						 72,
		nil))))))))),
		ColorGroup('Help Windows',
			ColorItem('Frame passive',     128,
			ColorItem('Frame active',      129,
			ColorItem('Frame icons',       130,
			ColorItem('Scroll bar page',   131,
			ColorItem('Scroll bar icons',  132,
			ColorItem('Text', 						133,
			ColorItem('Link', 						134,
			ColorItem('Selected Link', 		135,
		nil)))))))),
	nil))))))));

	D^.HelpCtx := hcEditPaletteDlg;

	if Kameleon^.ExecuteDialog(D, KameleonPalette) <> cmCancel then
	begin
		DoneMemory;    { Dispose all group buffers }
		Kameleon^.ReDraw;        { Redraw application with new palette }
		StorePalette('KAMELEON.PAL', KameleonPalette);
	end;
end;

begin
{$IFDEF fixit} writeln('Initialising Palettes unit'); {$ENDIF}

	{see kamapp for menu option}
	RegisterTask(DesktopTasks, cmEditPalette, @EditPalette);

	RegisterTask(StartUpTasks, 0, @LoadDefaultPalette);{}
end.
