	{****************************************************
	 ***    Template for module setups                ***
	 ****************************************************}
	{Provides a template setup for various modules - eg
	accounts setup with default accounting categories, etc}

	{Get and Put methods are provided to allow the setup to be
	stored onto the kameleon.cfg file, though in principle there's
	no reason why these setups could not store themselves onto
	file.  LoadDefaults sets defaults after loading, buttondefaults
	normally calls LoadDefaults here, but is used in cases where the
	"Default" button should produce a complete example layout, but
	the loaddefaults should do nothing (eg modem setup - assume one
	not connected, but "Defaults" button should set up hayes compatible,
	whatever}

unit setup;


INTERFACE

uses
	{$IFDEF Windows}
	wintypes,
	tuiedit,
	{$ELSE}
	tuiedit,
	{$ENDIF}
	objects;

type
	{Template for desktop/person list/etc Setup that reads through above}
	PSetup = ^TSetup;
	TSetup = object(TObject)

		Title : string[20]; {title used in configuration for a group, eg "Backup"}

		constructor Init(const NTitle : string);

		procedure Load; virtual;
		procedure PostLoad; virtual; {adjustments after loading}
		procedure Store; virtual;

		procedure Put(const Lbl, Info : string);
		procedure PutBoolean(const Lbl : string; const B : boolean);
		function Get(const Lbl, Default : string) : string;
		function GetBoolean(const Lbl : string; const Default : boolean) : boolean;
		function GetPath(const Lbl, Default : string) : string;

		procedure SetButtonDefaults; virtual;

		function Edit : word; virtual;
		{$IFDEF Windows}
		procedure AddSetupLines(EditBox : THandle); virtual;
		{$ELSE}
		procedure AddSetupLines(EditBox : PEditBox); virtual;
		{$ENDIF}

	end;

	PSetupButton = ^TSetupButton;
	TSetupButton = object(TOurButton) {tied object should be setup object}
		constructor Init(X,Y : integer; ATitle : string; ADataItem : pointer);
		procedure Press; virtual;
	end;


IMPLEMENTATION

uses
	views, {for ofCentered constant}
	dialogs, {for bfDefault}
	app,
	TuiMsgs,
	{$IFDEF windows} windrvrs, winfiles, {$ELSE} {dosfiles,{} {$ENDIF}
			kamsetup,
			global,
			minilib;


{*****************************************
 ***         IMPLEMENTATION            ***
 *****************************************}
type
	PSetDefaultsButton = ^TSetDefaultsButton;
	TSetDefaultsButton = object(TOurButton)
		procedure Press; virtual;
	end;

	procedure TSetDefaultsButton.Press;
	begin
		DrawState(True);
		PSetup(DataItem)^.SetButtonDefaults;
		Owner^.SetData(DataItem^);
		Owner^.ReDraw;
		DrawState(False);
	end;


constructor TSetup.Init;
begin
	inherited Init;
	Title := NTitle;
	Load;
	PostLoad;
end;

procedure TSetup.Load;
begin end;

procedure TSetup.PostLoad; {for calculations, etc from loaded params}
begin end; {done separately so that the editing only edits pre-calculated values}

procedure TSetup.Store;
begin end;

function TSetup.Get;
begin
	ProgramSetup.SetGroup(Title);
	Get := ProgramSetup.Get(Lbl,Default);
	ProgramSetup.SetGroup('');
end;

function TSetup.GetBoolean;
begin
	ProgramSetup.SetGroup(Title);
	GetBoolean := ProgramSetup.GetBoolean(Lbl,Default);
	ProgramSetup.SetGroup('');
end;

function TSetup.GetPath;
begin
	ProgramSetup.SetGroup(Title);
	GetPath := ProgramSetup.GetPath(Lbl,Default);
	ProgramSetup.SetGroup('');
end;

procedure TSetup.Put;
begin
	ProgramSetup.SetGroup(Title);
	ProgramSetup.Put(Lbl,Info);
	ProgramSetup.SetGroup('');
end;

procedure TSetup.PutBoolean;
begin
	ProgramSetup.SetGroup(Title);
	ProgramSetup.PutBoolean(Lbl,B);
	ProgramSetup.SetGroup('');
end;

procedure TSetup.SetButtonDefaults;
begin end;


procedure TSetup.AddSetupLines;
begin end;


function TSetup.Edit;
var EditBox : PObjectEditBox;
		R : TRect;
		Control : word;
begin
{  Load; {leave as what is operating}

	R.Assign(0, 0, 34,10);   {addsetuplines should change dimensions}
	New(EditBox, Init(R, Title,nil));

	EditBox^.Insert(New(PSkipBytes, init(Sizeof(Title)))); {skip user title}

	AddSetUpLines(EditBox);

	with EditBox^ do begin
		Options := Options or ofCentered;

		{-- Add Buttons --}
		Insert(New(PSetDefaultsButton, init(Size.X-33,Size.Y-3, '~D~efault', cmNone, bfNormal, @Self)));
		InsOKButton(Size.X-22,Size.Y-3, @Self);
		InsCancelButton(Size.X-12,Size.Y-3);

		EndInit;

		SetData(Self);
	end;

	Control := Desktop^.ExecView(EditBox);

	if Control=cmOK then begin
		Store;
		Load; {load again with all path validations, etc}
		PostLoad; {set auto fields}
	end;

	Edit := Control;

	dispose(EditBox, done);
end;



{****************************************************
 ***                 SETUP BUTTON                 ***
 ****************************************************}
{provides a reasonably simple way of accessing a setup object from a dialog
box (such as the curtainquote setup from the curtainquote entry box).  Use
as a simple tiedObject (see edit unit) object, the tied object being the
setup object.  Pressing the button edits the setup.}

constructor TSetupButton.Init;
begin
	inherited Init(X,Y, ATitle, cmNone, bfNormal, ADataItem);
	kbType := kbSetup;
end;

procedure TSetupButton.Press;
begin
	DrawState(True);
	if DataItem<>nil then PSetup(DataItem)^.Edit;
	DrawState(False);
end;

end.
