{unit for stack objects with push, pop & clear methods}
{Head points to top element}
unit Stacks;

interface

uses objects;

const
	StackSize = 10;

type
{	PWordStack = ^TWordStack;{}
	TWordStack = object
		Element : array[1..StackSize] of word;
		Head : word;

		procedure Init;

		procedure Push(W : word);
		function Pop : word;
	end;

implementation

procedure TWordStack.INit;
var I : byte;
begin
	Head := 0;
	for I := 1 to StackSize do Element[I] := 0; {not strictly necessary}
end;

procedure TWordStack.Push;
begin
	if Head<StackSize then begin
		inc(Head);
		Element[Head] := W;
	end else begin
		Move(Element[2], Element[1],(StackSize-1)*sizeof(word));
		Element[Head] := W;
	end;

end;

function TWordStack.Pop;
begin
	if Head>0 then begin
		Pop := Element[Head];
		dec(Head);
	end else
		Pop := 0;
end;


end.
