{***********************************************************************
 ***                    2-D MATRIX/TABLE                             ***
 ***********************************************************************}
{$I compflgs}
{A simple 2d matrix of longints, based on a file}
unit Tables;

interface

uses files;

type
	PTableStream = ^TTableStream;
	TTableStream = object(TDataStream)
		Width : word;
		constructor Init(NFileName : string; NWidth : word);

		procedure SetPtr(const X, Y : word; ID : longint);
		function  GetPtr(const X, Y : word) : longint;
	end;

function TableStream(fiType : word) : PTableStream;

implementation

uses tuimsgs;

function TableStream(fiType : word) : PTableStream;
begin
	TableStream := PTableStream(Stream(fiType));
end;

constructor TTableStream.Init;
begin
	inherited Init(NFileName, 4, StreamBufSize);
	Width := NWidth;
end;

procedure TTableStream.SetPtr(const X,Y : word; ID : longint);
var N,Rec,TempRec : longint;
begin
	Rec := X + (Y * Width);
	if Rec>NoRecs then begin
		N := -1;
		ThinkingOn('Expanding Timings table');
		SeekRec(NoRecs);
		for TempRec := NoRecs to Rec do Write(N,4);
		ThinkingOff;
	end;

	SeekRec(Rec);
	Write(ID,4);
end;

function TTableStream.GetPtr(const X, Y : word) : longint;
var Rec,ID : longint;
begin
	Rec := X + (Y * Width);
	if Rec>=NoRecs then
		GetPtr := -1
	else begin
		SeekRec(Rec);
		Read(ID,4);
		GetPtr := ID;
	end;
end;

end.
