{***************************************************************
 ***             SOME STANDARD DIALOG BOXES                  ***
 ***************************************************************}
{$I compflgs}
unit TuiBoxes;

INTERFACE

uses objects, inpfname;

{Simple one-line with access to files}
{function InputFNameBox(Title : string; var FIleName : FNameStr; const Ext,Path : string; EditProc : TFileEditorProc) : word;{}

{Standard Borland File-select dialog box - to replace above}
function FileSelectBox(const Title,NameTitle : string; var FIleName : FNameStr; Ext,Path : string;
													const fdOptions, hcType : word) : word;

function SaveAsBox(var FullFileName : FnameStr; const Ext : string) : word;

function InputLintBox(BoxTitle,LineTitle : string; var L : longint) : word;

IMPLEMENTATION

uses
			stddlg, {the new file-entry dialog box}
			minilib,
			help,
			global,
			tuiedit, app, dialogs, views, dosutils, files;

{Full file name is original name, Ext is allowed list of extensions}
function SaveAsBox(var FullFileName : FNameStr; const Ext : string) : word;
var path, FileName : string;
		R : TRect;
		EditBox : PEditBox;
		Control : word;
		Len : byte;

begin
	{split full name into path & name}
	Path := GetPath(FullFileName);
	FileName := GetFileName(FullFileName);

	if (pos(' ',Ext)>0) or (Ext='') then
		Len := 12
	else begin
		Len := 8;
		FileName := Copy(Filename, 1, pos('.',Filename+'.')-1);
	end;
	FileName := Copy(FileName, 1, Len); {chop off if nec}

	R.Assign(0, 0, 30,7);
	New(EditBox, Init(R, 'SAVE AS',nil));

	with EditBox^ do begin
		Options := Options or ofCenterX or ofCenterY;  {Centralise}
		HelpCtx := hcSaveAsDlg;

		{--- Set up box interior ---}
		InsTitledField(10,  2, Len, 1, 'Name', New(PinputFName, Init(R, Len, Ext, Path, False, nil)));
		PInputFName(Current)^.MustInput := True;

		{-- Buttons --}
		Insert(New(POurButton, init(Size.X-24, 4, '~S~ave', cmOK, bfDefault+bfGetData, @FileName)));
		Insert(New(PourButton, init(Size.X-13, 4, '~A~bandon',  cmCancel,  bfNormal, nil)));

		EndInit;
	end;

	if FileName[1]<>'.' then EditBox^.SetData(FileName);

	Control := Desktop^.ExecView(EditBox);

	if Control=cmOK then begin
		EditBox^.GetData(FileName);
		FullFileName := Path+FileName;
		if Len = 8 then FullFileName := FullFileName+ '.' + Ext;
	end;

	SaveAsBox := Control;

	dispose(EditBox, done);
end;

function FileSelectBox(const Title,NameTitle : string;
													var FIleName : FNameStr; Ext,Path : string;
													const fdOptions , hcType: word) : word;
var FileDlgBox : PEditBox;
		R : TRect;
		FileDialog : PFileDialog;
		WildCard : string;
		Control : word;

begin
	{make up wildcard line}
	if Ext = '' then
		WildCard := '*.*'
	else begin
		WildCard := '';
		while Ext<>'' do
			WildCard := WildCard + '*.'+SplitByWord(Ext)+';';
		dec(WildCard[0]);
	end;

	WildCard := Path+WildCard;
{	fdOptions := fdOptions or fdEditButton;{}
	FileDialog := New(PFileDialog, init(WildCard,Title, NameTitle, fdOptions, 1));
	if hcType = hcNoContext then
		FileDialog^.HelpCtx := hcFileSelectorDlg
	else
		FileDialog^.HelpCtx := hcType;

	FileDialog^.SetFileName(FileName);

	Control := Desktop^.ExecView(FileDialog); {control returns cmcancel or cmfileopen/etc}

	FileSelectBox := Control; {cancel, new, etc}

	if (Control <>cmCancel) and (Control<>cmNew) then begin
		FileDialog^.FileName^.GetData(FileName);
			if (fdOptions and fdFullPath <>0) then
				if (pos(':',FileName)=0) and (FileName[1]<>'\') then
					FileName := FileDialog^.Directory^+FileName;
{		FileSelectBox := cmOK;{may need to know which button was pressed}
	end;

	dispose(FileDialog, done);
end;{}






function InputLintBox(BoxTitle,LineTitle : string; var L : longint) : word;
var EditBox : PEditBox;
		R : Trect;
		Control : word;

begin
	R.Assign(0,0,35,7); R.Move(20,5);
	New(EditBox, init(R, BoxTitle,nil));

	with EditBox^ do begin
		InstitledField(15, 2,10, 1, LineTitle,   New(PInputlint, init(R,10)));

		InsOKButton(5, 4, @L);
		InsCancelButton(16, 4);

		EndInit;

		SetData(L);
	end;

	InputLintBox := Desktop^.ExecView(EditBox);

	dispose(EditBox, done);
end;


end.
