{************************************************************
 ***                                                      ***
 ***                          UPDATE UNIT                 ***
 ***                       v4.2 to 4.3                    ***
 ***********************************************************}
{Very simple, just provides converter for Kilimanjaro's QuickInvoice
to the combined Invoice with the Quick Marker}
{$I compdirs}

unit upfrom42;

interface

uses jimmys;

procedure QuickInvConverter(var Jimmy : PJimmy; var RecSize : word); far;

implementation


uses
{$IFDEF Windows}
			winmsgs,
{$ELSE}
			tuimsgs, tuiapp,
{$ENDIF}
			fixit, {for jimmy file methods}
			update,

			indexes,
			scodes,
			vat,
			multcurr,
			tasks,
			dosutils,
			kamsetup,
			devices, printers,
			minilib,
			menus, tui, help, views,

			kqinv, kinvoice, kestimat,
			kcompsup, kqnote,

			files,


			{$IFDEF Krongai} krongord, {$ENDIF}
			idindex,
			address,

		indxutil,
		jimhooks,
		status,

		alljimmy,
		notes,
		objects,

		dbg,

			payments,
			ordproc,
			kjob,
			dattime, global;



procedure QuickInvConverter(var Jimmy : PJimmy; var RecSize : word);
var	Invoice : PINvoice;
		Person : Pjimmy;
		D : string;

begin
	if Jimmy^.Deleted then D := ' Del' else D := '';
	Debug.Writeln('Doing ID'+N2Str(Jimmy^.RecNo)+' sr'+N2Str(Jimmy^.srType)+D);

	{--- Size changes --------}
	if typeof(Jimmy^)=typeof(TAddress) then begin
		case PAddress(Jimmy)^.adType of
			adPOBox : RecSize := 100;
			adEurope: RecSize := 100;
			adUSA   : REcSize := 150;
			ademail : REcSize := 100;
		else
			RecSize := 250;
		end;
	end;

	if typeof(Jimmy^)=typeof(THardware) then RecSize := 350;
	if typeof(Jimmy^)=typeof(TSoftware) then RecSize := 350;
	if typeof(Jimmy^)=typeof(THistoryNote) then RecSize := 40; {now 50}
	if typeof(Jimmy^)=typeof(TRongaiDelivery) then RecSize := 180; {now 200}

	if Jimmy^.Deleted then begin
		dispose(Jimmy, done);
		Jimmy := nil;
		exit;
	end;

	{fix for kilimanjaro update}
	if Jimmy^.srType = srPayment then begin
		{assumes invoice will already have been converted}
		Invoice := PInvoice(NewJimmyStream^.GetAt(GetNewIDPtr(PPayment(Jimmy)^.ForOrderID)));
		if Invoice=nil then begin
			Debug.Writeln('Found & removed payment for duff OrderID '+N2Str(PPayment(Jimmy)^.ForOrderID)+'->nil');
			dispose(Jimmy, done);
			Jimmy := nil;
			exit;
		end else begin
			if Invoice^.srtype<>srInvoice then begin
				Person := PJimmy(NewJimmyStream^.GetAt(GetNewIDPtr(PPayment(Jimmy)^.WhoPaidID)));
				Debug.Writeln('Found & removed duff payment for '+Person^.GetName(naDisplay, 0));
				dispose(Invoice, done);
				dispose(Person, done);
				dispose(Jimmy, done);
				Jimmy := nil;
				exit;
			end;
			dispose(INvoice, done);
		end;
	end;

	if typeof(Jimmy^)=typeof(TInvoice) then begin
		with PInvoice(Jimmy)^ do begin
			{for kilimanjaro}
			LastPrint.SetToDate(Date);
			State := (State or osSent) and not osEdited;
		end;
	end;

{	if typeof(Jimmy^)=typeof(TInvoice) then PInvoice(JImmy)^.Recalculate;
	if typeof(Jimmy^)=typeof(TEstimate) then Pestimate(JImmy)^.Recalculate;{}

	if typeof(Jimmy^)=typeof(TQuickInvoice) then begin

		Debug.Write('Converting Quick Invoice '+N2Str(Jimmy^.RecNo)+'...');
		New(Invoice, init(nil));
		with Invoice^ do begin


			Ptr2Items 		:= PQuickInvoice(Jimmy)^.Ptr2Items;

			LastPrint.SetToDate(PQuickInvoice(Jimmy)^.LastPrint);
			State					:= PQuickInvoice(Jimmy)^.State;
			{for kilimanjaro}
			LastPrint.SetToDate(PQuickInvoice(Jimmy)^.Date);
			State := (State or osSent) and not osEdited;

			with TotallerGroup do begin
				CashDisc.SetTo(	PQuickInvoice(Jimmy)^.TotallerGroup.CashDisc);
				SubTotal.SetTo( PQuickInvoice(Jimmy)^.TotallerGroup.SubTotal);
				VAT.SetTo(			PQuickInvoice(Jimmy)^.TotallerGroup.VAT);
				Calculate(True);
			end;

			Ref						:=PQuickInvoice(Jimmy)^.Ref;
			OldRef				:=PQuickInvoice(Jimmy)^.OldRef; {for seeing if ref has changed}
			Date.SetToDate(PQuickInvoice(Jimmy)^.Date);
			ForWho    		:=PQuickInvoice(Jimmy)^.ForWho;
			ByWho					:=PQuickInvoice(Jimmy)^.ByWho;

			dispose(Notes, done);
			Notes := PQuickInvoice(Jimmy)^.Notes;
			New(PQuickInvoice(Jimmy)^.Notes, init);

			DaysDiscount 	:=PQuickInvoice(Jimmy)^.DaysDiscount;

			PaidTotal.SetTo(PQuickInvoice(Jimmy)^.PaidTotal);
			Due.SetTo(      PQuickInvoice(Jimmy)^.Due);

			Ptr2Payments 	:=PQuickInvoice(Jimmy)^.Ptr2Payments;
			OutTrayIdx 		:= -1;
			Quick 				:= True;

			RecNo := Jimmy^.RecNo;
		end;

		Debug.Writeln('...done');
		dispose(Jimmy, done);
		Jimmy := Invoice;
	end;{}



end;


{************************************************
 **        OLD, SMALL ADDRESS                  **
{************************************************}

{This address was too small - trying to find a way for it to be auto-replaced
by new srtype}
type
	PSmallAddress = ^TSmallAddress;
	TSmallAddress = object(TAddress)
		function RecSize : word; virtual;
		function srType : word; virtual;
		constructor Load(var S : TDataStream);
		procedure   StoreFields(var S : TDataSTream); virtual;
	end;

function TSmallAddress.RecSize : word;
begin
	case adType of
		adPOBox : RecSize := 100;
		adEurope: RecSize := 100;
		adUSA   : REcSize := 150;
		ademail : REcSize := 100;
	else
		RecSize := 250;
	end;
end;

function TSmallAddress.srType : word;
begin srType := srAddress; end;

constructor TSmallAddress.Load;
begin
	inherited Load(S);
end;

procedure TSmallAddress.StoreFields;
begin
	inherited StoreFields(S);
end;

const
	{--- Required for Stream ----}
	RSmallAddress : TStreamRec = (
		ObjType : srAddress;
		VmtLink : Ofs(TypeOf(TSmallAddress)^);
		Load : @TSmallAddress.Load;
		Store : @TSmallAddress.Store
	);


begin
end.
