{*************************************************************
 ***             VAT ROUTINES                              ***
 *************************************************************}
{$I compflgs}
{used to be part of the accounts, but need to know VAT stuff for invoices
too, even without accounts module}
unit VAT;

INTERFACE

uses files, objects, global,
			scodes,
			tuiedit;

type
	{VAT Rate scode}
	PVATRateScodeItem = ^TVATRateScodeItem;
	TVATRateScodeItem = object(TScodeItem)
		Rate : single; {percentage rate}
		constructor Init(const NCode, NDesc : string; const NRate : single);
		constructor Load(var S : TDataStream);
		procedure Store(var S : TDataStream);
		function DisplayLine(Maxlen : integer) : string; virtual;
		procedure AddEditFields(P : PObjectEditBox);           virtual;
	end;

	function CreateVATRateScodeItem(Const NCode, NDesc : string) : PScodeItem;


const
 RVATRateScode : TStreamRec = (
	 ObjType : srVATRateScodeItem;
	 VmtLink : Ofs(TypeOf(TVATRateScodeItem)^);
	 Load : @TVATRateScodeItem.Load;
	 Store : @TVATRateScodeItem.Store
 );



IMPLEMENTATION

uses kamsetup,minilib, tuimsgs;

{*****************************************
 ***       VAT Rate         SCode       **
 *****************************************}
constructor TVATRateScodeItem.Init;
begin
	inherited Init(NCode, NDesc);
	Rate := NRate;
end;

constructor TVATRateScodeItem.Load;
begin
	inherited Load(S);
	S.Read(Rate, 4);
end;

procedure TVATRateScodeItem.Store;
begin
	inherited Store(S);
	S.Write(Rate, 4);
end;

function TVATRateScodeItem.DisplayLine;
var S : string;
		SS : string;
begin
	S := inherited DisplayLine(Maxlen);
  SS := R2Str(Rate, dcUpto+2, 0);
	DisplayLine := SetLength(S, Maxlen-length(SS)-1)+SS+'%';
end;

procedure TVATRateScodeItem.AddEditFields(P : PObjectEditBox);
var R : TRect;
begin
	inherited AddEditFields(P);
	P^.GrowTo(P^.Size.X, P^.Size.Y+1); {make room for extra fields}
	P^.InsTitledField(9, 4,  5, 1, '~R~ate', New(PInputSingle, init(R, 5)));
end;

{********************************
 **   REGISTRATION, ETC       ***
 ********************************}
{function DefaultVATCode;
var S : string;
begin
	S := ProgramSetup.Get(siDefaultVAT,'STD');
	if S = '' then S := 'STD';
	DefaultVATCode := S;
end;{}


function CreateVATRateScodeItem(const NCode, NDesc : string) : PScodeItem;
begin
	CreateVATRateScodeItem := New(PVATRateScodeItem, init(NCode, NDesc,0));
end;

begin
	New(SCodeCollection[scVATRates], init('VATRATES.SC','VAT Rates', CreateVATRateSCodeItem));
	RegisterType(RVATRateSCode);
end.
