{$I compflgs}
unit Video;

interface

uses Drivers, Menus;

const
	{ Notice this takes command constants 4000 through to 4110 }
	cmVideo      = 4000;
	cm25         = cmVideo + 0;
	cm50         = cmVideo + 1;
	cmBW         = cmVideo + 2;
	cmMono       = cmVideo + 3;
	cmOrc80x60   = cmVideo + 10;
	cmOrc132x25  = cmVideo + 11;
	cmOrc132x28  = cmVideo + 12;
	cmOrc132x44  = cmVideo + 13;
	cmPar132x25  = cmVideo + 20;
	cmPar132x43  = cmVideo + 21;
	cmSig132x25  = cmVideo + 30;
	cmSig132x44  = cmVideo + 31;
	cmSTB132x25  = cmOrc132x25;
	cmSTB132x44  = cmOrc132x44;
	cmTri80x30   = cmVideo + 40;
	cmTri80x43   = cmVideo + 41;
	cmTri80x60   = cmVideo + 42;
	cmTri132x25  = cmVideo + 43;
	cmTri132x30  = cmVideo + 44;
	cmTri132x43  = cmVideo + 45;
	cmTri132x60  = cmVideo + 46;
	cmGen132x25  = cmOrc132x25;
	cmGen132x28  = cmOrc132x28;
	cmGen132x43  = cmOrc132x44;
	cmCom132x25  = cmOrc132x25;
	cmCom132x28  = cmOrc132x28;
	cmCom132x43  = cmOrc132x44;
	cmCom132x50  = cmVideo + 50;
	cmCom132x60  = cmVideo + 51;
	cmWiz80x34   = cmVideo + 60;
	cmWiz80x45   = cmVideo + 61;
	cmWiz132x25  = cmOrc132x25;
	cmWiz132x44  = cmOrc132x44;
	cmATI132x25  = cmOrc132x25;
	cmATI132x44  = cmVideo + 70;
	cmVesa80x60  = cmVideo + 80;
	cmVesa132x25 = cmVideo + 81;
	cmVesa132x43 = cmVideo + 82;
	cmVesa132x50 = cmVideo + 83;
	cmVesa132x60 = cmVideo + 84;
	cmTs380x60   = cmOrc80x60;
	cmTs3100x40  = cmVideo + 90;
	cmTs3132x25  = cmOrc132x25;
	cmTs3132x28  = cmOrc132x28;
	cmTs3132x44  = cmOrc132x44;
	cmTs4132x60  = cmVideo + 91;
	cmEvr80x34   = cmVideo + 100;
	cmEvr80x60   = cmVideo + 101;
	cmEvr100x43  = cmVideo + 102;
	cmEvr100x75  = cmVideo + 103;
	cmEvr132x25  = cmVideo + 104;
	cmEvr132x44  = cmVideo + 105;
	cmOtherVideo = cmVideo + 110;
	StdModes = [0..smCO80,smMono];

function StdVideoMenu(Next: PMenuItem): PMenuItem;

function ModeFrom(Command : word) : word; {returns screen mode, given command}

procedure SVGA(Cmd: Word); {sets screen, etc, given command}

{function SVGAHandleEvent(Cmd: Word): Boolean;{}

implementation

{$V-}

{mch - modified to fit with new command-parameter for submenus}

uses minilib, App, kamsetup, Views;


{******************************************************************
 ***              CREATE SELECTOR MENU                          ***
 ******************************************************************}

function StdVideoMenu(Next: PMenuItem): PMenuItem;
begin
	StdVideoMenu := NewSubMenu('~V~ideo', hcNoContext, 0, NewMenu(
		NewItem('Colour ~2~5 Line', '', kbNoKey, cm25, hcNoContext,
		NewItem('Colour ~4~3/50 Line', '', kbNoKey, cm50, hcNoContext,
		NewItem('~B~lack & white', '', kbNoKey, cmBW, hcNoContext,
		NewItem('~M~onochrome', '', kbNoKey, cmMono, hcNoContext,
		NewLine(
		NewSubMenu('~A~TI VGA Wonder', hcNoContext, 0, NewMenu(
			NewItem('132x~2~5', '', kbNoKey, cmATI132x25, hcNoContext,
			NewItem('132x~4~4', '', kbNoKey, cmATI132x44, hcNoContext,
			nil))),
		NewSubMenu('~C~ompaq Integrated VGS', hcNoContext, 0, NewMenu(
			NewItem('132x~2~5', '', kbNoKey, cmCom132x25, hcNoContext,
			NewItem('132x2~8~', '', kbNoKey, cmCom132x28, hcNoContext,
			NewItem('132x~4~3', '', kbNoKey, cmCom132x43, hcNoContext,
			NewItem('132x~5~0', '', kbNoKey, cmCom132x50, hcNoContext,
			NewItem('132x~6~0', '', kbNoKey, cmCom132x60, hcNoContext,
			nil)))))),
{		NewSubMenu('~E~verex Viewpoint/EV-673', hcNoContext, 0, NewMenu(
			NewItem('80x3~4~', '', kbNoKey, cmEvr80x34, hcNoContext,
			NewItem('80x~6~0', '', kbNoKey, cmEvr80x60, hcNoContext,
			NewItem('100x4~3~', '', kbNoKey, cmEvr100x43, hcNoContext,
			NewItem('100x~7~5', '', kbNoKey, cmEvr100x75, hcNoContext,
			NewItem('132x~2~5', '', kbNoKey, cmEvr132x25, hcNoContext,
			NewItem('~1~32x44', '', kbNoKey, cmEvr132x44, hcNoContext,
			nil))))))),{}
		NewSubMenu('Orchi~d~ Prodesigner', hcNoContext, 0, NewMenu(
			NewItem('80x~6~0', '', kbNoKey, cmOrc80x60, hcNoContext,
			NewItem('132x~2~5', '', kbNoKey, cmOrc132x25, hcNoContext,
			NewItem('132x2~8~', '', kbNoKey, cmOrc132x28, hcNoContext,
			NewItem('132x~4~4', '', kbNoKey, cmOrc132x44, hcNoContext,
			nil))))),
		NewSubMenu('~P~aradise', hcNoContext, 0, NewMenu(
			NewItem('132x~2~5', '', kbNoKey, cmPar132x25, hcNoContext,
			NewItem('132x~4~3', '', kbNoKey, cmPar132x43, hcNoContext,
			nil))),
		NewSubMenu('~S~igma VGA Legend', hcNoContext, 0, NewMenu(
			NewItem('132x~2~5', '', kbNoKey, cmSig132x25, hcNoContext,
			NewItem('132x~4~4', '', kbNoKey, cmSig132x44, hcNoContext,
			nil))),
		NewSubMenu('ST~B~ Powergraph', hcNoContext, 0, NewMenu(
			NewItem('132x~2~5', '', kbNoKey, cmSTB132x25, hcNoContext,
			NewItem('132x~4~4', '', kbNoKey, cmSTB132x44, hcNoContext,
			nil))),
		NewSubMenu('~T~rident 8900', hcNoContext, 0, NewMenu(
			NewItem('80x~3~0', '', kbNoKey, cmTri80x30, hcNoContext,
			NewItem('80x~4~3', '', kbNoKey, cmTri80x43, hcNoContext,
			NewItem('~8~0x60', '', kbNoKey, cmTri80x60, hcNoContext,
			NewItem('132x2~5~', '', kbNoKey, cmTri132x25, hcNoContext,
			NewItem('13~2~x30', '', kbNoKey, cmTri132x30, hcNoContext,
			NewItem('~1~32x43', '', kbNoKey, cmTri132x43, hcNoContext,
			NewItem('132x~6~0', '', kbNoKey, cmTri132x60, hcNoContext,
			nil)))))))),
		NewSubMenu('Tseng Labs ET-~3~000/4000', hcNoContext, 0, NewMenu(
			NewItem('80x~6~0', '', kbNoKey, cmTs380x60, hcNoContext,
			NewItem('1~0~0x40', '', kbNoKey, cmTs3100x40, hcNoContext,
			NewItem('132x~2~5', '', kbNoKey, cmTs3132x25, hcNoContext,
			NewItem('132x2~8~', '', kbNoKey, cmTs3132x28, hcNoContext,
			NewItem('132x~4~4', '', kbNoKey, cmTs3132x44, hcNoContext,
			nil)))))),
		NewSubMenu('Tsen~g~ Labs ET-4000', hcNoContext, 0, NewMenu(
			NewItem('132x~6~0', '', kbNoKey, cmTs4132x60, hcNoContext,
			nil)),
		NewSubMenu('VGA ~W~izard', hcNoContext, 0, NewMenu(
			NewItem('80x~3~4', '', kbNoKey, cmWiz80x34, hcNoContext,
			NewItem('80x4~5~', '', kbNoKey, cmWiz80x45, hcNoContext,
			NewItem('132x~2~5', '', kbNoKey, cmWiz132x25, hcNoContext,
			NewItem('132x~4~4', '', kbNoKey, cmWiz132x44, hcNoContext,
			nil))))),
{		NewSubMenu('~V~ESA', hcNoContext, 0, NewMenu(
			NewItem('~8~0x60', '', kbNoKey, cmVesa80x60, hcNoContext,
			NewItem('132x~2~5', '', kbNoKey, cmVesa132x25, hcNoContext,
			NewItem('132x~4~3', '', kbNoKey, cmVesa132x43, hcNoContext,
			NewItem('132x~5~0', '', kbNoKey, cmVesa132x50, hcNoContext,
			NewItem('132x~6~0', '', kbNoKey, cmVesa132x60, hcNoContext,
			nil)))))), {see comment below}
		NewLine(
		NewItem('~O~ther Mode', '', kbNoKey, cmOtherVideo, hcNoContext,
		nil)))))))))))))))))){))},
	Next);
end; { StdVideoMenu }

{*****************************************************************
 ***                 CALCULATES  MOED FROM COMMAND             ***
 *****************************************************************}

{creates mode from command}
function ModeFrom(Command : word) : word;
var Mode, Mode2 : word;
begin
	Mode := 0; Mode2 := 0;

	{ Set VESA interrupt function if necessary }
	{ and Set Everex interrupt function if necessary }
	case Command of
		cmVesa80x60..cmVesa132x60 : Mode2 := $4F02;
		cmEvr80x34..cmEvr132x44 	: Mode2 := 112;
	else
		Mode2 := 0;
	end;

	case Command of
		cm25				: Mode := smCO80;
		cm50				: Mode := smCO80 + smFont8x8;
		cmBW				: Mode := smBW80;
		cmMono			: Mode := smMono;
		cmCom132x50	: Mode := 39;
		cmCom132x60	: Mode := 40;
		cmOrc80x60	: Mode := 38;
		cmOrc132x25	: Mode := 35;
		cmOrc132x28	: Mode := 36;
		cmOrc132x44	: Mode := 34;
		cmPar132x25	: Mode := 85;
		cmPar132x43	: Mode := 84;
		cmSig132x25	: Mode := 28;
		cmSig132x44	: Mode := 29;
		cmTri80x30	: Mode := 80;
		cmTri80x43	: Mode := 81;
		cmTri80x60	: Mode := 82;
		cmTri132x25	: Mode := 87;
		cmTri132x30	: Mode := 88;
		cmTri132x43	: Mode := 89;
		cmTri132x60	: Mode := 90;
		cmWiz80x34	: Mode := 50;
		cmWiz80x45	: Mode := 51;
		cmTs3100x40	: Mode := 42;
		cmTs4132x60	: Mode := 33;
		cmVesa80x60	: Mode := $108;
		cmVesa132x25: Mode := $109;
		cmVesa132x43: Mode := $10A;
		cmVesa132x50: Mode := $10B;
		cmVesa132x60: Mode := $10C;
		cmEvr80x34	: Mode := 3;
		cmEvr80x60	: Mode := 4;
		cmEvr100x43	: Mode := 7;
		cmEvr100x75	: Mode := 8;
		cmEvr132x25	: Mode := 10;
		cmEvr132x44	: Mode := 11;
	end;

	ModeFrom := Mode;
end;

{****************************************************************
 ***                 SETS SCREEN GIVEN COMMAND                ***
 ****************************************************************}


procedure SVGA(Cmd: Word);
var
	Mode, Mode2: Word;
begin
	Mode := ModeFrom(Cmd);

	if ScreenMode <> Mode then begin
{		ScreenMode2 := Mode2; video7
		if Lo(Mode) in StdModes then
			DriverMouse
		else
			SimMouse;                 {}
		HideMouse;
		if Application<>nil then with Application^ do begin
			SetScreenMode(Mode);
			ReDraw;
		end;
		if (not (Lo(Mode) in StdModes)) and (Mode2 = 0) then
			ScreenMode := Lo(Mode) { Strip off any smFont8x8 bit }
		else
			ScreenMode := Mode;
		ShowMouse;
	end;
end; { SVGA }


end. { Video }