{*************************************************************
 ***                           WINDOWS EXTENSIONS           ***
 **************************************************************}

{Like the tui module, which provides extra routines and object descendants
with extra features useful for Kameleon, so this unit provides some
extra handy bits}

unit Win;

INTERFACE

uses owindows, odialogs, wintypes;

{===================== MENUS ===========================}
type
	PMenuItem = ^TMenuItem;
	TMEnuItem = record
		Flags : word; {mf_string - nul terminated string, mf_bitmap, etc}
									{mf_popup means command is the handle of the sub menu}
		Command : word; {command identifier}
		Item : PChar; {name}
		Next : PMenuItem;
	end;

type
	TMenuStr = string[21];

{makes compatible with turbovision}
function NewItem(const Name,Param : TMenuStr; const kbType, Command, hcType : word; const Next : PMenuItem) : PMenuItem;
function NewLine(Next: PMenuItem): PMenuItem;
function NewSubMenu(Name: TMenuStr; KeyCode : word; AHelpCtx: Word; SubMenu: PMenuItem;	Next: PMenuItem): PMenuItem;
function NewMenu(MenuItem : PMenuItem) : PMenuItem; {dummy to slot into newsubmenu, compatible with turbovision}

function CopyItem(const SourceItem : PMenuItem) : PMenuItem;
procedure AddItemEnd(const Menu : hMenu; Item : PMenuItem);
procedure AddItemSubMenu(const Menu : hMenu; const SubMenuTitle : string; Item : PMenuItem);
procedure AddItemSubSubMenu(const Menu : hMenu; const SubMenuTitle, SubSubMenuTitle : string; Item : PMenuItem);

{=========== Strings/PChar =========================}
function S2PChar(S : string) : PChar;

const
	cmCancel = 0;

{========== Handling events - Turbo Vision compatibility ==========}
type
	TEvent = record
		What : word;
		COmmand : word;
	end;


{========= Boxes & Windows ========================================}
type
	POurDialog = ^TOurDialog;
	TOurDialog = object(TDialog)
	end;

	POurWindow = ^TOurWindow;
	TourWindow = Object(TWIndow)
	end;

	{for easy translation}
	PWinView = ^TWinView;
	TWinView = object(TWindowsObject)
		constructor INit(AParent : PWindowsObject; X,Y,W,H : integer);
	end;

IMPLEMENTATION

uses minilib, strings, winprocs;

function S2PChar(S : String) : PChar;
var P : pchar;
begin
	GetMem(P, length(S)+1);
	StrPCopy(P, S);
	S2PChar := P;
end;

function TV2WinMenu(TV : PChar) : PChar;
var B :word;
		Done :boolean;
begin
	{convert first tilde to andpersand}
	if StrScan(TV, '~')<>nil then TV[StrScan(TV, '~')-TV]:='&';
	while StrScan(TV, '~')<>nil do StrDel(TV, StrScan(TV,'~')-TV,1);

	{delete all others}
	DelTildes(TV^);
{	for B := 0 to StrLen(TV) do
		if TV[B] = '~' then TV[B] := '&'; {swap tildes for anpersands}
	TV2WinMenu := TV;
end;


function NewItem;
var MenuItem : Pmenuitem;
begin
	New(MenuItem);
	MenuItem^.Flags := mf_string; {normal...}
	MenuItem^.Command := COmmand;
	MenuItem^.Item :=  S2Pchar(Name);
	MenuItem^.Next := Next;
	NewItem := MenuItem;
end;

function NewLine;
var MenuItem : Pmenuitem;
begin
	New(MenuItem);
	MenuItem^.Flags := mf_string; {normal...}
	MenuItem^.Command := 0;
	MenuItem^.Item := '-------';
	MenuItem^.Next := Next;
	NewLine := MenuItem;
end;


function NewSubMenu;
var MenuItem : PMenuItem;
begin
	New(MenuItem);
	MenuItem^.Flags := mf_popup;
	MenuItem^.COmmand := CreateMenu;
	AddItemEnd(MenuItem^.Command, SubMenu);
	GetMem(MenuItem^.Item, length(Name)+1); StrPCopy(MenuItem^.Item, Name);
	MenuItem^.Next := Next;
	NewSubMenu := MenuItem;
end;

function NewMenu;
begin
	NewMenu := MenuItem;
end;

function CopyItem;
var MenuItem : Pmenuitem;
begin
	New(MenuItem);
	MenuItem^.Flags := SourceItem^.Flags;
	MenuItem^.Command := SourceItem^.COmmand;
	MenuItem^.Item := StrNew(SourceItem^.Item);
	MenuItem^.Next := nil;
	CopyItem := MenuItem;
end;

procedure AddItemEnd;
begin
	appendmenu(Menu, Item^.Flags, Item^.Command, TV2WinMenu(Item^.Item));
	if Item^.Next<>nil then AddItemEnd(Menu, Item^.Next);
end;

procedure AddItemSubMenu;
begin
end;

procedure AddItemSubSubMenu;
begin
end;

{************************************************************
 ***                       BASIC VIEW                     ***
 ************************************************************}

constructor TWinView.INit(AParent : PWindowsObject; X,Y,W,H : integer);
begin
	inherited Init(AParent);
end;

end.
