{*******************************************************************
 ***                 Windows Application object                   ***
 *******************************************************************}
{$I compflgs}
unit WinApp;

INTERFACE

uses global, OWindows, WinTypes;


type
	PKameleon = ^TKameleon;
	TKameleon = object(TApplication)
		procedure InitMainWindow; virtual;
		procedure InitApplication; virtual;
		destructor Done; virtual;
	end;

var Kameleon : PKameleon;
		hKameleon : word;
		hAppMenu : hMenu;

IMPLEMENTATION

uses
		wincrt,
		minilib,
{		wincalc,{}
		tasks;

{*******************************************************
 ***              The Kameleon Main Window           ***
 *******************************************************}
type
	PKameleonMainWindow = ^TKameleonMainWindow;
	TKameleonMainWindow = object(TWindow)
		procedure DefCommandProc(var Msg : TMessage); virtual;
	end;

procedure TKameleonMainWindow.DefCommandProc;
begin
	{$IFDEF fixit}writeln('Message:'+N2Str(Msg.Receiver)+', '+N2Str(Msg.Message)+', '+N2Str(Msg.WParam)+', '+N2Str(Msg.LParam)
							+', '+N2Str(Msg.Result)); {$ENDIF}

	if Msg.Message = wm_command then begin {command - is there a constant for this?}
		if RunTask(DesktopTasks, Msg.WParam) then Msg.Result := 0;
	end;

	inherited DefCommandProc(Msg);
end;

{*************************************************
 ***           KAMELEON APPLICATION OBJECT     ***
 *************************************************}
procedure TKameleon.InitMainWindow;
begin
	MainWindow := New(PKameleonMainWindow, init(nil, 'Kameleon Management System'));
	PWindow(MainWindow)^.Attr.Menu := hAppMenu;{}
{	MainWindow := New(PCalc, init);{}
end;

procedure TKameleon.InitApplication;
begin
	inherited InitApplication;
	RunAllTasks(Startuptasks);{}
end;

destructor TKameleon.Done;
begin
	RunAllTasks(ShutDownTasks);
	inherited Done;
end;


begin
	{$IFDEF fixit} writeln('Initialising winapp.pas...'); {$ENDIF}
	hAppMenu := 0;
	Kameleon := nil;
	hKameleon := 0;
end.

