{********************************************************
 ***                 WINDOWS MESSAGES                 ***
 ********************************************************}

unit WinMsgs;

INTERFACE

uses global, owindows;

const
	{lifted from msgbox (rather than include whole thing}
	mfWarning      = $0000;
	mfError        = $0001;       { Display a Error box }
	mfInformation  = $0002;       { Display an Information Box }
	mfConfirmation = $0003;       { Display a Confirmation Box }
	mfMessage      = $0004;    		{ message only - no buttons}

	mfNoBleep      = $0000;
	mfWakeUpBleep  = $0010;
	mfPayAttentionBleep  = $0020;
	mfWarningBleep = $0030;
	mfErrorBleep   = $0040;

	mfYesButton    = $0100;       { Put a Yes button into the dialog }
	mfNoButton     = $0200;       { Put a No button into the dialog }
	mfOKButton     = $0400;       { Put an OK button into the dialog }
	mfCancelButton = $0800;       { Put a Cancel button into the dialog }

	mfYesNo        = mfYesButton + mfNoButton;
	mfYesNoCancel  = mfYesButton + mfNoButton + mfCancelButton;
																{ Standard Yes, No, Cancel dialog }
	mfOKCancel     = mfOKButton + mfCancelButton;
																{ Standard OK, Cancel dialog }

	{More constants done by me}
	mfButtons1         = $1000;
	mfButtons2         = $2000;
	mfButtons3         = $3000; {All three buttons}
	mfButtons4         = $4000; {All three buttons}
	mfCancelOverRetry = $5000;
	mfOKOverRetry     = $6000;{}
	mfContinue			  = $7000;  {It might not be OK, but you can only go on...}

	{--- Common returned commands - saves using other units}
	cmCancel = Global.cmCancel;
	cmOK 		 = Global.cmOK;
	cmRetry  = Global.cmRetry;
	cmYes		 = Global.cmYes;

{===== VARIOUS BLEEPS =======}
procedure WrongKeyBleep;
procedure WrongFldBleep;
procedure WarningBleep;
procedure WakeUpBleep;   	{Bleep to pay attention for a moment - eg computer busy for a long stretch but needing occ prompts}
procedure PayAttentionBleep; {Something important has just come up}
procedure ErrorBleep;
procedure DoneBleep;  		{Bleep for saying "done job"}

type
	TMessageStr = string[100];

	PProgressBox = ^TProgressBox;
	TProgressBox = object(TWindow)
		constructor Init(const NTitle : TMessageStr; Message : TMessageStr);
		procedure Update(Message : TMessageStr; const NNoDone, NNoTotal : longint);
		procedure Draw; virtual;
		procedure ResetTime;
		procedure Gasp;
	end;

{General Messages}
{function MessageBox(const Title, Message : TMessageStr; const mfOptions : word) : word;

{Create & insert a new progress box}
{function NewMessageBox(const Title, Message : TMessageStr; const mfOptions : word) : PMessageBox; {non-modal}
function NewProgressBox(const Title, Message : TMessageStr) : PProgressBox; {returns it set & inserted in desk top}

{standard shortcut messages}
procedure PauseMessage(const Title, MEssage : TMessageStr);                {Display and Pause for keypress}
procedure ProgramError(const Message : TMessageStr); {shortcut to messagebox}
procedure ProgramWarning(const Message : TMessageStr);        {Noticed but fixed}
function LockMessage(const Message : TMessageStr; const Terminal : byte; const mftype : word) : word; {locked  see files unit}

{---- THinking Messages to keep user informed -------}
var ThinkingAllowed : boolean;
procedure ThinkingOn(const Message : TMEssageStr);
procedure TitledThinkingOn(const Title, Message : TMessageStr);
procedure ThinkingOff;

procedure RecordError(S1,S2,S3 : string);

IMPLEMENTATION

uses win,WinTypes, WinProcs, minilib;

{=========== BLEEPS ==================}
procedure WrongKeyBleep; begin {Sound(300); Delay(100); NoSound; {}end;
procedure WrongFldBleep; begin {Sound(300); Delay(150); NoSound; {}end;
procedure WarningBleep;  begin {Sound(150); Delay(150); NoSound; {}end;
procedure ErrorBleep;    begin {Sound( 50); Delay(100); NoSound; Delay(100); Sound( 50); delay(200); NoSound;{} end;
procedure DoneBleep;     begin {FallingBleep(800,100,10); RisingBleep(100,700,15); NoSound;{} end;
procedure WakeUpBleep;   begin {RisingBleep(200,800,20); NoSound; Delay(50); RisingBleep(200,800,20); NoSound;{} end;
procedure PayAttentionBleep;   begin {RisingBleep(200,800,20); NoSound; Delay(50); RisingBleep(200,800,20); NoSound;{} end;

{standard calls}
procedure ThinkingOn(const Message : TMEssageStr);
begin end;
procedure TitledThinkingOn(const Title, Message : TMessageStr);
begin end;
procedure ThinkingOff;
begin end;

procedure PauseMessage(const Title, MEssage : TMessageStr);                {Display and Pause for keypress}
begin
	MessageBox(0,S2PChar(Message),S2PChar(Title),mb_OK);
end;

procedure ProgramError(const Message : TMessageStr); {shortcut to messagebox}
begin
	MessageBox(0,S2PChar(Message),'ERROR!',mb_OK or mb_IconHand);
end;
procedure ProgramWarning(const Message : TMessageStr);        {Noticed but fixed}
begin
	MessageBox(0,S2PChar(Message),'WARNING',mb_OK or mb_IconExclamation);
end;

function LockMessage;
begin
	MessageBox(0,S2PChar(Message),'LOCKED!',mb_OK or mb_IconExclamation);
	LockMessage := cmCancel;
end;

{Errors}
procedure RecordError(S1,S2,S3 : string);
begin end;

{**********************************************************
 **            PROGRESS BOX                              **
 **********************************************************}
function NewProgressBox;
begin
	NewProgressBox := New(PProgressBox, init(Title, Message));
end;

constructor TProgressBox.Init;
begin
	inherited Init(nil, StrFromPS(Ntitle));
end;

procedure TProgressBox.Update;
begin end;

procedure TProgressBox.Draw;
begin end;

procedure TProgressBox.ResetTime;
begin end;

procedure TProgressBox.Gasp;
begin end;


end.

