
{*******************************************************}
{                                                       }
{       Turbo Pascal for Windows Run-time Library       }
{       Windows API Interface Unit                      }
{                                                       }
{       Copyright (c) 1991 Borland International        }
{                                                       }
{*******************************************************}

unit WinProcs;

interface

uses WinTypes;

function AccessResource(Instance, ResInfo: THandle): Integer;
function AddAtom(Str: PChar): TAtom;
function AddFontResource(Filename: PChar): Integer;
procedure AdjustWindowRect(var Rect: TRect; Style: LongInt; Menu: Bool);
procedure AdjustWindowRectEx(var Rect: TRect; Style: LongInt; Menu: Bool;
  ExtStyle: LongInt);
function AllocCStoDSAlias(Selector: Word): Word;
function AllocDStoCSAlias(Selector: Word): Word;
function AllocResource(Instance: THandle; ResInfo: THandle;
  Size: LongInt): THandle;
function AllocSelector(Selector: Word): Word;
procedure AnimatePalette(Palette: HPalette; StartIndex,	NumEntires: Word; 
  var PaletteColors);
function AnsiLower(Str: PChar): PChar;
function AnsiLowerBuff(Str: PChar; Length: Word): Word;
function AnsiNext(CurrentChar: PChar): PChar;
function AnsiPrev(Start, CurrentChar: PChar): PChar;
function AnsiToOem(AnsiStr, OemStr: PChar): Integer;
procedure AnsiToOemBuff(AnsiStr, OemStr: PChar; Length: Integer);
function AnsiUpper(Str: PChar): PChar;
function AnsiUpperBuff(Str: PChar; Length: Word): Word;
function AnyPopup: Bool;
function AppendMenu(Menu: HMenu; Flags, IDNewItem: Word;
  NewItem: PChar): Bool;
function Arc(DC: HDC; X1, Y1, X2, Y2, X3, Y3, X4, Y4: Integer): Bool;
function ArrangeIconicWindows(Wnd: HWnd): Word;
function BeginDeferWindowPos(NumWindows: Integer): THandle;
function BeginPaint(Wnd: HWnd; var Paint: TPaintStruct): HDC;
function BitBlt(DestDC: HDC; X, Y, nWidth, Height: Integer; SrcDC: HDC; 
  XSrc, YSrc: Integer; Rop: LongInt): Bool;
procedure BringWindowToTop(Wnd: HWnd);
function BuildCommDCB(Def: PChar; var DCB: TDCB): Integer;
function CallMsgFilter(var Msg: TMsg; Code: Integer): Bool;
function CallWindowProc(PrevWndFunc: TFarProc; Wnd: HWnd; Msg, wParam: Word; 
  lParam: LongInt): LongInt;
function Catch(var CatchBuf: TCatchBuf): Integer;
function ChangeClipboardChain(Wnd, WndNext: HWnd): Bool;
function ChangeMenu(A: HMenu; B: Word; C: PChar; D: Word; E: Word): Bool;
function ChangeSelector(DestSelector, SourceSelector: Word): Word;
procedure CheckDlgButton(Dlg: HWnd; IDButton: Integer; Check: Word);
function CheckMenuItem(Menu: HMenu; IDCheckItem, Check: Word): Bool;
procedure CheckRadioButton(Dlg: HWnd; IDFirstButton, IDLastButton,
  IDCheckButton: Integer);
function ChildWindowFromPoint(Wnd: HWnd; Point: TPoint): HWnd;
function Chord(DC: HDC; X1, Y1, X2, Y2, X3, Y3, X4, Y4: Integer): Bool;
function ClearCommBreak(Cid: Integer): Integer;
procedure ClientToScreen(Wnd: HWnd; var Point: TPoint);
procedure ClipCursor(Rect: PRect);
function CloseClipboard: Bool;
function CloseComm(Cid: Integer): Integer;
function CloseMetaFile(DC: THandle): THandle;
procedure CloseSound;
procedure CloseWindow(Wnd: HWnd);
function CombineRgn(DestRgn, SrcRgn1, SrcRgn2: HRgn; 
  CombineMode: Integer): Integer;
function CopyMetaFile(SrcMetaFile: THandle; FileName: PChar): THandle;
procedure CopyRect(var DestRect, SourceRect: TRect);
function CountClipboardFormats: Integer;
function CountVoiceNotes(Voice: Integer): Integer;
function CreateBitmap(Width, Height: Integer; Planes, BitCount: Byte;
  Bits: Pointer): HBitmap;
function CreateBitmapIndirect(var Bitmap: TBitmap): HBitmap;
function CreateBrushIndirect(var LogBrush: TLogBrush): HBrush;
procedure CreateCaret(Wnd: HWnd; Bitmap: HBitmap;
  Width, Height: Integer);
function CreateCompatibleBitmap(DC: HDC; Width, Height: Integer): HBitmap;
function CreateCompatibleDC(DC: HDC): HDC;
function CreateCursor(Instance: THandle; Xhotspot, Yhotspot: Integer;
  Width, Height: Integer; ANDbitPlane, XORbitPlane: Pointer): HCursor;
function CreateDC(DriverName, DeviceName, OutPut: PChar;
  InitData: Pointer): HDC;
function CreateDialog(Instance: THandle; TemplateName: PChar;
  WndParent: HWnd; DialogFunc: TFarProc): HWnd;
function CreateDialogIndirect(Instance: THandle; DialogTemplate: Pointer;
  WndParent: HWnd; DialogFunc: TFarProc): HWnd;
function CreateDialogIndirectParam(Instance: THandle;
  DialogTemplate: Pointer; WndParent: HWnd; DialogFunc: TFarProc;
  InitParam: LongInt): HWnd;
function CreateDialogParam(Instance: THandle; TemplateName: PChar;
  WndParent: HWnd; DialogFunc: TFarProc; InitParam: LongInt): HWnd;
function CreateDIBitmap(DC: HDC; var InfoHeader: TBitmapInfoHeader;
  dwUsage: LongInt; InitBits: PChar; var InitInfo: TBitmapInfo;
  wUsage: Word): HBitmap;
function CreateDIBPatternBrush(PackedDIB: THandle; Usage: Word): HBrush;
function CreateDiscardableBitmap(DC: HDC; Width, Height: Integer): HBitmap;
function CreateEllipticRgn(X1, Y1, X2, Y2: Integer): HRgn;
function CreateEllipticRgnIndirect(var Rect: TRect): HRgn;
function CreateFont(Height, Width, Escapement, Orientation,
  Weight: Integer; Italic, Underline, StrikeOut, CharSet, OutputPrecision, 
  ClipPrecision, Quality, PitchAndFamily: Byte;	Facename: PChar): HFont;
function CreateFontIndirect(var LogFont: TLogFont): HFont;
function CreateHatchBrush(Index: Integer; Color: TColorRef): HBrush;
function CreateIC(DriverName, DeviceName, Output: PChar;
  InitData: Pointer): HDC;
function CreateIcon(Instance: THandle; Width, Height: Integer;
  Planes, BitsPixel: Byte; ANDbits, XORbits: Pointer): HIcon;
function CreateMenu: HMenu;
function CreateMetaFile(Filename: PChar): THandle;
function CreatePalette(var LogPalette: TLogPalette): HPalette;
function CreatePatternBrush(Bitmap: HBitmap): HBrush;
function CreatePen(PenStyle, Width: Integer; Color: TColorRef): HPen;
function CreatePenIndirect(var LogPen: TLogPen): HPen;
function CreatePolygonRgn(var Points; Count, PolyFillMode: Integer): HRgn;
function CreatePolyPolygonRgn(var Points; var PolyCounts; Count, 
  PolyFillMode: Integer): HRgn;
function CreatePopupMenu: HMenu;
function CreateRectRgn(X1, Y1, X2, Y2: Integer): HRgn;
function CreateRectRgnIndirect(var Rect: TRect): HRgn;
function CreateRoundRectRgn(X1, Y1, X2, Y2, X3, Y3: Integer): HRgn;
function CreateSolidBrush(Color: TColorRef): HBrush;
function CreateWindow(ClassName, WindowName: PChar; Style: LongInt;
  X, Y, Width, Height: Integer; WndParent: HWnd; Menu: HMenu;
  Instance: THandle; Param: Pointer): HWnd;
function CreateWindowEx(ExStyle: LongInt; ClassName, WindowName: PChar;
  Style: LongInt; X, Y, Width, Height: Integer; WndParent: HWnd;
  Menu: HMenu; Instance: THandle; Param: Pointer): HWnd;
procedure DebugBreak;
function DefDlgProc(Dlg: HWnd; Msg, wParam: Word; lParam: LongInt): LongInt;
function DeferWindowPos(WinPosInfo: THandle; Wnd, WndInsertAfter: HWnd;
  x, y, cx, cy: Integer; Flags: Word): THandle;
function DefFrameProc(Wnd, WndMDIClient: HWnd; Msg, wParam: Word; 
  lParam: LongInt): LongInt;
function DefHookProc(Code: Integer; wParam: Word; lParam: LongInt;
  lpfnNextHook: TFarProc): LongInt;
function DefineHandleTable(Offset: Word): Bool;
function DefMDIChildProc(Wnd: HWnd; Msg, wParam: Word;
  lParam: LongInt): LongInt;
function DefWindowProc(Wnd: HWnd; Msg, wParam: Word; 
  lParam: LongInt): LongInt;
function DeleteAtom(AnAtom: TAtom): TAtom;
function DeleteDC(DC: HDC): Bool;
function DeleteMenu(Menu: HMenu; Position, Flags: Word): Bool;
function DeleteMetaFile(MF: THandle): Bool;
function DeleteObject(Handle: THandle): Bool;
procedure DestroyCaret;
function DestroyCursor(Cursor: HCursor): Bool;
function DestroyIcon(Icon: HIcon): Bool;
function DestroyMenu(Menu: HMenu): Bool;
function DestroyWindow(Wnd: HWnd): Bool;
function DialogBox(Instance: THandle; Templatename: PChar;
  WndParent: HWnd; DialogFunc: TFarProc): Integer;
function DialogBoxIndirect(Instance, DialogTemplate: THandle; WndParent: HWnd; 
  DialogFunc: TFarProc): Integer;
function DialogBoxIndirectParam(Instance, DialogTemplate: THandle;
  WndParent: HWnd; DialogFunc: TFarProc; InitParam: LongInt): Integer;
function DialogBoxParam(Instance: THandle; TemplateName: PChar;
  WndParent: HWnd; DialogFunc: TFarProc; InitParam: LongInt): Integer;
function DispatchMessage(var Msg: TMsg): LongInt;
function DlgDirList(Dlg: HWnd; PathSpec: PChar; IDListBox,
  IDStaticPath: Integer; Filetype: Word): Integer;
function DlgDirListComboBox(Dlg: HWnd; PathSpec: PChar; IDComboBox,
 IDStaticText: Integer; Filetype: Word): Integer;
function DlgDirSelect(Dlg: HWnd; Str: PChar; IDListBox: Integer): Bool;
function DlgDirSelectComboBox(Dlg: HWnd; Str: PChar;
  IDComboBox: Integer): Bool;
procedure DOS3Call;
function DPtoLP(DC: HDC; var Points; Count: Integer): Bool;
procedure DrawFocusRect(DC: HDC; var Rect: TRect);
function DrawIcon(DC: HDC; X, Y: Integer; Icon: HIcon): Bool;
procedure DrawMenuBar(Wnd: HWnd);
function DrawText(DC: HDC; Str: PChar; Count: Integer; var Rect: TRect;
  Format: Word): Integer;
function Ellipse(DC: HDC; X1, Y1, X2, Y2: Integer): Bool;
function EmptyClipboard: Bool;
function EnableHardwareInput(EnableInput: Bool): Bool;
function EnableMenuItem(Menu: HMenu; IDEnableItem: Word;
  Enable: Word): Bool;
function EnableWindow(Wnd: HWnd; Enable: Bool): Bool;
procedure EndDeferWindowPos(WinPosInfo: THandle);
procedure EndDialog(Dlg: HWnd; Result: Integer);
procedure EndPaint(Wnd: HWnd; var Paint: TPaintStruct);
function EnumChildWindows(WndParent: HWnd; EnumFunc: TFarProc;
  lParam: LongInt): Bool;
function EnumClipboardFormats(Format: Word): Word;
function EnumFonts(DC: HDC; Facename: PChar; FontFunc: TFarProc;
  Data: Pointer): Integer;
function EnumMetaFile(DC: HDC; MF: THandle; CallbackFunc: TFarProc;
  ClientData: Pointer): Bool;
function EnumObjects(DC: HDC; ObjectType: Integer; ObjectFunc: TFarProc;
  Data: Pointer): Integer;
function EnumProps(Wnd: HWnd; EnumFunc: TFarProc): Integer;
function EnumTaskWindows(Task: THandle; EnumFunc: TFarProc;
  lParam: LongInt): Bool;
function EnumWindows(EnumFunc: TFarProc; lParam: LongInt): Bool;
function EqualRect(var Rect1, Rect2: TRect): Bool;
function EqualRgn(SrcRgn1, SrcRgn2: HRgn): Bool;
function Escape(DC: HDC; Escape, Count: Integer; InData,
  OutData: Pointer): Integer;
function EscapeCommFunction(Cid: Integer; Func: Integer): LongInt;
function ExcludeClipRect(DC: HDC; X1, Y1, X2, Y2: Integer): Integer;
function ExcludeUpdateRgn(DC: HDC; Wnd: HWnd): Integer;
function ExitWindows(Reserved: LongInt; ReturnCode: Word): Bool;
function ExtFloodFill(DC: HDC; X, Y: Integer; Color: TColorRef;
  FillType: Word): Bool;
function ExtTextOut(DC: HDC; X, Y: Integer; Options: Word;
  Rect: PRect; Str: PChar; Count: Word; Dx: PInteger): Bool;
procedure FatalAppExit(Action: Word; MessageText: PChar);
procedure FatalExit(Code: Integer);
function FillRect(DC: HDC; var Rect: TRect; Brush: HBrush): Integer;
function FillRgn(DC: HDC; Rgn: HRgn; Brush: HBrush): Bool;
function FindAtom(Str: PChar): TAtom;
function FindResource(Instance: THandle; Name, ResType: PChar): THandle;
function FindWindow(Classname, WindowName: PChar): HWnd;
function FlashWindow(Wnd: HWnd; Invert: Bool): Bool;
function FloodFill(DC: HDC; X, Y: Integer; Color: TColorRef): Bool;
function FlushComm(Cid, Queue: Integer): Integer;
procedure FrameRect(DC: HDC; var Rect: TRect; Brush: HBrush);
function FrameRgn(DC: HDC; Rgn: HRgn; Brush: HBrush; Width,
  Height: Integer): Bool;
procedure FreeLibrary(LibModule: THandle);
function FreeModule(Module: THandle): Bool;
procedure FreeProcInstance(Proc: TFarProc);
function FreeResource(ResData: THandle): Bool;
function FreeSelector(Selector: Word): Word;
function GetActiveWindow: HWnd;
function GetAspectRatioFilter(DC: HDC): LongInt;
function GetAsyncKeyState(Key: Integer): Integer;
function GetAtomHandle(AnAtom: TAtom): THandle;
function GetAtomName(AnAtom: TAtom; Buffer: PChar; Size: Integer): Word;
function GetBitmapBits(Bitmap: HBitmap; Count: LongInt; 
  Bits: Pointer): LongInt;
function GetBitmapDimension(Bitmap: HBitmap): LongInt;
function GetBkColor(DC: HDC): LongInt;
function GetBkMode(DC: HDC): Integer;
function GetBrushOrg(DC: HDC): LongInt;
function GetCapture: HWnd;
function GetCaretBlinkTime: Word;
procedure GetCaretPos(var Point: TPoint);
function GetCharWidth(DC: HDC; FirstChar, LastChar: Word;
  var Buffer): Bool;
function GetClassInfo(Instance: THandle; ClassInfo: PChar;
  var WndClass: TWndClass): Bool;
function GetClassLong(Wnd: HWnd; Index: Integer): LongInt;
function GetClassName(Wnd: HWnd; ClassName: PChar; 
  MaxCount: Integer): Integer;
function GetClassWord(Wnd: HWnd; Index: Integer): Word;
procedure GetClientRect(Wnd: HWnd; var Rect: TRect);
function GetClipboardData(Format: Word): THandle;
function GetClipboardFormatName(Format: Word; FormatName: PChar; 
  MaxCount: Integer): Integer;
function GetClipboardOwner: HWnd;
function GetClipboardViewer: HWnd;
function GetClipBox(DC: HDC; var Rect: TRect): Integer;
function GetCodeHandle(Proc: TFarProc): THandle;
procedure GetCodeInfo(Proc: TFarProc; SegInfo: Pointer);
function GetCommError(Cid: Integer; var Stat: TComStat): Integer;
function GetCommEventMask(Cid, EvtMask: Integer): Word;
function GetCommState(Cid: Integer; var DCB: TDCB): Integer;
function GetCurrentPDB: Word;
function GetCurrentPosition(DC: HDC): LongInt;
function GetCurrentTask: THandle;
function GetCurrentTime: LongInt;
procedure GetCursorPos(var Point: TPoint);
function GetDC(Wnd: HWnd): HDC;
function GetDCOrg(DC: HDC): LongInt;
function GetDesktopHwnd: HWnd;
function GetDesktopWindow: HWnd;
function GetDeviceCaps(DC: HDC; Index: Integer): Integer;
function GetDialogBaseUnits: LongInt;
function GetDIBits(DC: HDC; Bitmap: HBitmap; StartScan, NumScans: Word; 
  Bits: Pointer; var BitInfo: TBitmapInfo; Usage: Word): Integer;
function GetDlgCtrlID(Wnd: HWnd): Integer;
function GetDlgItem(Dlg: HWnd; IDDlgItem: Integer): HWnd;
function GetDlgItemInt(Dlg: HWnd; IDDlgItem: Integer;
  Translate: PBool; Signed: Bool): Word;
function GetDlgItemText(Dlg: HWnd; IDDlgItem: Integer; Str: PChar;
  MaxCount: Integer): Integer;
function GetDOSEnvironment: PChar;
function GetDoubleClickTime: Word;
function GetDriveType(Drive: Integer): Word;
function GetEnvironment(PortName: PChar; Environ: Pointer;
  MaxCount: Word): Integer;
function GetFocus: HWnd;
function GetFreeSpace(Flag: Word): LongInt;
function GetInputState: Bool;
function GetInstanceData(Instance: THandle; Data: Word; 
  Count: Integer): Integer;
function GetKBCodePage: Integer;
procedure GetKeyboardState(var KeyState: TKeyboardState);
function GetKeyboardType(TypeFlag: Integer): Integer;
function GetKeyNameText(lParam: LongInt; Buffer: PChar; 
  Size: Integer): Integer;
function GetKeyState(VirtKey: Integer): Integer;
function GetLastActivePopup(Owner: HWnd): HWnd;
function GetMapMode(DC: HDC): Integer;
function GetMenu(Wnd: HWnd): HMenu;
function GetMenuCheckMarkDimensions: LongInt;
function GetMenuItemCount(Menu: HMenu): Word;
function GetMenuItemID(Menu: HMenu; Pos: Integer): Word;
function GetMenuState(Menu: HMenu; Id, Flags: Word): Word;
function GetMenuString(Menu: HMenu; IDItem: Word; Str: PChar; 
  MaxCount: Integer; Flag: Word): Integer;
function GetMessage(var Msg: TMsg; Wnd: HWnd; MsgFilterMin,
  MsgFilterMax: Word): Bool;
function GetMessagePos: LongInt;
function GetMessageTime: LongInt;
function GetMetaFile(Filename: PChar): THandle;
function GetMetaFileBits(MF: THandle): THandle;
function GetModuleFileName(Module: THandle; Filename: PChar; Size: Integer): Integer;
function GetModuleHandle(ModuleName: PChar): THandle;
function GetModuleUsage(Module: THandle): Integer;
function GetNearestColor(DC: HDC; Color: TColorRef): TColorRef;
function GetNearestPaletteIndex(Palette: HPalette; Color: TColorRef): Word;
function GetNextDlgGroupItem(Dlg, Ctl: HWnd; Previous: Bool): HWnd;
function GetNextDlgTabItem(Dlg, Ctl: HWnd; Previous: Bool): HWnd;
function GetNextWindow(Wnd: HWnd; Flag: Word): HWnd;
function GetNumTasks: Word;
function GetObject(hObject: THandle; Count: Integer;
  lpObject: Pointer): Integer;
function GetPaletteEntries(Palette: HPalette; StartIndex, NumEntries: Word;
  var PaletteEntries): Word;
function GetParent(Wnd: HWnd): HWnd;
function GetPixel(DC: HDC; X, Y: Integer): TColorRef;
function GetPolyFillMode(DC: HDC): Integer;
function GetPriorityClipboardFormat(var PriorityList;
  Count: Integer): Integer;
function GetPrivateProfileInt(ApplicationName, KeyName: PChar; 
  Default: Integer; FileName: PChar): Word;
function GetPrivateProfileString(ApplicationName, KeyName: PChar; 
  Default: PChar; ReturnedString: PChar; Size: Integer; 
  FileName: PChar): Integer;
function GetProcAddress(Module: THandle; ProcName: PChar): TFarProc;
function GetProfileInt(AppName, KeyName: PChar; 
  Default: Integer): Word;
function GetProfileString(AppName, KeyName, Default, ReturnedString: PChar; 
  Size: Integer): Integer;
function GetProp(Wnd: HWnd; Str: PChar): THandle;
function GetRgnBox(Rgn: HRgn; var Rect: TRect): Integer;
function GetROP2(DC: HDC): Integer;
function GetScrollPos(Wnd: HWnd; Bar: Integer): Integer;
procedure GetScrollRange(Wnd: HWnd; Bar: Integer; var MinPos,
  MaxPos: Integer);
function GetStockObject(Index: Integer): THandle;
function GetStretchBltMode(DC: HDC): Integer;
function GetSubMenu(Menu: HMenu; Pos: Integer): HMenu;
function GetSysColor(Index: Integer): TColorRef;
function GetSysModalWindow: HWnd;
function GetSystemDirectory(Buffer: PChar; Size: Word): Word;
function GetSystemMenu(Wnd: HWnd; bRevert: Bool): HMenu;
function GetSystemMetrics(Index: Integer): Integer;
function GetSystemPaletteEntries(DC: HDC; StartIndex, NumEntries: Word;
  var PaletteEntries): Word;
function GetSystemPaletteUse(DC: HDC): Word;
function GetTabbedTextExtent(DC: HDC; Str: PChar; Count: Integer;
  TabPostions: Integer; var TabStopPostions): LongInt;
function GetTempDrive(DriveLetter: Char): Char;
function GetTempFileName(DriveLetter: Char; PrefixString: PChar;
  Unique: Word; TempFileName: PChar): Integer;
function GetTextAlign(DC: HDC): Word;
function GetTextCharacterExtra(DC: HDC): Integer;
function GetTextColor(DC: HDC): TColorRef;
function GetTextExtent(DC: HDC; Str: PChar; Count: Integer): LongInt;
function GetTextFace(DC: HDC; Count: Integer; Facename: PChar): Integer;
function GetTextMetrics(DC: HDC; var Metrics: TTextMetric): Bool;
function GetThresholdEvent: PInteger;
function GetThresholdStatus: Integer;
function GetTickCount: LongInt;
function GetTopWindow(Wnd: HWnd): HWnd;
function GetUpdateRect(Wnd: HWnd; var Rect: TRect; Erase: Bool): Bool;
function GetUpdateRgn(Wnd: HWnd; Rgn: HRgn; Erase: Bool): Integer;
function GetVersion: LongInt;
function GetViewportExt(DC: HDC): LongInt;
function GetViewportOrg(DC: HDC): LongInt;
function GetWindow(Wnd: HWnd; Cmd: Word): HWnd;
function GetWindowDC(Wnd: HWnd): HDC;
function GetWindowExt(DC: HDC): LongInt;
function GetWindowLong(Wnd: HWnd; Index: Integer): LongInt;
function GetWindowOrg(DC: HDC): LongInt;
procedure GetWindowRect(Wnd: HWnd; var Rect: TRect);
function GetWindowsDirectory(Buffer: PChar; Size: Word): Word;
function GetWindowTask(Wnd: HWnd): THandle;
function GetWindowText(Wnd: HWnd; Str: PChar; 
  MaxCount: Integer): Integer;
function GetWindowTextLength(Wnd: HWnd): Integer;
function GetWindowWord(Wnd: HWnd; Index: Integer): Word;
function GetWinFlags: LongInt;
function GlobalAddAtom(Str: PChar): TAtom;
function GlobalAlloc(Flags: Word; Bytes: LongInt): THandle;
function GlobalCompact(MinFree: LongInt): LongInt;
function GlobalDeleteAtom(AnAtom: TAtom): TAtom;
function GlobalDiscard(Mem: THandle): THandle;
function GlobalDosAlloc(Bytes: LongInt): LongInt;
function GlobalDosFree(Selector: Word): Word;
function GlobalFindAtom(Str: PChar): TAtom;
procedure GlobalFix(Mem: THandle);
function GlobalFlags(Mem: THandle): Word;
function GlobalFree(Mem: THandle): THandle;
function GlobalGetAtomName(AnAtom: TAtom; Buffer: PChar; Size: Integer): Word;
function GlobalHandle(Mem: Word): LongInt;
function GlobalLock(Mem: THandle): Pointer;
function GlobalLRUNewest(Mem: THandle): THandle;
function GlobalLRUOldest(Mem: THandle): THandle;
procedure GlobalNotify(NotifyProc: TFarProc);
function GlobalPageLock(Selector: THandle): Word;
function GlobalPageUnlock(Selector: THandle): Word;
function GlobalReAlloc(Mem: THandle; Bytes: LongInt; Flags: Word): THandle;
function GlobalSize(Mem: THandle): LongInt;
function GlobalUnfix(Mem: THandle): Bool;
function GlobalUnlock(Mem: THandle): Bool;
function GlobalUnWire(Mem: THandle): Bool;
function GlobalWire(Mem: THandle): Pointer;
function GrayString(DC: HDC; Brush: HBrush; OutputFunc: TFarProc; 
  Data: LongInt; Count, X, Y, Width, Height: Integer): Bool;
procedure HideCaret(Wnd: HWnd);
function HiliteMenuItem(Wnd: HWnd; Menu: HMenu; IDHilite, 
  Hilite: Word): Bool;
procedure InflateRect(var Rect: TRect; X, Y: Integer);
function InitAtomTable(Size: Integer): Bool;
function InSendMessage: Bool;
function InsertMenu(Menu: HMenu; Position, Flags, IDNewItem: Word; 
  NewItem: PChar): Bool;
function IntersectClipRect(DC: HDC; X1, Y1, X2, Y2: Integer): Integer;
function IntersectRect(var DestRect, Src1Rect, Src2Rect: TRect): Integer;
procedure InvalidateRect(Wnd: HWnd; Rect: PRect; Erase: Bool);
procedure InvalidateRgn(Wnd: HWnd; Rgn: HRgn; Erase: Bool);
procedure InvertRect(DC: HDC; var Rect: TRect);
function InvertRgn(DC: HDC; Rgn: HRgn): Bool;
function IsCharAlpha(Chr: Char): Bool;
function IsCharAlphaNumeric(Chr: Char): Bool;
function IsCharLower(Chr: Char): Bool;
function IsCharUpper(Chr: Char): Bool;
function IsChild(WndParent, Wnd: HWnd): Bool;
function IsClipboardFormatAvailable(Format: Word): Bool;
function IsDialogMessage(Dlg: HWnd; var Msg: TMsg): Bool;
function IsDlgButtonChecked(Wnd: HWnd; IDButton: Integer): Word;
function IsIconic(Wnd: HWnd): Bool;
function IsRectEmpty(var Rect: TRect): Bool;
function IsTwoByteCharPrefix(Chr: Char): Bool;
function IsWindow(Wnd: HWnd): Bool;
function IsWindowEnabled(Wnd: HWnd): Bool;
function IsWindowVisible(Wnd: HWnd): Bool;
function IsZoomed(Wnd: HWnd): Bool;
function KillTimer(Wnd: HWnd; IDEvent: Integer): Bool;
procedure LimitEmsPages(Kbytes: LongInt);
procedure LineDDA(X1, Y1, X2, Y2: Integer; LineFunc: TFarProc; 
  Data: Pointer);
function LineTo(DC: HDC; X, Y: Integer): Bool;
function LoadAccelerators(Instance: THandle; TableName: PChar): THandle;
function LoadBitmap(Instance: THandle; BitmapName: PChar): HBitmap;
function LoadCursor(Instance: THandle; CursorName: PChar): HCursor;
function LoadIcon(Instance: THandle; IconName: PChar): HIcon;
function LoadLibrary(LibFileName: PChar): THandle;
function LoadMenu(Instance: THandle; MenuName: PChar): HMenu;
function LoadMenuIndirect(MenuTemplate: Pointer): HMenu;
function LoadModule(ModuleName: PChar; ParameterBlock: Pointer): THandle;
function LoadResource(Instance: THandle; ResInfo: THandle): THandle;
function LoadString(Instance: THandle; ID: Word; Buffer: PChar; 
  BufferMax: Integer): Integer;
function LocalAlloc(Flags, Bytes: Word): THandle;
function LocalCompact(MinFree: Word): Word;
function LocalDiscard(Mem: THandle): THandle; 
function LocalFlags(Mem: THandle): Word;
function LocalFree(Mem: THandle): THandle;
function LocalHandle(Mem: Word): THandle;
function LocalInit(Segment, Start, EndPos: Word): Bool;
function LocalLock(Mem: THandle): Pointer;
function LocalNotify(NotifyProc: TFarProc): TFarProc;
function LocalReAlloc(Mem: THandle; Bytes, Flags: Word): THandle;
function LocalShrink(Seg: THandle; Size: Word): Word;
function LocalSize(Mem: THandle): Word;
function LocalUnlock(Mem: THandle): Bool;
function LockData(Dummy: Integer): THandle;
function LockResource(ResData: THandle): Pointer;
function LockSegment(Segment: Word): THandle;
function LPtoDP(DC: HDC; var Points; Count: Integer): Bool;
function lstrcat(Str1, Str2: PChar): PChar;
function lstrcmp(Str1, Str2: PChar): Integer;
function lstrcmpi(Str1, Str2: PChar): Integer;
function lstrcpy(Str1, Str2: PChar): PChar;
function lstrlen(Str: PChar): Integer;
function MakeProcInstance(Proc: TFarProc; Instance: THandle): TFarProc;
procedure MapDialogRect(Dlg: HWnd; var Rect: TRect);
function MapVirtualKey(Code, MapType: Word): Word;
procedure MessageBeep(BeepType: Word);
function MessageBox(WndParent: HWnd; Txt, Caption: PChar; 
  TextType: Word): Integer;
function ModifyMenu(Menu: HMenu; Position, Flags, IDNewItem: Word; 
  NewItem: PChar): Bool;
function MoveTo(DC: HDC; X, Y: Integer): LongInt;
procedure MoveWindow(Wnd: HWnd; X, Y, Width, Height: Integer; Repaint: Bool);
function MulDiv(Number: Integer; Numerator: Integer; 
  Denominator: Integer): Integer;
procedure NetBIOSCall;
function OemKeyScan(OemChar: Word): LongInt;
function OemToAnsi(OemStr, AnsiStr: PChar): Bool;
procedure OemToAnsiBuff(OemStr, AnsiStr: PChar; Length: Integer);
function OffsetClipRgn(DC: HDC; X, Y: Integer): Integer;
procedure OffsetRect(var Rect: TRect; X, Y: Integer);
function OffsetRgn(Rgn: HRgn; X, Y: Integer): Integer;
function OffsetViewportOrg(DC: HDC; X, Y: Integer): LongInt;
function OffsetWindowOrg(DC: HDC; X, Y: Integer): LongInt;
function OpenClipboard(Wnd: HWnd): Bool;
function OpenComm(ComName: PChar; InQueue, OutQueue: Word): Integer;
function OpenFile(FileName: PChar; var ReOpenBuff: TOfStruct;
  Style: Word): Integer;
function OpenIcon(Wnd: HWnd): Bool;
function OpenSound: Integer;
procedure OutputDebugString(OutputString: PChar);
function PaintRgn(DC: HDC; Rgn: HRgn): Bool;
function PatBlt(DC: HDC; X, Y, Width, Height: Integer; Rop: LongInt): Bool;
function PeekMessage(var Msg: TMsg; Wnd: HWnd; MsgFilterMin,
  MsgFilterMax: Word; RemoveMsg: Word): Bool;
function Pie(DC: HDC; X1, Y1, X2, Y2, X3, Y3, X4, Y4: Integer): Bool;
function PlayMetaFile(DC: HDC; MF: THandle): Bool;
procedure PlayMetaFileRecord(DC: HDC; var HandleTable: THandleTable;
  var MetaRecord: TMetaRecord; Handles: Word);
function Polygon(DC: HDC; var Points; Count: Integer): Bool;
function Polyline(DC: HDC; var Points; Count: Integer): Bool;
function PolyPolygon(DC: HDC; var Points; var PolyCounts;
  Count: Integer): Bool;
function PostAppMessage(Task: THandle; Msg, wParam: Word; 
  lParam: LongInt): Bool;
function PostMessage(Wnd: HWnd; Msg, wParam: Word; lParam: LongInt): Bool;
procedure PostQuitMessage(ExitCode: Integer);
function PtInRect(var Rect: TRect; Point: TPoint): Bool;
function PtInRegion(Rgn: HRgn; X, Y: Integer): Bool;
function PtVisible(DC: HDC; X, Y: Integer): Bool;
function ReadComm(Cid: Integer; Buf: PChar; Size: Integer): Integer;
function RealizePalette(DC: HDC): Word;
function Rectangle(DC: HDC; X1, Y1, X2, Y2: Integer): Bool;
function RectInRegion(Rgn: HRgn; var Rect: TRect): Bool;
function RectVisible(DC: HDC; var Rect: TRect): Bool;
function RegisterClass(var WndClass: TWndClass): Bool;
function RegisterClipboardFormat(FormatName: PChar): Word;
function RegisterWindowMessage(Str: PChar): Word;
procedure ReleaseCapture;
function ReleaseDC(Wnd: HWnd; DC: HDC): Integer;
function RemoveFontResource(Filename: PChar): Bool;
function RemoveMenu(Menu: HMenu; Position, Flags: Word): Bool;
function RemoveProp(Wnd: HWnd; Str: PChar): THandle;
procedure ReplyMessage(Reply: LongInt);
function ResizePalette(Palette: HPalette; NumEntries: Word): Bool;
function RestoreDC(DC: HDC; SavedDC: Integer): Bool;
function RoundRect(DC: HDC; X1, Y1, X2, Y2, X3, Y3: Integer): Bool;
function SaveDC(DC: HDC): Integer;
function ScaleViewportExt(DC: HDC; Xnum, Xdenom, Ynum,
  Ydenom: Integer): LongInt;
function ScaleWindowExt(DC: HDC; Xnum, Xdenom, Ynum, Ydenom: Integer): LongInt;
procedure ScreenToClient(Wnd: HWnd; var Point: TPoint);
function ScrollDC(DC: HDC; dx, dy: Integer; var Scroll, Clip: TRect;
  UpdateRgn: HRgn; UpdateRect: PRect): Bool;
procedure ScrollWindow(Wnd: HWnd; XAmount, YAmount: Integer; Rect: PRect;
  ClipRect: PRect);
function SelectClipRgn(DC: HDC; Rgn: HRgn): Integer;
function SelectObject(DC: HDC; hObject: THandle): THandle;
function SelectPalette(DC: HDC; Palette: HPalette; 
  ForceBackground: Bool): HPalette;
function SendDlgItemMessage(Dlg: HWnd; IDDlgItem: Integer; Msg, wParam: Word; 
  lParam: LongInt): LongInt;
function SendMessage(Wnd: HWnd; Msg, wParam: Word; lParam: LongInt): LongInt;
function SetActiveWindow(Wnd: HWnd): HWnd;
function SetBitmapBits(Bitmap: HBitmap; Count: LongInt; Bits: Pointer): LongInt;
function SetBitmapDimension(Bitmap: HBitmap; X, Y: Integer): LongInt;
function SetBkColor(DC: HDC; Color: TColorRef): TColorRef;
function SetBkMode(DC: HDC; BkMode: Integer): Integer;
function SetBrushOrg(DC: HDC; X, Y: Integer): LongInt;
function SetCapture(Wnd: HWnd): HWnd;
procedure SetCaretBlinkTime(MSeconds: Word);
procedure SetCaretPos(X, Y: Integer);
function SetClassLong(Wnd: HWnd; Index: Integer; NewLong: LongInt): LongInt;
function SetClassWord(Wnd: HWnd; Index: Integer; NewWord: Word): Word;
function SetClipboardData(Format: Word; Mem: THandle): THandle;
function SetClipboardViewer(Wnd: HWnd): HWnd;
function SetCommBreak(Cid: Integer): Integer;
function SetCommEventMask(Cid: Integer; EvtMask: Word): PWord;
function SetCommState(var DCB: TDCB): Integer;
function SetCursor(Cursor: HCursor): HCursor;
procedure SetCursorPos(X, Y: Integer);
function SetDIBits(DC: HDC; Bitmap: THandle; StartScan, NumScans: Word;
  Bits: Pointer; var BitsInfo: TBitmapInfo; Usage: Word): Integer;
function SetDIBitsToDevice(DC: HDC; DestX, DestY, Width, Height, SrcX, SrcY,
  nStartScan, NumScans: Word; Bits: Pointer; var BitsInfo: TBitmapInfo;
  Usage: Word): Integer;
procedure SetDlgItemInt(Dlg: HWnd; IDDlgItem: Integer; Value: Word;
  Signed: Bool);
procedure SetDlgItemText(Dlg: HWnd; IDDlgItem: Integer; Str: PChar);
procedure SetDoubleClickTime(Count: Word);
function SetEnvironment(PortName: PChar; Environ: Pointer; 
  Count: Word): Integer;
function SetErrorMode(Mode: Word): Word;
function SetFocus(Wnd: HWnd): HWnd;
function SetHandleCount(Number: Word): Word;
procedure SetKeyboardState(var KeyState: TKeyboardState);
function SetMapMode(DC: HDC; MapMode: Integer): Integer;
function SetMapperFlags(DC: HDC; Flag: LongInt): LongInt;
function SetMenu(Wnd: HWnd; Menu: HMenu): Bool;
function SetMenuItemBitmaps(Menu: HMenu; Position, Flags: Word; 
  BitmapUnchecked, BitmapChecked: HBitmap): Bool;
function SetMessageQueue(Msg: Integer): Bool;
function SetMetaFileBits(Mem: THandle): THandle;
function SetPaletteEntries(Palette: HPalette; StartIndex, NumEntries: Word; 
  var PaletteEntries): Word;
function SetParent(WndChild: HWnd; WndNewParent: HWnd): HWnd;
function SetPixel(DC: HDC; X, Y: Integer; Color: TColorRef): LongInt;
function SetPolyFillMode(DC: HDC; PolyFillMode: Integer): Integer;
function SetProp(Wnd: HWnd; Str: PChar; Data: THandle): Bool;
procedure SetRect(var Rect: TRect; X1, Y1, X2, Y2: Integer);
procedure SetRectEmpty(var Rect: TRect);
procedure SetRectRgn(Rgn: HRgn; X1, Y1, X2, Y2: Integer);
function SetResourceHandler(Instance: THandle; ResType: Pointer; 
  LoadFunc: TFarProc): TFarProc;
function SetROP2(DC: HDC; DrawMode: Integer): Integer;
function SetScrollPos(Wnd: HWnd; Bar, Pos: Integer; Redraw: Bool): Integer;
procedure SetScrollRange(Wnd: HWnd; Bar, MinPos, MaxPos: Integer; 
  Redraw: Bool);
function SetSoundNoise(Source, Duration: Integer): Integer;
function SetStretchBltMode(DC: HDC; StretchMode: Integer): Integer;
function SetSwapAreaSize(Size: Word): LongInt;
procedure SetSysColors(Changes: Integer; var SysColor; var ColorValues);
function SetSysModalWindow(Wnd: HWnd): HWnd;
function SetSystemPaletteUse(DC: HDC; Usage: Word): Word;
function SetTextAlign(DC: HDC; Flags: Word): Word;
function SetTextCharacterExtra(DC: HDC; CharExtra: Integer): Integer;
function SetTextColor(DC: HDC; Color: TColorRef): TColorRef;
function SetTextJustification(DC: HDC; BreakExtra, 
  BreakCount: Integer): Integer;
function SetTimer(Wnd: HWnd; IDEvent: Integer; Elapse: Word; 
  TimerFunc: TFarProc): Word;
function SetViewportExt(DC: HDC; X, Y: Integer): LongInt;
function SetViewportOrg(DC: HDC; X, Y: Integer): LongInt;
function SetVoiceAccent(Voice, Tempo, Volume, Mode, Pitch: Integer): Integer;
function SetVoiceEnvelope(Voice, Shape, RepeatCount: Integer): Integer;
function SetVoiceNote(Voice, Value, Length, Cdots: Integer): Integer;
function SetVoiceQueueSize(Voice, Bytes: Integer): Integer;
function SetVoiceSound(Voice: Integer; Frequency: LongInt; 
  Duration: Integer): Integer;
function SetVoiceThreshold(Voice, Notes: Integer): Integer;
function SetWindowExt(DC: HDC; X, Y: Integer): LongInt;
function SetWindowLong(Wnd: HWnd; Index: Integer; NewLong: LongInt): LongInt;
function SetWindowOrg(DC: HDC; X, Y: Integer): LongInt;
procedure SetWindowPos(Wnd: HWnd; WndInsertAfter: HWnd; X, Y, cx, cy: Integer;
  Flags: Word);
function SetWindowsHook(FilterType: Integer; FilterFunc: TFarProc): TFarProc;
procedure SetWindowText(Wnd: HWnd; Str: PChar);
function SetWindowWord(Wnd: HWnd; Index: Integer; NewWord: Word): Word;
procedure ShowCaret(Wnd: HWnd);
function ShowCursor(Show: Bool): Integer;
procedure ShowOwnedPopups(Wnd: HWnd; Show: Bool);
procedure ShowScrollBar(Wnd: HWnd; Bar: Word; Show: Bool);
function ShowWindow(Wnd: HWnd; CmdShow: Integer): Bool;
function SizeofResource(Instance, ResInfo: THandle): LongInt;
function StartSound: Integer;
function StopSound: Integer;
function StretchBlt(DestDC: HDC; X, Y, Width, Height: Integer; SrcDC: HDC; 
  XSrc, YSrc, SrcWidth, SrcHeight: Integer; Rop: LongInt): Bool;
function StretchDIBits(DC: HDC; DestX, DestY, DestWidth, DestHegiht, SrcX, 
  SrcY, SrcWidth, SrcHeight: Word; Bits: Pointer; var BitsInfo: TBitmapInfo;
  Usage: Word; Rop: LongInt): Integer;
function SwapMouseButton(Swap: Bool): Bool;
procedure SwapRecording(Flag: Word);
procedure SwitchStackBack;
procedure SwitchStackTo(StackSegment, StackPointer, StackTop: Word);
function SyncAllVoices: Integer;
function TabbedTextOut(HC: HDC; X, Y: Integer; Str: PChar; Count: Integer; 
  TabPositions: Integer; var TabStopPositions; TabOrigin: Integer): LongInt;
function TextOut(DC: HDC; X, Y: Integer; Str: PChar; Count: Integer): Bool;
procedure Throw(var CatchBuf: TCatchBuf; ThrowBack: Integer);
function ToAscii(VirtKey, ScanCode: Word; KeyState: PChar; Char: Pointer; 
  Flags: Word): integer;
function TrackPopupMenu(Menu: HMenu; Flags: Word; x, y, Reserved: Integer; 
  Wnd: HWnd; Reserved: Pointer): Bool;
function TranslateAccelerator(Wnd: HWnd; AccTable: THandle;
  var Msg: TMsg): Integer;
function TranslateMDISysAccel(Wnd: HWnd; var Msg: TMsg): Bool;
function TranslateMessage(var Msg: TMsg): Bool;
function TransmitCommChar(Cid: Integer; Chr: Char): Integer;
function UngetCommChar(Cid: Integer; Chr: Char): Integer;
function UnhookWindowsHook(Hook: Integer; HookFunc: TFarProc): Bool;
function UnionRect(var DestRect, Src1Rect, Src2Rect: TRect): Integer;
function UnlockData(Dummy: Integer): THandle;
function UnlockResource(ResData: THandle): Bool;
function UnlockSegment(Segment: Word): THandle;
function UnrealizeObject(hObject: HBrush): Bool;
function UnregisterClass(ClassName: PChar; Instance: THandle): Bool;
function UpdateColors(DC: HDC): Integer;
procedure UpdateWindow(Wnd: HWnd);
procedure ValidateCodeSegments;
procedure ValidateFreeSpaces;
procedure ValidateRect(Wnd: HWnd; Rect: PRect);
procedure ValidateRgn(Wnd: HWnd; Rgn: HRgn);
function VkKeyScan(Chr: Word): Word;
procedure WaitMessage;
function WaitSoundState(State: Integer): Integer;
function WindowFromPoint(Point: TPoint): HWnd;
function WinExec(CmdLine: PChar; CmdShow: Word): Word;
function WinHelp(Wnd: HWnd; HelpFile: PChar; Command: Word; 
  Data: LongInt): Bool;
function WriteComm(Cid: Integer; Buf: PChar; Size: Integer): Integer;
function WritePrivateProfileString(ApplicationName, KeyName, Str,
  FileName: PChar): Bool;
function WriteProfileString(ApplicationName, KeyName, Str: PChar): Bool;
function wvsprintf(DestStr, Format: PChar; var ArgList): Integer;
function Yield: Bool;
function _lclose(FileHandle: Integer): Integer;
function _lcreat(PathName: PChar; Atribute: Integer): Integer;
function _llseek(FileHandle: Integer; Offset: LongInt;
  Origin: Integer): LongInt;
function _lopen(PathName: PChar; ReadWrite: Integer): Integer;
function _lread(FileHandle: Integer; Buffer: PChar; Bytes: Integer): Word;
function _lwrite(FileHandle: Integer; Buffer: PChar; Bytes: Integer): Word;

{ Various inline and wrapper routines }

function MakeLong(A, B: Word): LongInt;
inline(
  $5A/    { POP DX }
  $58);   { POP AX }

function LoWord(A: LongInt): Word;
inline(
  $58/    { POP AX }
  $5A);   { POP DX }

function HiWord(A: LongInt): Word;
inline(
  $5A/    { POP DX }
  $58);   { POP AX }

function LoByte(A: Word): Byte;
inline(
  $58/       { POP AX    }
  $32/$E4);  { XOR AH,AH }

function HiByte(A: Word): Byte;
inline(
  $58/       { POP AX    }
  $8A/$C4/   { MOV AL,AH }
  $32/$E4);  { XOR AH,AH }

function RGB(R: Byte; G: Byte; B: Byte): LongInt;
inline(
  $5A/       { POP DX    }
  $5B/       { POP BX    }
  $58/       { POP AX    }
  $8A/$E3/   { MOV AH,BL }
  $32/$F6);  { XOR DH,DH }

function PaletteRGB(R: Byte; G: Byte; B: Byte): LongInt;
inline(
  $5A/       { POP DX    }
  $5B/       { POP BX    }
  $58/       { POP AX    }
  $8A/$E3/   { MOV AH,BL }
  $B6/$02);  { MOV DH,2  }

function GetRValue(RGB: LongInt): Byte;
inline(
  $58/       { POP AX    }
  $5A/       { POP DX    }
  $32/$E4);  { XOR AH,AH }

function GetGValue(RGB: LongInt): Byte;
inline(
  $58/       { POP AX    }
  $5A/       { POP DX    }
  $8A/$C4/   { MOV AL,AH }
  $32/$E4);  { XOR AH,AH }

function GetBValue(RGB: LongInt): Byte;
inline(
  $5A/       { POP DX    }
  $58/       { POP AX    }
  $32/$E4);  { XOR AH,AH }

function PaletteIndex(PaletteIndex: Integer): TColorRef;
inline(
  $58/	        { POP AX      }
  $BA/$00/$01); { MOV DX,$100 }

implementation

function _LocalLock(Mem: THandle): Word; far; forward;

{ KERNEL routines }

procedure FatalExit;			external 'KERNEL' index 1;
function GetVersion;			external 'KERNEL' index 3;
function LocalInit;			external 'KERNEL' index 4;
function LocalAlloc;			external 'KERNEL' index 5;
function LocalReAlloc;			external 'KERNEL' index 6;
function LocalFree;			external 'KERNEL' index 7;
function _LocalLock;			external 'KERNEL' index 8;
function LocalUnlock;			external 'KERNEL' index 9;
function LocalSize;			external 'KERNEL' index 10;
function LocalHandle;			external 'KERNEL' index 11;
function LocalFlags;			external 'KERNEL' index 12;
function LocalCompact;			external 'KERNEL' index 13;
function LocalNotify;			external 'KERNEL' index 14;
function GlobalAlloc;			external 'KERNEL' index 15;
function GlobalReAlloc;			external 'KERNEL' index 16;
function GlobalFree;			external 'KERNEL' index 17;
function GlobalLock;			external 'KERNEL' index 18;
function GlobalUnlock;			external 'KERNEL' index 19;
function UnlockResource;		external 'KERNEL' index 19;
function GlobalSize;			external 'KERNEL' index 20;
function GlobalHandle;			external 'KERNEL' index 21;
function GlobalFlags;			external 'KERNEL' index 22;
function LockSegment;			external 'KERNEL' index 23;
function UnlockSegment;			external 'KERNEL' index 24;
function GlobalCompact;			external 'KERNEL' index 25;
function Yield;				external 'KERNEL' index 29;
function GetCurrentTask;		external 'KERNEL' index 36;
function GetCurrentPDB;                 external 'KERNEL' index 37;
function LoadModule;			external 'KERNEL' index 45;
function FreeModule;			external 'KERNEL' index 46;
function GetModuleHandle;		external 'KERNEL' index 47;
function GetModuleUsage;		external 'KERNEL' index 48;
function GetModuleFileName;		external 'KERNEL' index 49;
function GetProcAddress;		external 'KERNEL' index 50;
function MakeProcInstance;		external 'KERNEL' index 51;
procedure FreeProcInstance;		external 'KERNEL' index 52;
function GetInstanceData;		external 'KERNEL' index 54;
function Catch;				external 'KERNEL' index 55;
procedure Throw;			external 'KERNEL' index 56;
function GetProfileInt;			external 'KERNEL' index 57;
function GetProfileString;		external 'KERNEL' index 58;
function WriteProfileString;		external 'KERNEL' index 59;
function FindResource;			external 'KERNEL' index 60;
function LoadResource;			external 'KERNEL' index 61;
function LockResource;			external 'KERNEL' index 62;
function FreeResource;			external 'KERNEL' index 63;
function AccessResource;		external 'KERNEL' index 64;
function SizeofResource;		external 'KERNEL' index 65;
function AllocResource;			external 'KERNEL' index 66;
function SetResourceHandler;		external 'KERNEL' index 67;
function InitAtomTable;			external 'KERNEL' index 68;
function FindAtom;			external 'KERNEL' index 69;
function AddAtom;			external 'KERNEL' index 70;
function DeleteAtom;			external 'KERNEL' index 71;
function GetAtomName;			external 'KERNEL' index 72;
function GetAtomHandle;			external 'KERNEL' index 73;
function OpenFile;			external 'KERNEL' index 74;
function _lclose;			external 'KERNEL' index 81;
function _lread;			external 'KERNEL' index 82;
function _lcreat;			external 'KERNEL' index 83;
function _llseek;			external 'KERNEL' index 84;
function _lopen;			external 'KERNEL' index 85;
function _lwrite;			external 'KERNEL' index 86;
function lstrcpy;			external 'KERNEL' index 88;
function lstrcat;			external 'KERNEL' index 89;
function lstrlen;			external 'KERNEL' index 90;
function GetTempDrive;			external 'KERNEL' index 92;
function GetCodeHandle;			external 'KERNEL' index 93;
function DefineHandleTable;		external 'KERNEL' index 94;
function LoadLibrary;			external 'KERNEL' index 95;
procedure FreeLibrary;			external 'KERNEL' index 96;
function GetTempFileName;		external 'KERNEL' index 97;
procedure ValidateCodeSegments;         external 'KERNEL' index 100;
procedure DOS3Call;			external 'KERNEL' index 102;
procedure NetBIOSCall;			external 'KERNEL' index 103;
procedure GetCodeInfo;                  external 'KERNEL' index 104;
function SetSwapAreaSize;		external 'KERNEL' index 106;
function SetErrorMode;			external 'KERNEL' index 107;
procedure SwitchStackTo;                external 'KERNEL' index 108;
procedure SwitchStackBack;              external 'KERNEL' index 109;
function GlobalWire;			external 'KERNEL' index 111;
function GlobalUnWire;			external 'KERNEL' index 112;
procedure OutputDebugString;		external 'KERNEL' index 115;
function LocalShrink;			external 'KERNEL' index 121;
function GetPrivateProfileInt;		external 'KERNEL' index 127;
function GetPrivateProfileString;	external 'KERNEL' index 128;
function WritePrivateProfileString;	external 'KERNEL' index 129;
function GetDOSEnvironment;             external 'KERNEL' index 131;
function GetWinFlags;			external 'KERNEL' index 132;
function GetWindowsDirectory;		external 'KERNEL' index 134;
function GetSystemDirectory;		external 'KERNEL' index 135;
function GetDriveType;			external 'KERNEL' index 136;
procedure FatalAppExit;			external 'KERNEL' index 137;
function GetNumTasks;			external 'KERNEL' index 152;
procedure GlobalNotify;			external 'KERNEL' index 154;
procedure LimitEmsPages;		external 'KERNEL' index 156;
function GlobalLRUOldest;		external 'KERNEL' index 163;
function GlobalLRUNewest;		external 'KERNEL' index 164;
function WinExec;			external 'KERNEL' index 166;
function GetFreeSpace;			external 'KERNEL' index 169;
function AllocCStoDSAlias;              external 'KERNEL' index 170;
function AllocDStoCSAlias;              external 'KERNEL' index 171;
function AllocSelector;                 external 'KERNEL' index 175;
function FreeSelector;                  external 'KERNEL' index 176;
function ChangeSelector;		external 'KERNEL' index 177;
function GlobalDosAlloc;		external 'KERNEL' index 184;
function GlobalDosFree;			external 'KERNEL' index 185;
function GlobalPageLock;                external 'KERNEL' index 191;
function GlobalPageUnlock;              external 'KERNEL' index 192;
procedure GlobalFix;                    external 'KERNEL' index 197;
function GlobalUnfix;                   external 'KERNEL' index 198;
function SetHandleCount;		external 'KERNEL' index 199;
procedure ValidateFreeSpaces;		external 'KERNEL' index 200;
procedure DebugBreak;                   external 'KERNEL' index 203;
procedure SwapRecording;		external 'KERNEL' index 204;

{ GDI routines }

function SetBkColor;			external 'GDI' index 1;
function SetBkMode;			external 'GDI' index 2;
function SetMapMode;			external 'GDI' index 3;
function SetROP2;			external 'GDI' index 4;
function SetPolyFillMode;		external 'GDI' index 6;
function SetStretchBltMode;		external 'GDI' index 7;
function SetTextCharacterExtra;		external 'GDI' index 8;
function SetTextColor;			external 'GDI' index 9;
function SetTextJustification;		external 'GDI' index 10;
function SetWindowOrg;			external 'GDI' index 11;
function SetWindowExt;			external 'GDI' index 12;
function SetViewportOrg;		external 'GDI' index 13;
function SetViewportExt;		external 'GDI' index 14;
function OffsetWindowOrg;		external 'GDI' index 15;
function ScaleWindowExt;		external 'GDI' index 16;
function OffsetViewportOrg;		external 'GDI' index 17;
function ScaleViewportExt;		external 'GDI' index 18;
function LineTo;			external 'GDI' index 19;
function MoveTo;			external 'GDI' index 20;
function ExcludeClipRect;		external 'GDI' index 21;
function IntersectClipRect;		external 'GDI' index 22;
function Arc;				external 'GDI' index 23;
function Ellipse;			external 'GDI' index 24;
function FloodFill;			external 'GDI' index 25;
function Pie;				external 'GDI' index 26;
function Rectangle;			external 'GDI' index 27;
function RoundRect;			external 'GDI' index 28;
function PatBlt;			external 'GDI' index 29;
function SaveDC;			external 'GDI' index 30;
function SetPixel;			external 'GDI' index 31;
function OffsetClipRgn;			external 'GDI' index 32;
function TextOut;			external 'GDI' index 33;
function BitBlt;			external 'GDI' index 34;
function StretchBlt;			external 'GDI' index 35;
function Polygon;			external 'GDI' index 36;
function Polyline;			external 'GDI' index 37;
function Escape;			external 'GDI' index 38;
function RestoreDC;			external 'GDI' index 39;
function FillRgn;			external 'GDI' index 40;
function FrameRgn;			external 'GDI' index 41;
function InvertRgn;			external 'GDI' index 42;
function PaintRgn;			external 'GDI' index 43;
function SelectClipRgn;			external 'GDI' index 44;
function SelectObject;			external 'GDI' index 45;
function CombineRgn;			external 'GDI' index 47;
function CreateBitmap;			external 'GDI' index 48;
function CreateBitmapIndirect;		external 'GDI' index 49;
function CreateBrushIndirect;		external 'GDI' index 50;
function CreateCompatibleBitmap;	external 'GDI' index 51;
function CreateCompatibleDC;		external 'GDI' index 52;
function CreateDC;			external 'GDI' index 53;
function CreateEllipticRgn;		external 'GDI' index 54;
function CreateEllipticRgnIndirect;	external 'GDI' index 55;
function CreateFont;			external 'GDI' index 56;
function CreateFontIndirect;		external 'GDI' index 57;
function CreateHatchBrush;		external 'GDI' index 58;
function CreatePatternBrush;		external 'GDI' index 60;
function CreatePen;			external 'GDI' index 61;
function CreatePenIndirect;		external 'GDI' index 62;
function CreatePolygonRgn;		external 'GDI' index 63;
function CreateRectRgn;			external 'GDI' index 64;
function CreateRectRgnIndirect;		external 'GDI' index 65;
function CreateSolidBrush;		external 'GDI' index 66;
function DPtoLP;			external 'GDI' index 67;
function DeleteDC;			external 'GDI' index 68;
function DeleteObject;			external 'GDI' index 69;
function EnumFonts;			external 'GDI' index 70;
function EnumObjects;			external 'GDI' index 71;
function EqualRgn;			external 'GDI' index 72;
function GetBitmapBits;			external 'GDI' index 74;
function GetBkColor;			external 'GDI' index 75;
function GetBkMode;			external 'GDI' index 76;
function GetClipBox;			external 'GDI' index 77;
function GetCurrentPosition;		external 'GDI' index 78;
function GetDCOrg;			external 'GDI' index 79;
function GetDeviceCaps;			external 'GDI' index 80;
function GetMapMode;			external 'GDI' index 81;
function GetObject;			external 'GDI' index 82;
function GetPixel;			external 'GDI' index 83;
function GetPolyFillMode;		external 'GDI' index 84;
function GetROP2;			external 'GDI' index 85;
function GetStockObject;		external 'GDI' index 87;
function GetStretchBltMode;		external 'GDI' index 88;
function GetTextCharacterExtra;		external 'GDI' index 89;
function GetTextColor;			external 'GDI' index 90;
function GetTextExtent;			external 'GDI' index 91;
function GetTextFace;			external 'GDI' index 92;
function GetTextMetrics;		external 'GDI' index 93;
function GetViewportExt;		external 'GDI' index 94;
function GetViewportOrg;		external 'GDI' index 95;
function GetWindowExt;			external 'GDI' index 96;
function GetWindowOrg;			external 'GDI' index 97;
function LPtoDP;			external 'GDI' index 99;
procedure LineDDA;			external 'GDI' index 100;
function OffsetRgn;			external 'GDI' index 101;
function PtVisible;			external 'GDI' index 103;
function RectVisible;			external 'GDI' index 104;
function SetBitmapBits;			external 'GDI' index 106;
function AddFontResource;		external 'GDI' index 119;
function PlayMetaFile;			external 'GDI' index 123;
function GetMetaFile;			external 'GDI' index 124;
function CreateMetaFile;		external 'GDI' index 125;
function CloseMetaFile;			external 'GDI' index 126;
function DeleteMetaFile;		external 'GDI' index 127;
function MulDiv;                        external 'GDI' index 128;
function SetEnvironment;		external 'GDI' index 132;
function GetEnvironment;		external 'GDI' index 133;
function GetRgnBox;                     external 'GDI' index 134;
function RemoveFontResource;		external 'GDI' index 136;
function SetBrushOrg;			external 'GDI' index 148;
function GetBrushOrg;			external 'GDI' index 149;
function UnrealizeObject;		external 'GDI' index 150;
function CopyMetaFile;			external 'GDI' index 151;
function CreateIC;			external 'GDI' index 153;
function GetNearestColor;		external 'GDI' index 154;
function CreateDiscardableBitmap;	external 'GDI' index 156;
function GetMetaFileBits;		external 'GDI' index 159;
function SetMetaFileBits;		external 'GDI' index 160;
function PtInRegion;			external 'GDI' index 161;
function GetBitmapDimension;		external 'GDI' index 162;
function SetBitmapDimension;		external 'GDI' index 163;
procedure SetRectRgn;			external 'GDI' index 172;
function EnumMetaFile;			external 'GDI' index 175;
procedure PlayMetaFileRecord;		external 'GDI' index 176;
function RectInRegion;                  external 'GDI' index 181;
function GetTextAlign;			external 'GDI' index 345;
function SetTextAlign;			external 'GDI' index 346;
function Chord;				external 'GDI' index 348;
function SetMapperFlags;		external 'GDI' index 349;
function GetCharWidth;			external 'GDI' index 350;
function ExtTextOut;			external 'GDI' index 351;
function GetAspectRatioFilter;		external 'GDI' index 353;
function CreatePalette;			external 'GDI' index 360;
function GetPaletteEntries;		external 'GDI' index 363;
function SetPaletteEntries;		external 'GDI' index 364;
function UpdateColors;			external 'GDI' index 366;
procedure AnimatePalette;		external 'GDI' index 367;
function ResizePalette;			external 'GDI' index 368;
function GetNearestPaletteIndex;	external 'GDI' index 370;
function ExtFloodFill;			external 'GDI' index 372;
function SetSystemPaletteUse;		external 'GDI' index 373;
function GetSystemPaletteUse;		external 'GDI' index 374;
function GetSystemPaletteEntries;	external 'GDI' index 375;
function StretchDIBits;                 external 'GDI' index 439;
function SetDIBits;			external 'GDI' index 440;
function GetDIBits;			external 'GDI' index 441;
function CreateDIBitmap;		external 'GDI' index 442;
function SetDIBitsToDevice;		external 'GDI' index 443;
function CreateRoundRectRgn;		external 'GDI' index 444;
function CreateDIBPatternBrush;		external 'GDI' index 445;
function PolyPolygon;			external 'GDI' index 450;
function CreatePolyPolygonRgn;          external 'GDI' index 451;

{ USER routines }

function MessageBox;			external 'USER' index 1;
procedure PostQuitMessage;		external 'USER' index 6;
function ExitWindows;                   external 'USER' index 7;
function SetTimer;			external 'USER' index 10;
function KillTimer;			external 'USER' index 12;
function GetTickCount;			external 'USER' index 13;
function GetCurrentTime;		external 'USER' index 15;
procedure ClipCursor;			external 'USER' index 16;
procedure GetCursorPos;			external 'USER' index 17;
function SetCapture;			external 'USER' index 18;
procedure ReleaseCapture;		external 'USER' index 19;
procedure SetDoubleClickTime;		external 'USER' index 20;
function GetDoubleClickTime;		external 'USER' index 21;
function SetFocus;			external 'USER' index 22;
function GetFocus;			external 'USER' index 23;
function RemoveProp;			external 'USER' index 24;
function GetProp;			external 'USER' index 25;
function SetProp;			external 'USER' index 26;
function EnumProps;			external 'USER' index 27;
procedure ClientToScreen;		external 'USER' index 28;
procedure ScreenToClient;		external 'USER' index 29;
function WindowFromPoint;		external 'USER' index 30;
function IsIconic;			external 'USER' index 31;
procedure GetWindowRect;		external 'USER' index 32;
procedure GetClientRect;		external 'USER' index 33;
function EnableWindow;			external 'USER' index 34;
function IsWindowEnabled;		external 'USER' index 35;
function GetWindowText;			external 'USER' index 36;
procedure SetWindowText;		external 'USER' index 37;
function GetWindowTextLength;		external 'USER' index 38;
function BeginPaint;			external 'USER' index 39;
procedure EndPaint;			external 'USER' index 40;
function CreateWindow;			external 'USER' index 41;
function ShowWindow;			external 'USER' index 42;
procedure CloseWindow;			external 'USER' index 43;
function OpenIcon;			external 'USER' index 44;
procedure BringWindowToTop;		external 'USER' index 45;
function GetParent;			external 'USER' index 46;
function IsWindow;			external 'USER' index 47;
function IsChild;			external 'USER' index 48;
function IsWindowVisible;		external 'USER' index 49;
function FindWindow;			external 'USER' index 50;
function IsTwoByteCharPrefix;		external 'USER' index 51;
function AnyPopup;			external 'USER' index 52;
function DestroyWindow;			external 'USER' index 53;
function EnumWindows;			external 'USER' index 54;
function EnumChildWindows;		external 'USER' index 55;
procedure MoveWindow;			external 'USER' index 56;
function RegisterClass;			external 'USER' index 57;
function GetClassName;			external 'USER' index 58;
function SetActiveWindow;		external 'USER' index 59;
function GetActiveWindow;		external 'USER' index 60;
procedure ScrollWindow;			external 'USER' index 61;
function SetScrollPos;			external 'USER' index 62;
function GetScrollPos;			external 'USER' index 63;
procedure SetScrollRange;		external 'USER' index 64;
procedure GetScrollRange;		external 'USER' index 65;
function GetDC;				external 'USER' index 66;
function GetWindowDC;			external 'USER' index 67;
function ReleaseDC;			external 'USER' index 68;
function SetCursor;			external 'USER' index 69;
procedure SetCursorPos;			external 'USER' index 70;
function ShowCursor;			external 'USER' index 71;
procedure SetRect;			external 'USER' index 72;
procedure SetRectEmpty;			external 'USER' index 73;
procedure CopyRect;			external 'USER' index 74;
function IsRectEmpty;			external 'USER' index 75;
function PtInRect;			external 'USER' index 76;
procedure OffsetRect;			external 'USER' index 77;
procedure InflateRect;			external 'USER' index 78;
function IntersectRect;		        external 'USER' index 79;
function UnionRect;			external 'USER' index 80;
function FillRect;			external 'USER' index 81;
procedure InvertRect;			external 'USER' index 82;
procedure FrameRect;			external 'USER' index 83;
function DrawIcon;			external 'USER' index 84;
function DrawText;			external 'USER' index 85;
function DialogBox;			external 'USER' index 87;
procedure EndDialog;			external 'USER' index 88;
function CreateDialog;			external 'USER' index 89;
function IsDialogMessage;		external 'USER' index 90;
function GetDlgItem;			external 'USER' index 91;
procedure SetDlgItemText;		external 'USER' index 92;
function GetDlgItemText;		external 'USER' index 93;
procedure SetDlgItemInt;		external 'USER' index 94;
function GetDlgItemInt;			external 'USER' index 95;
procedure CheckRadioButton;		external 'USER' index 96;
procedure CheckDlgButton;		external 'USER' index 97;
function IsDlgButtonChecked;		external 'USER' index 98;
function DlgDirSelect;			external 'USER' index 99;
function DlgDirList;			external 'USER' index 100;
function SendDlgItemMessage;		external 'USER' index 101;
procedure AdjustWindowRect;		external 'USER' index 102;
procedure MapDialogRect;		external 'USER' index 103;
procedure MessageBeep;			external 'USER' index 104;
function FlashWindow;			external 'USER' index 105;
function GetKeyState;			external 'USER' index 106;
function DefWindowProc;			external 'USER' index 107;
function GetMessage;			external 'USER' index 108;
function PeekMessage;			external 'USER' index 109;
function PostMessage;			external 'USER' index 110;
function SendMessage;			external 'USER' index 111;
procedure WaitMessage;			external 'USER' index 112;
function TranslateMessage;		external 'USER' index 113;
function DispatchMessage;		external 'USER' index 114;
procedure ReplyMessage;			external 'USER' index 115;
function PostAppMessage;		external 'USER' index 116;
function RegisterWindowMessage;		external 'USER' index 118;
function GetMessagePos;			external 'USER' index 119;
function GetMessageTime;		external 'USER' index 120;
function SetWindowsHook;		external 'USER' index 121;
function CallWindowProc;		external 'USER' index 122;
function CallMsgFilter;			external 'USER' index 123;
procedure UpdateWindow;			external 'USER' index 124;
procedure InvalidateRect;		external 'USER' index 125;
procedure InvalidateRgn;		external 'USER' index 126;
procedure ValidateRect;			external 'USER' index 127;
procedure ValidateRgn;			external 'USER' index 128;
function GetClassWord;			external 'USER' index 129;
function SetClassWord;			external 'USER' index 130;
function GetClassLong;			external 'USER' index 131;
function SetClassLong;			external 'USER' index 132;
function GetWindowWord;			external 'USER' index 133;
function SetWindowWord;			external 'USER' index 134;
function GetWindowLong;			external 'USER' index 135;
function SetWindowLong;			external 'USER' index 136;
function OpenClipboard;			external 'USER' index 137;
function CloseClipboard;		external 'USER' index 138;
function EmptyClipboard;		external 'USER' index 139;
function GetClipboardOwner;		external 'USER' index 140;
function SetClipboardData;		external 'USER' index 141;
function GetClipboardData;		external 'USER' index 142;
function CountClipboardFormats;		external 'USER' index 143;
function EnumClipboardFormats;		external 'USER' index 144;
function RegisterClipboardFormat;	external 'USER' index 145;
function GetClipboardFormatName;	external 'USER' index 146;
function SetClipboardViewer;		external 'USER' index 147;
function GetClipboardViewer;		external 'USER' index 148;
function ChangeClipboardChain;		external 'USER' index 149;
function LoadMenu;			external 'USER' index 150;
function CreateMenu;			external 'USER' index 151;
function DestroyMenu;			external 'USER' index 152;
function ChangeMenu;			external 'USER' index 153;
function CheckMenuItem;			external 'USER' index 154;
function EnableMenuItem;		external 'USER' index 155;
function GetSystemMenu;			external 'USER' index 156;
function GetMenu;			external 'USER' index 157;
function SetMenu;			external 'USER' index 158;
function GetSubMenu;			external 'USER' index 159;
procedure DrawMenuBar;			external 'USER' index 160;
function GetMenuString;			external 'USER' index 161;
function HiliteMenuItem;		external 'USER' index 162;
procedure CreateCaret;			external 'USER' index 163;
procedure DestroyCaret;			external 'USER' index 164;
procedure SetCaretPos;			external 'USER' index 165;
procedure HideCaret;			external 'USER' index 166;
procedure ShowCaret;			external 'USER' index 167;
procedure SetCaretBlinkTime;		external 'USER' index 168;
function GetCaretBlinkTime;		external 'USER' index 169;
function ArrangeIconicWindows;		external 'USER' index 170;
function WinHelp;			external 'USER' index 171;
function LoadCursor;			external 'USER' index 173;
function LoadIcon;			external 'USER' index 174;
function LoadBitmap;			external 'USER' index 175;
function LoadString;			external 'USER' index 176;
function LoadAccelerators;		external 'USER' index 177;
function TranslateAccelerator;		external 'USER' index 178;
function GetSystemMetrics;		external 'USER' index 179;
function GetSysColor;			external 'USER' index 180;
procedure SetSysColors;			external 'USER' index 181;
procedure GetCaretPos;			external 'USER' index 183;
function GrayString;			external 'USER' index 185;
function SwapMouseButton;		external 'USER' index 186;
function SetSysModalWindow;		external 'USER' index 188;
function GetSysModalWindow;		external 'USER' index 189;
function GetUpdateRect;			external 'USER' index 190;
function ChildWindowFromPoint;		external 'USER' index 191;
function InSendMessage;			external 'USER' index 192;
function IsClipboardFormatAvailable;	external 'USER' index 193;
function DlgDirSelectComboBox;		external 'USER' index 194;
function DlgDirListComboBox;		external 'USER' index 195;
function TabbedTextOut;			external 'USER' index 196;
function GetTabbedTextExtent;		external 'USER' index 197;
function OpenComm;			external 'USER' index 200;
function SetCommState;			external 'USER' index 201;
function GetCommState;			external 'USER' index 202;
function GetCommError;			external 'USER' index 203;
function ReadComm;			external 'USER' index 204;
function WriteComm;			external 'USER' index 205;
function TransmitCommChar;		external 'USER' index 206;
function CloseComm;			external 'USER' index 207;
function SetCommEventMask;		external 'USER' index 208;
function GetCommEventMask;		external 'USER' index 209;
function SetCommBreak;			external 'USER' index 210;
function ClearCommBreak;		external 'USER' index 211;
function UngetCommChar;			external 'USER' index 212;
function BuildCommDCB;			external 'USER' index 213;
function EscapeCommFunction;		external 'USER' index 214;
function FlushComm;			external 'USER' index 215;
function DialogBoxIndirect;		external 'USER' index 218;
function CreateDialogIndirect;		external 'USER' index 219;
function LoadMenuIndirect;		external 'USER' index 220;
function ScrollDC;			external 'USER' index 221;
procedure GetKeyboardState;		external 'USER' index 222;
procedure SetKeyboardState;		external 'USER' index 223;
function GetWindowTask;			external 'USER' index 224;
function EnumTaskWindows;		external 'USER' index 225;
function GetNextDlgGroupItem;		external 'USER' index 227;
function GetNextDlgTabItem;		external 'USER' index 228;
function GetTopWindow;			external 'USER' index 229;
function GetNextWindow;			external 'USER' index 230;
procedure SetWindowPos;                 external 'USER' index 232;
function SetParent;			external 'USER' index 233;
function UnhookWindowsHook;		external 'USER' index 234;
function DefHookProc;			external 'USER' index 235;
function GetCapture;			external 'USER' index 236;
function GetUpdateRgn;			external 'USER' index 237;
function ExcludeUpdateRgn;		external 'USER' index 238;
function DialogBoxParam;		external 'USER' index 239;
function DialogBoxIndirectParam;	external 'USER' index 240;
function CreateDialogParam;		external 'USER' index 241;
function CreateDialogIndirectParam;	external 'USER' index 242;
function GetDialogBaseUnits;		external 'USER' index 243;
function EqualRect;			external 'USER' index 244;
function GetAsyncKeyState;		external 'USER' index 249;
function GetMenuState;			external 'USER' index 250;
function BeginDeferWindowPos;           external 'USER' index 259;
function DeferWindowPos;                external 'USER' index 260;
procedure EndDeferWindowPos;            external 'USER' index 261;
function GetWindow;			external 'USER' index 262;
function GetMenuItemCount;		external 'USER' index 263;
function GetMenuItemID;			external 'USER' index 264;
procedure ShowOwnedPopups;		external 'USER' index 265;
function SetMessageQueue;		external 'USER' index 266;
procedure ShowScrollBar;		external 'USER' index 267;
function GlobalAddAtom;			external 'USER' index 268;
function GlobalDeleteAtom;		external 'USER' index 269;
function GlobalFindAtom;		external 'USER' index 270;
function GlobalGetAtomName;		external 'USER' index 271;
function IsZoomed;			external 'USER' index 272;
function GetDlgCtrlID;			external 'USER' index 277;
function GetDesktopHwnd;		external 'USER' index 278;
function SelectPalette;			external 'USER' index 282;
function RealizePalette;		external 'USER' index 283;
function GetDesktopWindow;		external 'USER' index 286;
function GetLastActivePopup;		external 'USER' index 287;
function DefDlgProc;			external 'USER' index 308;
function EnableHardwareInput;		external 'USER' index 331;
function GetInputState;			external 'USER' index 335;
function GetPriorityClipboardFormat;	external 'USER' index 402;
function UnregisterClass;		external 'USER' index 403;
function GetClassInfo;			external 'USER' index 404;
function CreateCursor;			external 'USER' index 406;
function CreateIcon;			external 'USER' index 407;
function InsertMenu;			external 'USER' index 410;
function AppendMenu;			external 'USER' index 411;
function RemoveMenu;			external 'USER' index 412;
function DeleteMenu;			external 'USER' index 413;
function ModifyMenu;			external 'USER' index 414;
function CreatePopupMenu;		external 'USER' index 415;
function TrackPopupMenu;		external 'USER' index 416;
function GetMenuCheckMarkDimensions;	external 'USER' index 417;
function SetMenuItemBitmaps;		external 'USER' index 418;
function wvsprintf;			external 'USER' index 421;
function lstrcmp;			external 'USER' index 430;
function AnsiUpper;			external 'USER' index 431;
function AnsiLower;			external 'USER' index 432;
function IsCharAlpha;			external 'USER' index 433;
function IsCharAlphaNumeric;		external 'USER' index 434;
function IsCharUpper;			external 'USER' index 435;
function IsCharLower;			external 'USER' index 436;
function AnsiUpperBuff;			external 'USER' index 437;
function AnsiLowerBuff;			external 'USER' index 438;
function DefFrameProc;			external 'USER' index 445;
function DefMDIChildProc;		external 'USER' index 447;
function TranslateMDISysAccel;		external 'USER' index 451;
function CreateWindowEx;		external 'USER' index 452;
procedure AdjustWindowRectEx;		external 'USER' index 454;
function DestroyIcon;			external 'USER' index 457;
function DestroyCursor;			external 'USER' index 458;
procedure DrawFocusRect;		external 'USER' index 466;
function lstrcmpi;			external 'USER' index 471;
function AnsiNext;			external 'USER' index 472;
function AnsiPrev;			external 'USER' index 473;

{ SOUND routines }

function OpenSound;			external 'SOUND' index 1;
procedure CloseSound;			external 'SOUND' index 2;
function SetVoiceQueueSize;		external 'SOUND' index 3;
function SetVoiceNote;			external 'SOUND' index 4;
function SetVoiceAccent;		external 'SOUND' index 5;
function SetVoiceEnvelope;		external 'SOUND' index 6;
function SetSoundNoise;			external 'SOUND' index 7;
function SetVoiceSound;			external 'SOUND' index 8;
function StartSound;			external 'SOUND' index 9;
function StopSound;			external 'SOUND' index 10;
function WaitSoundState;		external 'SOUND' index 11;
function SyncAllVoices;			external 'SOUND' index 12;
function CountVoiceNotes;		external 'SOUND' index 13;
function GetThresholdEvent;		external 'SOUND' index 14;
function GetThresholdStatus;		external 'SOUND' index 15;
function SetVoiceThreshold;		external 'SOUND' index 16;

{ KEYBOARD routines }

function ToAscii;                       external 'KEYBOARD' index 4;
function AnsiToOem;			external 'KEYBOARD' index 5;
function OemToAnsi;			external 'KEYBOARD' index 6;
function OemKeyScan;			external 'KEYBOARD' index 128;
function VkKeyScan;			external 'KEYBOARD' index 129;
function GetKeyboardType;		external 'KEYBOARD' index 130;
function MapVirtualKey;			external 'KEYBOARD' index 131;
function GetKBCodePage;			external 'KEYBOARD' index 132;
function GetKeyNameText;		external 'KEYBOARD' index 133;
procedure AnsiToOemBuff;		external 'KEYBOARD' index 134;
procedure OemToAnsiBuff;		external 'KEYBOARD' index 135;

{ Various wrapper routines }

function LockData(Dummy: Integer): THandle;
begin
  LockData := LockSegment($FFFF);
end;

function UnlockData(Dummy: Integer): THandle;
begin
  UnlockData := UnlockSegment($FFFF);
end;

function GlobalDiscard(Mem: THandle): THandle;
begin
  GlobalDiscard := GlobalReAlloc(Mem, 0, gmem_Moveable);
end;

function LocalDiscard(Mem: THandle): THandle; 
begin
  LocalDiscard := LocalReAlloc(Mem, 0, lmem_Moveable);
end;

function LocalLock(Mem: THandle): Pointer; assembler;
asm
	PUSH	Mem
	CALL	_LocalLock
	MOV	DX,DS
end;

end.

