{*****************************************************************
 ***                     WORD SET                              ***
 *****************************************************************}
{The set functions provided with pascal deal only with sets of byte,
but as we have a big program we really need to deal with sets of word,
therefore handling srtypes, cm commands, etc.

I'm not quite sure how the pascal one works, but this is simply a buffer
of 100 words, with routines to add, remove and check}
{$I compflgs}

unit WordSets;

INTERFACE

const
	WordSetSize = 100;


type
	PWordSet = ^TWordSet;
	TWordSet = array[0..WordSetSize] of word;

procedure ClearSet(WordSet : TWordSet);

{returns true if successful}
function AddToSet(WordSet : TWordSet; const W : word) : boolean;
function DeleteFromSet(WordSet : TWordSet; const W : word) : boolean;

{returns true if present}
function InSet(const WordSet : TWordSet; const W : word) : boolean;

IMPLEMENTATION

procedure ClearSet(WordSet : TWordSet);
begin
	FillChar(WordSet, WordSetSize*2, #0);
end;

{returns true if successful}
function AddToSet(WordSet : TWordSet; const W : word) : boolean;
var I : byte;
begin
	{look for first array that is clear}
	I := 0;
	while (I<WordSetSize) and (WordSet[I]<>0) do inc(I);

	if I<=WordSetSize then begin
		WordSet[I] := W;
		AddToSet := True;
	end else
		AddToSet := False;
end;

function DeleteFromSet(WordSet : TWordSet; const W : word) : boolean;
var I : byte;
begin
	{look for first array that is clear}
	I := 0;
	while (I<WordSetSize) and (WordSet[I]<>W) do inc(I);

	if I<=WordSetSize then begin
		WordSet[I] := 0;
		DeleteFromSet := True;
	end else
		DeleteFromSet := False;
end;


{returns true if present}
function InSet(const WordSet : TWordSet; const W : word) : boolean;
var I : byte;
begin
	{look for first array that is clear}
	I := 0;
	while (I<WordSetSize) and (WordSet[I]<>W) do inc(I);

	if I<=WordSetSize then begin
		InSet := True;
	end else
		InSet := False;
end;



end.



